use v6.d;

unit class Tie::StdHash:ver<0.0.9>:auth<zef:lizmat>;

# Note that we *must* have an embedded Hash rather than just subclassing
# from Hash, because .STORE on Hash has different semantics than the
# .STORE that is being expected by tie().
has %.tied;
has $!iterator;

method TIEHASH() { self.new }
method FETCH($k)             is raw { %!tied.AT-KEY($k)           }
method STORE($k,\value)      is raw { %!tied.ASSIGN-KEY($k,value) }
method EXISTS($k --> Bool:D)        { %!tied.EXISTS-KEY($k)       }
method DELETE($k)            is raw { %!tied.DELETE-KEY($k)       }
method CLEAR()                      { %!tied = ()                 }
method FIRSTKEY() {
    $!iterator := %!tied.keys.iterator;
    (my $key := $!iterator.pull-one) =:= IterationEnd ?? Nil !! $key
}
method NEXTKEY(Mu $) {
    (my $key := $!iterator.pull-one) =:= IterationEnd ?? Nil !! $key
}
method SCALAR()  { %!tied.elems }
method UNTIE()   {              }
method DESTROY() {              }

# vim: expandtab shiftwidth=4
