use v6.d;

unit class Tie::StdArray:ver<0.0.8>:auth<zef:lizmat>;

# Note that we *must* have an embedded Array rather than just subclassing
# from Array, because .STORE on Array has different semantics than the
# .STORE that is being expected by tie().
has @.tied;

method TIEARRAY() { self.new }
method FETCH($i)        is raw { @!tied.AT-POS($i)           }
method STORE($i,\value) is raw { @!tied.ASSIGN-POS($i,value) }
method FETCHSIZE()             { @!tied.elems                }
method STORESIZE(\size) {
    my \end = @!tied.end;
    if size > end {
        @!tied.ASSIGN-POS( size - 1, Nil )
    }
    elsif size < end {
        @!tied.splice(size)
    }
}
method EXTEND(\size) {
    if size >= @!tied.elems {
        @!tied.ASSIGN-POS( size - 1, Nil );
        @!tied.splice(size)
    }
}
method EXISTS($i --> Bool:D)        { @!tied.EXISTS-POS($i)               }
method DELETE($i --> Bool:D) is raw { @!tied.DELETE-POS($i)               }
method CLEAR()                      { @!tied = ()                         }
method POP()                 is raw { @!tied.elems ?? @!tied.pop !! Nil   }
method PUSH(\value)          is raw { @!tied.push(value)                  }
method SHIFT()               is raw { @!tied.elems ?? @!tied.shift !! Nil }
method UNSHIFT(\value)       is raw { @!tied.unshift(value)               }
method SPLICE(*@args)               { @!tied.splice(@args)                }
method UNTIE()                      {                                     }
method DESTROY()                    {                                     }

# vim: expandtab shiftwidth=4
