[![Actions Status](https://github.com/lizmat/Text-Emoji/actions/workflows/linux.yml/badge.svg)](https://github.com/lizmat/Text-Emoji/actions) [![Actions Status](https://github.com/lizmat/Text-Emoji/actions/workflows/macos.yml/badge.svg)](https://github.com/lizmat/Text-Emoji/actions) [![Actions Status](https://github.com/lizmat/Text-Emoji/actions/workflows/windows.yml/badge.svg)](https://github.com/lizmat/Text-Emoji/actions)

NAME
====

Text::Emoji - provide :text: to emoji translation

SYNOPSIS
========

```raku
use Text::Emoji;

say to-emoji("I :heart: :beer:");  # I ❤️ 🍺

say to-text(":I: ❤️ 🍺");  # I :heart: :beer:
```

DESCRIPTION
===========

The `Text::Emoji` distribution contains information about transforming `:text:` to emoji transliteration. As such it exports a number of subroutines.

It also installs a convenience script `em` that will convert to emojis any arguments from the command line or from standard input.

SUBROUTINES
===========

to-emoji
--------

```raku
say to-emoji("I :heart: :beer:");                     # I ❤️ 🍺

say to-emoji("I :love: :beer:", :love<❤️>);           # I ❤️ 🍺
say to-emoji("I :love: :beer:", :love<heart>);        # I ❤️ 🍺
say to-emoji("I :love: :beer:", %(love => "❤️"));     # I ❤️ 🍺
say to-emoji("I :love: :beer:", %(love => "heart"));  # I ❤️ 🍺

say to-emoji("baby: :baby-bottle::babybottle:");  # baby: 🍼🍼
```

The `to-emoji` subroutine in its simplest form takes a string as the first argument and attempt to transform any known emoji strings of the form `:word:` into the associated emoji. Note that the word *may* contain hyphens, but they are optional.

Additional mapping info may be specified as additional named arguments, or as a hash. The value for each additional mapping may be either the emoji directly, or the text equivalent of the emoji. Note that all text in these additional mappings, should be in **lowercase** only.

to-text
-------

```raku
say to-text("I ❤️ 🍺");                      # I :heart: :beer:
say to-text("I ❤️ 🍺", :love<❤️>);           # I :love: :beer:
say to-text("I ❤️ 🍺", :love<heart>);        # I :love: :beer:
say to-text("I ❤️ 🍺", %(love => "❤️"));     # I :love: :beer:
say to-text("I ❤️ 🍺", %(love => "heart"));  # I :love: :beer:
```

The `to-text` subroutine in its simplest form takes a string as the first argument and attempt to transform any known emojis to the shortest possible `:word:` form known for that emoji.

The same type of additional map information as can be specified with `to-emoji`, can be specified with `to-text`.

by-tag
------

```raku
say by-tag<birthday>;  # 🥳🎈🎁
say by-tag{/^wh/};     # (😌 🤭 🥃 😫)
```

The `by-tag` subroutine returns a [`Map::Match`](https://raku.land/zef:lizmat/Map::Match) object with the tags found in the raw emoji data, and their associated emojis as a single string. This allows easy searching for tags by a string, but also by a regex.

raw-emoji-data
--------------

```raku
say raw-emoji-data<❤️>.keys;
# (aliases category description emoji ios_version tags unicode_version)
```

The `raw-emoji-data` subroutine returns a `Map`, keyed to the supported emojis. The value associated with is a `Map` as well, which can be best described by its JSON representation:

    {
      "description": "red heart",
      "category": "Smileys & Emotion",
      "aliases": [
        "heart"
      ],
      "tags": [
        "love"
      ],
      "unicode_version": "",
      "ios_version": "6.0"
    }

SCRIPTS
=======

em
--

    $ em I :heart: :beer:
    I ❤️ 🍺

    $ echo I :heart: :beer: | em
    I ❤️ 🍺

The `em` script converts any text given either on the command line, or from STDIN, to emojis where appropriate.

MAPPINGS PROVIDED
=================

Activities
----------

<table class="pod-table">
<thead><tr>
<th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th>
</tr></thead>
<tbody>
<tr> <td>1st-place-medal</td> <td>🥇</td> <td>2nd-place-medal</td> <td>🥈</td> <td>3rd-place-medal</td> <td>🥉</td> </tr> <tr> <td>8ball</td> <td>🎱</td> <td>art</td> <td>🎨</td> <td>badminton</td> <td>🏸</td> </tr> <tr> <td>balloon</td> <td>🎈</td> <td>bamboo</td> <td>🎍</td> <td>baseball</td> <td>⚾</td> </tr> <tr> <td>basketball</td> <td>🏀</td> <td>black-joker</td> <td>🃏</td> <td>bowling</td> <td>🎳</td> </tr> <tr> <td>boxing-glove</td> <td>🥊</td> <td>chess-pawn</td> <td>♟️</td> <td>christmas-tree</td> <td>🎄</td> </tr> <tr> <td>clubs</td> <td>♣️</td> <td>confetti-ball</td> <td>🎊</td> <td>cricket-game</td> <td>🏏</td> </tr> <tr> <td>crystal-ball</td> <td>🔮</td> <td>curling-stone</td> <td>🥌</td> <td>dart</td> <td>🎯</td> </tr> <tr> <td>diamonds</td> <td>♦️</td> <td>diving-mask</td> <td>🤿</td> <td>dolls</td> <td>🎎</td> </tr> <tr> <td>field-hockey</td> <td>🏑</td> <td>firecracker</td> <td>🧨</td> <td>fireworks</td> <td>🎆</td> </tr> <tr> <td>fishing-pole-and-fish</td> <td>🎣</td> <td>flags</td> <td>🎏</td> <td>flower-playing-cards</td> <td>🎴</td> </tr> <tr> <td>flying-disc</td> <td>🥏</td> <td>football</td> <td>🏈</td> <td>framed-picture</td> <td>🖼️</td> </tr> <tr> <td>game-die</td> <td>🎲</td> <td>gift</td> <td>🎁</td> <td>goal-net</td> <td>🥅</td> </tr> <tr> <td>golf</td> <td>⛳</td> <td>gun</td> <td>🔫</td> <td>hearts</td> <td>♥️</td> </tr> <tr> <td>ice-hockey</td> <td>🏒</td> <td>ice-skate</td> <td>⛸️</td> <td>jack-o-lantern</td> <td>🎃</td> </tr> <tr> <td>jigsaw</td> <td>🧩</td> <td>joystick</td> <td>🕹️</td> <td>kite</td> <td>🪁</td> </tr> <tr> <td>knot</td> <td>🪢</td> <td>lacrosse</td> <td>🥍</td> <td>magic-wand</td> <td>🪄</td> </tr> <tr> <td>mahjong</td> <td>🀄</td> <td>martial-arts-uniform</td> <td>🥋</td> <td>medal-military</td> <td>🎖️</td> </tr> <tr> <td>medal-sports</td> <td>🏅</td> <td>mirror-ball</td> <td>🪩</td> <td>nesting-dolls</td> <td>🪆</td> </tr> <tr> <td>performing-arts</td> <td>🎭</td> <td>pinata</td> <td>🪅</td> <td>ping-pong</td> <td>🏓</td> </tr> <tr> <td>red-envelope</td> <td>🧧</td> <td>reminder-ribbon</td> <td>🎗️</td> <td>ribbon</td> <td>🎀</td> </tr> <tr> <td>rice-scene</td> <td>🎑</td> <td>rugby-football</td> <td>🏉</td> <td>running-shirt-with-sash</td> <td>🎽</td> </tr> <tr> <td>sewing-needle</td> <td>🪡</td> <td>ski</td> <td>🎿</td> <td>sled</td> <td>🛷</td> </tr> <tr> <td>slot-machine</td> <td>🎰</td> <td>soccer</td> <td>⚽</td> <td>softball</td> <td>🥎</td> </tr> <tr> <td>spades</td> <td>♠️</td> <td>sparkler</td> <td>🎇</td> <td>sparkles</td> <td>✨</td> </tr> <tr> <td>tada</td> <td>🎉</td> <td>tanabata-tree</td> <td>🎋</td> <td>teddy-bear</td> <td>🧸</td> </tr> <tr> <td>tennis</td> <td>🎾</td> <td>thread</td> <td>🧵</td> <td>ticket</td> <td>🎫</td> </tr> <tr> <td>tickets</td> <td>🎟️</td> <td>trophy</td> <td>🏆</td> <td>video-game</td> <td>🎮</td> </tr> <tr> <td>volleyball</td> <td>🏐</td> <td>wind-chime</td> <td>🎐</td> <td>yarn</td> <td>🧶</td> </tr> <tr> <td>yo-yo</td> <td>🪀</td> <td></td> <td></td> <td></td> <td></td> </tr>
</tbody>
</table>

Animals & Nature
----------------

<table class="pod-table">
<thead><tr>
<th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th>
</tr></thead>
<tbody>
<tr> <td>ant</td> <td>🐜</td> <td>baby-chick</td> <td>🐤</td> <td>badger</td> <td>🦡</td> </tr> <tr> <td>bat</td> <td>🦇</td> <td>bear</td> <td>🐻</td> <td>beaver</td> <td>🦫</td> </tr> <tr> <td>bee</td> <td>🐝</td> <td>beetle</td> <td>🪲</td> <td>bird</td> <td>🐦</td> </tr> <tr> <td>bison</td> <td>🦬</td> <td>black-bird</td> <td>🐦‍⬛</td> <td>black-cat</td> <td>🐈‍⬛</td> </tr> <tr> <td>blossom</td> <td>🌼</td> <td>blowfish</td> <td>🐡</td> <td>boar</td> <td>🐗</td> </tr> <tr> <td>bouquet</td> <td>💐</td> <td>bug</td> <td>🐛</td> <td>butterfly</td> <td>🦋</td> </tr> <tr> <td>cactus</td> <td>🌵</td> <td>camel</td> <td>🐫</td> <td>cat</td> <td>🐱</td> </tr> <tr> <td>cat2</td> <td>🐈</td> <td>cherry-blossom</td> <td>🌸</td> <td>chicken</td> <td>🐔</td> </tr> <tr> <td>chipmunk</td> <td>🐿️</td> <td>cockroach</td> <td>🪳</td> <td>coral</td> <td>🪸</td> </tr> <tr> <td>cow</td> <td>🐮</td> <td>cow2</td> <td>🐄</td> <td>cricket</td> <td>🦗</td> </tr> <tr> <td>crocodile</td> <td>🐊</td> <td>deciduous-tree</td> <td>🌳</td> <td>deer</td> <td>🦌</td> </tr> <tr> <td>dodo</td> <td>🦤</td> <td>dog</td> <td>🐶</td> <td>dog2</td> <td>🐕</td> </tr> <tr> <td>dolphin</td> <td>🐬</td> <td>donkey</td> <td>🫏</td> <td>dove</td> <td>🕊️</td> </tr> <tr> <td>dragon</td> <td>🐉</td> <td>dragon-face</td> <td>🐲</td> <td>dromedary-camel</td> <td>🐪</td> </tr> <tr> <td>duck</td> <td>🦆</td> <td>eagle</td> <td>🦅</td> <td>ear-of-rice</td> <td>🌾</td> </tr> <tr> <td>elephant</td> <td>🐘</td> <td>empty-nest</td> <td>🪹</td> <td>evergreen-tree</td> <td>🌲</td> </tr> <tr> <td>fallen-leaf</td> <td>🍂</td> <td>feather</td> <td>🪶</td> <td>feet</td> <td>🐾</td> </tr> <tr> <td>fish</td> <td>🐟</td> <td>flamingo</td> <td>🦩</td> <td>fly</td> <td>🪰</td> </tr> <tr> <td>four-leaf-clover</td> <td>🍀</td> <td>fox-face</td> <td>🦊</td> <td>frog</td> <td>🐸</td> </tr> <tr> <td>giraffe</td> <td>🦒</td> <td>goat</td> <td>🐐</td> <td>goose</td> <td>🪿</td> </tr> <tr> <td>gorilla</td> <td>🦍</td> <td>guide-dog</td> <td>🦮</td> <td>hamster</td> <td>🐹</td> </tr> <tr> <td>hatched-chick</td> <td>🐥</td> <td>hatching-chick</td> <td>🐣</td> <td>hedgehog</td> <td>🦔</td> </tr> <tr> <td>herb</td> <td>🌿</td> <td>hibiscus</td> <td>🌺</td> <td>hippopotamus</td> <td>🦛</td> </tr> <tr> <td>horse</td> <td>🐴</td> <td>hyacinth</td> <td>🪻</td> <td>jellyfish</td> <td>🪼</td> </tr> <tr> <td>kangaroo</td> <td>🦘</td> <td>koala</td> <td>🐨</td> <td>lady-beetle</td> <td>🐞</td> </tr> <tr> <td>leaves</td> <td>🍃</td> <td>leopard</td> <td>🐆</td> <td>lion</td> <td>🦁</td> </tr> <tr> <td>lizard</td> <td>🦎</td> <td>llama</td> <td>🦙</td> <td>lotus</td> <td>🪷</td> </tr> <tr> <td>mammoth</td> <td>🦣</td> <td>maple-leaf</td> <td>🍁</td> <td>microbe</td> <td>🦠</td> </tr> <tr> <td>monkey</td> <td>🐒</td> <td>monkey-face</td> <td>🐵</td> <td>moose</td> <td>🫎</td> </tr> <tr> <td>mosquito</td> <td>🦟</td> <td>mouse</td> <td>🐭</td> <td>mouse2</td> <td>🐁</td> </tr> <tr> <td>mushroom</td> <td>🍄</td> <td>nest-with-eggs</td> <td>🪺</td> <td>octopus</td> <td>🐙</td> </tr> <tr> <td>orangutan</td> <td>🦧</td> <td>otter</td> <td>🦦</td> <td>owl</td> <td>🦉</td> </tr> <tr> <td>ox</td> <td>🐂</td> <td>palm-tree</td> <td>🌴</td> <td>panda-face</td> <td>🐼</td> </tr> <tr> <td>parrot</td> <td>🦜</td> <td>peacock</td> <td>🦚</td> <td>penguin</td> <td>🐧</td> </tr> <tr> <td>pig</td> <td>🐷</td> <td>pig-nose</td> <td>🐽</td> <td>pig2</td> <td>🐖</td> </tr> <tr> <td>polar-bear</td> <td>🐻‍❄️</td> <td>poodle</td> <td>🐩</td> <td>potted-plant</td> <td>🪴</td> </tr> <tr> <td>rabbit</td> <td>🐰</td> <td>rabbit2</td> <td>🐇</td> <td>raccoon</td> <td>🦝</td> </tr> <tr> <td>racehorse</td> <td>🐎</td> <td>ram</td> <td>🐏</td> <td>rat</td> <td>🐀</td> </tr> <tr> <td>rhinoceros</td> <td>🦏</td> <td>rooster</td> <td>🐓</td> <td>rose</td> <td>🌹</td> </tr> <tr> <td>rosette</td> <td>🏵️</td> <td>sauropod</td> <td>🦕</td> <td>scorpion</td> <td>🦂</td> </tr> <tr> <td>seal</td> <td>🦭</td> <td>seedling</td> <td>🌱</td> <td>service-dog</td> <td>🐕‍🦺</td> </tr> <tr> <td>shamrock</td> <td>☘️</td> <td>shark</td> <td>🦈</td> <td>sheep</td> <td>🐑</td> </tr> <tr> <td>shell</td> <td>🐚</td> <td>skunk</td> <td>🦨</td> <td>sloth</td> <td>🦥</td> </tr> <tr> <td>snail</td> <td>🐌</td> <td>snake</td> <td>🐍</td> <td>spider</td> <td>🕷️</td> </tr> <tr> <td>spider-web</td> <td>🕸️</td> <td>sunflower</td> <td>🌻</td> <td>swan</td> <td>🦢</td> </tr> <tr> <td>t-rex</td> <td>🦖</td> <td>tiger</td> <td>🐯</td> <td>tiger2</td> <td>🐅</td> </tr> <tr> <td>tropical-fish</td> <td>🐠</td> <td>tulip</td> <td>🌷</td> <td>turkey</td> <td>🦃</td> </tr> <tr> <td>turtle</td> <td>🐢</td> <td>unicorn</td> <td>🦄</td> <td>water-buffalo</td> <td>🐃</td> </tr> <tr> <td>whale</td> <td>🐳</td> <td>whale2</td> <td>🐋</td> <td>white-flower</td> <td>💮</td> </tr> <tr> <td>wilted-flower</td> <td>🥀</td> <td>wing</td> <td>🪽</td> <td>wolf</td> <td>🐺</td> </tr> <tr> <td>worm</td> <td>🪱</td> <td>zebra</td> <td>🦓</td> <td></td> <td></td> </tr>
</tbody>
</table>

Flags
-----

<table class="pod-table">
<thead><tr>
<th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th>
</tr></thead>
<tbody>
<tr> <td>afghanistan</td> <td>🇦🇫</td> <td>aland-islands</td> <td>🇦🇽</td> <td>albania</td> <td>🇦🇱</td> </tr> <tr> <td>algeria</td> <td>🇩🇿</td> <td>american-samoa</td> <td>🇦🇸</td> <td>andorra</td> <td>🇦🇩</td> </tr> <tr> <td>angola</td> <td>🇦🇴</td> <td>anguilla</td> <td>🇦🇮</td> <td>antarctica</td> <td>🇦🇶</td> </tr> <tr> <td>antigua-barbuda</td> <td>🇦🇬</td> <td>argentina</td> <td>🇦🇷</td> <td>armenia</td> <td>🇦🇲</td> </tr> <tr> <td>aruba</td> <td>🇦🇼</td> <td>ascension-island</td> <td>🇦🇨</td> <td>australia</td> <td>🇦🇺</td> </tr> <tr> <td>austria</td> <td>🇦🇹</td> <td>azerbaijan</td> <td>🇦🇿</td> <td>bahamas</td> <td>🇧🇸</td> </tr> <tr> <td>bahrain</td> <td>🇧🇭</td> <td>bangladesh</td> <td>🇧🇩</td> <td>barbados</td> <td>🇧🇧</td> </tr> <tr> <td>belarus</td> <td>🇧🇾</td> <td>belgium</td> <td>🇧🇪</td> <td>belize</td> <td>🇧🇿</td> </tr> <tr> <td>benin</td> <td>🇧🇯</td> <td>bermuda</td> <td>🇧🇲</td> <td>bhutan</td> <td>🇧🇹</td> </tr> <tr> <td>black-flag</td> <td>🏴</td> <td>bolivia</td> <td>🇧🇴</td> <td>bosnia-herzegovina</td> <td>🇧🇦</td> </tr> <tr> <td>botswana</td> <td>🇧🇼</td> <td>bouvet-island</td> <td>🇧🇻</td> <td>brazil</td> <td>🇧🇷</td> </tr> <tr> <td>british-indian-ocean-territory</td> <td>🇮🇴</td> <td>british-virgin-islands</td> <td>🇻🇬</td> <td>brunei</td> <td>🇧🇳</td> </tr> <tr> <td>bulgaria</td> <td>🇧🇬</td> <td>burkina-faso</td> <td>🇧🇫</td> <td>burundi</td> <td>🇧🇮</td> </tr> <tr> <td>cambodia</td> <td>🇰🇭</td> <td>cameroon</td> <td>🇨🇲</td> <td>canada</td> <td>🇨🇦</td> </tr> <tr> <td>canary-islands</td> <td>🇮🇨</td> <td>cape-verde</td> <td>🇨🇻</td> <td>caribbean-netherlands</td> <td>🇧🇶</td> </tr> <tr> <td>cayman-islands</td> <td>🇰🇾</td> <td>central-african-republic</td> <td>🇨🇫</td> <td>ceuta-melilla</td> <td>🇪🇦</td> </tr> <tr> <td>chad</td> <td>🇹🇩</td> <td>checkered-flag</td> <td>🏁</td> <td>chile</td> <td>🇨🇱</td> </tr> <tr> <td>christmas-island</td> <td>🇨🇽</td> <td>clipperton-island</td> <td>🇨🇵</td> <td>cn</td> <td>🇨🇳</td> </tr> <tr> <td>cocos-islands</td> <td>🇨🇨</td> <td>colombia</td> <td>🇨🇴</td> <td>comoros</td> <td>🇰🇲</td> </tr> <tr> <td>congo-brazzaville</td> <td>🇨🇬</td> <td>congo-kinshasa</td> <td>🇨🇩</td> <td>cook-islands</td> <td>🇨🇰</td> </tr> <tr> <td>costa-rica</td> <td>🇨🇷</td> <td>cote-divoire</td> <td>🇨🇮</td> <td>croatia</td> <td>🇭🇷</td> </tr> <tr> <td>crossed-flags</td> <td>🎌</td> <td>cuba</td> <td>🇨🇺</td> <td>curacao</td> <td>🇨🇼</td> </tr> <tr> <td>cyprus</td> <td>🇨🇾</td> <td>czech-republic</td> <td>🇨🇿</td> <td>de</td> <td>🇩🇪</td> </tr> <tr> <td>denmark</td> <td>🇩🇰</td> <td>diego-garcia</td> <td>🇩🇬</td> <td>djibouti</td> <td>🇩🇯</td> </tr> <tr> <td>dominica</td> <td>🇩🇲</td> <td>dominican-republic</td> <td>🇩🇴</td> <td>ecuador</td> <td>🇪🇨</td> </tr> <tr> <td>egypt</td> <td>🇪🇬</td> <td>el-salvador</td> <td>🇸🇻</td> <td>england</td> <td>🏴󠁧󠁢󠁥󠁮󠁧󠁿</td> </tr> <tr> <td>equatorial-guinea</td> <td>🇬🇶</td> <td>eritrea</td> <td>🇪🇷</td> <td>es</td> <td>🇪🇸</td> </tr> <tr> <td>estonia</td> <td>🇪🇪</td> <td>ethiopia</td> <td>🇪🇹</td> <td>eu</td> <td>🇪🇺</td> </tr> <tr> <td>falkland-islands</td> <td>🇫🇰</td> <td>faroe-islands</td> <td>🇫🇴</td> <td>fiji</td> <td>🇫🇯</td> </tr> <tr> <td>finland</td> <td>🇫🇮</td> <td>fr</td> <td>🇫🇷</td> <td>french-guiana</td> <td>🇬🇫</td> </tr> <tr> <td>french-polynesia</td> <td>🇵🇫</td> <td>french-southern-territories</td> <td>🇹🇫</td> <td>gabon</td> <td>🇬🇦</td> </tr> <tr> <td>gambia</td> <td>🇬🇲</td> <td>gb</td> <td>🇬🇧</td> <td>georgia</td> <td>🇬🇪</td> </tr> <tr> <td>ghana</td> <td>🇬🇭</td> <td>gibraltar</td> <td>🇬🇮</td> <td>greece</td> <td>🇬🇷</td> </tr> <tr> <td>greenland</td> <td>🇬🇱</td> <td>grenada</td> <td>🇬🇩</td> <td>guadeloupe</td> <td>🇬🇵</td> </tr> <tr> <td>guam</td> <td>🇬🇺</td> <td>guatemala</td> <td>🇬🇹</td> <td>guernsey</td> <td>🇬🇬</td> </tr> <tr> <td>guinea</td> <td>🇬🇳</td> <td>guinea-bissau</td> <td>🇬🇼</td> <td>guyana</td> <td>🇬🇾</td> </tr> <tr> <td>haiti</td> <td>🇭🇹</td> <td>heard-mcdonald-islands</td> <td>🇭🇲</td> <td>honduras</td> <td>🇭🇳</td> </tr> <tr> <td>hong-kong</td> <td>🇭🇰</td> <td>hungary</td> <td>🇭🇺</td> <td>iceland</td> <td>🇮🇸</td> </tr> <tr> <td>india</td> <td>🇮🇳</td> <td>indonesia</td> <td>🇮🇩</td> <td>iran</td> <td>🇮🇷</td> </tr> <tr> <td>iraq</td> <td>🇮🇶</td> <td>ireland</td> <td>🇮🇪</td> <td>isle-of-man</td> <td>🇮🇲</td> </tr> <tr> <td>israel</td> <td>🇮🇱</td> <td>it</td> <td>🇮🇹</td> <td>jamaica</td> <td>🇯🇲</td> </tr> <tr> <td>jersey</td> <td>🇯🇪</td> <td>jordan</td> <td>🇯🇴</td> <td>jp</td> <td>🇯🇵</td> </tr> <tr> <td>kazakhstan</td> <td>🇰🇿</td> <td>kenya</td> <td>🇰🇪</td> <td>kiribati</td> <td>🇰🇮</td> </tr> <tr> <td>kosovo</td> <td>🇽🇰</td> <td>kr</td> <td>🇰🇷</td> <td>kuwait</td> <td>🇰🇼</td> </tr> <tr> <td>kyrgyzstan</td> <td>🇰🇬</td> <td>laos</td> <td>🇱🇦</td> <td>latvia</td> <td>🇱🇻</td> </tr> <tr> <td>lebanon</td> <td>🇱🇧</td> <td>lesotho</td> <td>🇱🇸</td> <td>liberia</td> <td>🇱🇷</td> </tr> <tr> <td>libya</td> <td>🇱🇾</td> <td>liechtenstein</td> <td>🇱🇮</td> <td>lithuania</td> <td>🇱🇹</td> </tr> <tr> <td>luxembourg</td> <td>🇱🇺</td> <td>macau</td> <td>🇲🇴</td> <td>macedonia</td> <td>🇲🇰</td> </tr> <tr> <td>madagascar</td> <td>🇲🇬</td> <td>malawi</td> <td>🇲🇼</td> <td>malaysia</td> <td>🇲🇾</td> </tr> <tr> <td>maldives</td> <td>🇲🇻</td> <td>mali</td> <td>🇲🇱</td> <td>malta</td> <td>🇲🇹</td> </tr> <tr> <td>marshall-islands</td> <td>🇲🇭</td> <td>martinique</td> <td>🇲🇶</td> <td>mauritania</td> <td>🇲🇷</td> </tr> <tr> <td>mauritius</td> <td>🇲🇺</td> <td>mayotte</td> <td>🇾🇹</td> <td>mexico</td> <td>🇲🇽</td> </tr> <tr> <td>micronesia</td> <td>🇫🇲</td> <td>moldova</td> <td>🇲🇩</td> <td>monaco</td> <td>🇲🇨</td> </tr> <tr> <td>mongolia</td> <td>🇲🇳</td> <td>montenegro</td> <td>🇲🇪</td> <td>montserrat</td> <td>🇲🇸</td> </tr> <tr> <td>morocco</td> <td>🇲🇦</td> <td>mozambique</td> <td>🇲🇿</td> <td>myanmar</td> <td>🇲🇲</td> </tr> <tr> <td>namibia</td> <td>🇳🇦</td> <td>nauru</td> <td>🇳🇷</td> <td>nepal</td> <td>🇳🇵</td> </tr> <tr> <td>netherlands</td> <td>🇳🇱</td> <td>new-caledonia</td> <td>🇳🇨</td> <td>new-zealand</td> <td>🇳🇿</td> </tr> <tr> <td>nicaragua</td> <td>🇳🇮</td> <td>niger</td> <td>🇳🇪</td> <td>nigeria</td> <td>🇳🇬</td> </tr> <tr> <td>niue</td> <td>🇳🇺</td> <td>norfolk-island</td> <td>🇳🇫</td> <td>north-korea</td> <td>🇰🇵</td> </tr> <tr> <td>northern-mariana-islands</td> <td>🇲🇵</td> <td>norway</td> <td>🇳🇴</td> <td>oman</td> <td>🇴🇲</td> </tr> <tr> <td>pakistan</td> <td>🇵🇰</td> <td>palau</td> <td>🇵🇼</td> <td>palestinian-territories</td> <td>🇵🇸</td> </tr> <tr> <td>panama</td> <td>🇵🇦</td> <td>papua-new-guinea</td> <td>🇵🇬</td> <td>paraguay</td> <td>🇵🇾</td> </tr> <tr> <td>peru</td> <td>🇵🇪</td> <td>philippines</td> <td>🇵🇭</td> <td>pirate-flag</td> <td>🏴‍☠️</td> </tr> <tr> <td>pitcairn-islands</td> <td>🇵🇳</td> <td>poland</td> <td>🇵🇱</td> <td>portugal</td> <td>🇵🇹</td> </tr> <tr> <td>puerto-rico</td> <td>🇵🇷</td> <td>qatar</td> <td>🇶🇦</td> <td>rainbow-flag</td> <td>🏳️‍🌈</td> </tr> <tr> <td>reunion</td> <td>🇷🇪</td> <td>romania</td> <td>🇷🇴</td> <td>ru</td> <td>🇷🇺</td> </tr> <tr> <td>rwanda</td> <td>🇷🇼</td> <td>samoa</td> <td>🇼🇸</td> <td>san-marino</td> <td>🇸🇲</td> </tr> <tr> <td>sao-tome-principe</td> <td>🇸🇹</td> <td>saudi-arabia</td> <td>🇸🇦</td> <td>scotland</td> <td>🏴󠁧󠁢󠁳󠁣󠁴󠁿</td> </tr> <tr> <td>senegal</td> <td>🇸🇳</td> <td>serbia</td> <td>🇷🇸</td> <td>seychelles</td> <td>🇸🇨</td> </tr> <tr> <td>sierra-leone</td> <td>🇸🇱</td> <td>singapore</td> <td>🇸🇬</td> <td>sint-maarten</td> <td>🇸🇽</td> </tr> <tr> <td>slovakia</td> <td>🇸🇰</td> <td>slovenia</td> <td>🇸🇮</td> <td>solomon-islands</td> <td>🇸🇧</td> </tr> <tr> <td>somalia</td> <td>🇸🇴</td> <td>south-africa</td> <td>🇿🇦</td> <td>south-georgia-south-sandwich-islands</td> <td>🇬🇸</td> </tr> <tr> <td>south-sudan</td> <td>🇸🇸</td> <td>sri-lanka</td> <td>🇱🇰</td> <td>st-barthelemy</td> <td>🇧🇱</td> </tr> <tr> <td>st-helena</td> <td>🇸🇭</td> <td>st-kitts-nevis</td> <td>🇰🇳</td> <td>st-lucia</td> <td>🇱🇨</td> </tr> <tr> <td>st-martin</td> <td>🇲🇫</td> <td>st-pierre-miquelon</td> <td>🇵🇲</td> <td>st-vincent-grenadines</td> <td>🇻🇨</td> </tr> <tr> <td>sudan</td> <td>🇸🇩</td> <td>suriname</td> <td>🇸🇷</td> <td>svalbard-jan-mayen</td> <td>🇸🇯</td> </tr> <tr> <td>swaziland</td> <td>🇸🇿</td> <td>sweden</td> <td>🇸🇪</td> <td>switzerland</td> <td>🇨🇭</td> </tr> <tr> <td>syria</td> <td>🇸🇾</td> <td>taiwan</td> <td>🇹🇼</td> <td>tajikistan</td> <td>🇹🇯</td> </tr> <tr> <td>tanzania</td> <td>🇹🇿</td> <td>thailand</td> <td>🇹🇭</td> <td>timor-leste</td> <td>🇹🇱</td> </tr> <tr> <td>togo</td> <td>🇹🇬</td> <td>tokelau</td> <td>🇹🇰</td> <td>tonga</td> <td>🇹🇴</td> </tr> <tr> <td>tr</td> <td>🇹🇷</td> <td>transgender-flag</td> <td>🏳️‍⚧️</td> <td>triangular-flag-on-post</td> <td>🚩</td> </tr> <tr> <td>trinidad-tobago</td> <td>🇹🇹</td> <td>tristan-da-cunha</td> <td>🇹🇦</td> <td>tunisia</td> <td>🇹🇳</td> </tr> <tr> <td>turkmenistan</td> <td>🇹🇲</td> <td>turks-caicos-islands</td> <td>🇹🇨</td> <td>tuvalu</td> <td>🇹🇻</td> </tr> <tr> <td>uganda</td> <td>🇺🇬</td> <td>ukraine</td> <td>🇺🇦</td> <td>united-arab-emirates</td> <td>🇦🇪</td> </tr> <tr> <td>united-nations</td> <td>🇺🇳</td> <td>uruguay</td> <td>🇺🇾</td> <td>us</td> <td>🇺🇸</td> </tr> <tr> <td>us-outlying-islands</td> <td>🇺🇲</td> <td>us-virgin-islands</td> <td>🇻🇮</td> <td>uzbekistan</td> <td>🇺🇿</td> </tr> <tr> <td>vanuatu</td> <td>🇻🇺</td> <td>vatican-city</td> <td>🇻🇦</td> <td>venezuela</td> <td>🇻🇪</td> </tr> <tr> <td>vietnam</td> <td>🇻🇳</td> <td>wales</td> <td>🏴󠁧󠁢󠁷󠁬󠁳󠁿</td> <td>wallis-futuna</td> <td>🇼🇫</td> </tr> <tr> <td>western-sahara</td> <td>🇪🇭</td> <td>white-flag</td> <td>🏳️</td> <td>yemen</td> <td>🇾🇪</td> </tr> <tr> <td>zambia</td> <td>🇿🇲</td> <td>zimbabwe</td> <td>🇿🇼</td> <td></td> <td></td> </tr>
</tbody>
</table>

Food & Drink
------------

<table class="pod-table">
<thead><tr>
<th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th>
</tr></thead>
<tbody>
<tr> <td>amphora</td> <td>🏺</td> <td>apple</td> <td>🍎</td> <td>avocado</td> <td>🥑</td> </tr> <tr> <td>baby-bottle</td> <td>🍼</td> <td>bacon</td> <td>🥓</td> <td>bagel</td> <td>🥯</td> </tr> <tr> <td>baguette-bread</td> <td>🥖</td> <td>banana</td> <td>🍌</td> <td>beans</td> <td>🫘</td> </tr> <tr> <td>beer</td> <td>🍺</td> <td>beers</td> <td>🍻</td> <td>bell-pepper</td> <td>🫑</td> </tr> <tr> <td>bento</td> <td>🍱</td> <td>beverage-box</td> <td>🧃</td> <td>birthday</td> <td>🎂</td> </tr> <tr> <td>blueberries</td> <td>🫐</td> <td>bowl-with-spoon</td> <td>🥣</td> <td>bread</td> <td>🍞</td> </tr> <tr> <td>broccoli</td> <td>🥦</td> <td>bubble-tea</td> <td>🧋</td> <td>burrito</td> <td>🌯</td> </tr> <tr> <td>butter</td> <td>🧈</td> <td>cake</td> <td>🍰</td> <td>candy</td> <td>🍬</td> </tr> <tr> <td>canned-food</td> <td>🥫</td> <td>carrot</td> <td>🥕</td> <td>champagne</td> <td>🍾</td> </tr> <tr> <td>cheese</td> <td>🧀</td> <td>cherries</td> <td>🍒</td> <td>chestnut</td> <td>🌰</td> </tr> <tr> <td>chocolate-bar</td> <td>🍫</td> <td>chopsticks</td> <td>🥢</td> <td>clinking-glasses</td> <td>🥂</td> </tr> <tr> <td>cocktail</td> <td>🍸</td> <td>coconut</td> <td>🥥</td> <td>coffee</td> <td>☕</td> </tr> <tr> <td>cookie</td> <td>🍪</td> <td>corn</td> <td>🌽</td> <td>crab</td> <td>🦀</td> </tr> <tr> <td>croissant</td> <td>🥐</td> <td>cucumber</td> <td>🥒</td> <td>cup-with-straw</td> <td>🥤</td> </tr> <tr> <td>cupcake</td> <td>🧁</td> <td>curry</td> <td>🍛</td> <td>custard</td> <td>🍮</td> </tr> <tr> <td>cut-of-meat</td> <td>🥩</td> <td>dango</td> <td>🍡</td> <td>doughnut</td> <td>🍩</td> </tr> <tr> <td>dumpling</td> <td>🥟</td> <td>egg</td> <td>🥚</td> <td>eggplant</td> <td>🍆</td> </tr> <tr> <td>falafel</td> <td>🧆</td> <td>fish-cake</td> <td>🍥</td> <td>flatbread</td> <td>🫓</td> </tr> <tr> <td>fondue</td> <td>🫕</td> <td>fork-and-knife</td> <td>🍴</td> <td>fortune-cookie</td> <td>🥠</td> </tr> <tr> <td>fried-egg</td> <td>🍳</td> <td>fried-shrimp</td> <td>🍤</td> <td>fries</td> <td>🍟</td> </tr> <tr> <td>garlic</td> <td>🧄</td> <td>ginger-root</td> <td>🫚</td> <td>grapes</td> <td>🍇</td> </tr> <tr> <td>green-apple</td> <td>🍏</td> <td>green-salad</td> <td>🥗</td> <td>hamburger</td> <td>🍔</td> </tr> <tr> <td>hocho</td> <td>🔪</td> <td>honey-pot</td> <td>🍯</td> <td>hot-pepper</td> <td>🌶️</td> </tr> <tr> <td>hotdog</td> <td>🌭</td> <td>ice-cream</td> <td>🍨</td> <td>ice-cube</td> <td>🧊</td> </tr> <tr> <td>icecream</td> <td>🍦</td> <td>jar</td> <td>🫙</td> <td>kiwi-fruit</td> <td>🥝</td> </tr> <tr> <td>leafy-green</td> <td>🥬</td> <td>lemon</td> <td>🍋</td> <td>lobster</td> <td>🦞</td> </tr> <tr> <td>lollipop</td> <td>🍭</td> <td>mango</td> <td>🥭</td> <td>mate</td> <td>🧉</td> </tr> <tr> <td>meat-on-bone</td> <td>🍖</td> <td>melon</td> <td>🍈</td> <td>milk-glass</td> <td>🥛</td> </tr> <tr> <td>moon-cake</td> <td>🥮</td> <td>oden</td> <td>🍢</td> <td>olive</td> <td>🫒</td> </tr> <tr> <td>onion</td> <td>🧅</td> <td>oyster</td> <td>🦪</td> <td>pancakes</td> <td>🥞</td> </tr> <tr> <td>pea-pod</td> <td>🫛</td> <td>peach</td> <td>🍑</td> <td>peanuts</td> <td>🥜</td> </tr> <tr> <td>pear</td> <td>🍐</td> <td>pie</td> <td>🥧</td> <td>pineapple</td> <td>🍍</td> </tr> <tr> <td>pizza</td> <td>🍕</td> <td>plate-with-cutlery</td> <td>🍽️</td> <td>popcorn</td> <td>🍿</td> </tr> <tr> <td>potato</td> <td>🥔</td> <td>poultry-leg</td> <td>🍗</td> <td>pouring-liquid</td> <td>🫗</td> </tr> <tr> <td>pretzel</td> <td>🥨</td> <td>ramen</td> <td>🍜</td> <td>rice</td> <td>🍚</td> </tr> <tr> <td>rice-ball</td> <td>🍙</td> <td>rice-cracker</td> <td>🍘</td> <td>sake</td> <td>🍶</td> </tr> <tr> <td>salt</td> <td>🧂</td> <td>sandwich</td> <td>🥪</td> <td>shallow-pan-of-food</td> <td>🥘</td> </tr> <tr> <td>shaved-ice</td> <td>🍧</td> <td>shrimp</td> <td>🦐</td> <td>spaghetti</td> <td>🍝</td> </tr> <tr> <td>spoon</td> <td>🥄</td> <td>squid</td> <td>🦑</td> <td>stew</td> <td>🍲</td> </tr> <tr> <td>strawberry</td> <td>🍓</td> <td>stuffed-flatbread</td> <td>🥙</td> <td>sushi</td> <td>🍣</td> </tr> <tr> <td>sweet-potato</td> <td>🍠</td> <td>taco</td> <td>🌮</td> <td>takeout-box</td> <td>🥡</td> </tr> <tr> <td>tamale</td> <td>🫔</td> <td>tangerine</td> <td>🍊</td> <td>tea</td> <td>🍵</td> </tr> <tr> <td>teapot</td> <td>🫖</td> <td>tomato</td> <td>🍅</td> <td>tropical-drink</td> <td>🍹</td> </tr> <tr> <td>tumbler-glass</td> <td>🥃</td> <td>waffle</td> <td>🧇</td> <td>watermelon</td> <td>🍉</td> </tr> <tr> <td>wine-glass</td> <td>🍷</td> <td></td> <td></td> <td></td> <td></td> </tr>
</tbody>
</table>

Objects
-------

<table class="pod-table">
<thead><tr>
<th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th>
</tr></thead>
<tbody>
<tr> <td>abacus</td> <td>🧮</td> <td>accordion</td> <td>🪗</td> <td>adhesive-bandage</td> <td>🩹</td> </tr> <tr> <td>alembic</td> <td>⚗️</td> <td>athletic-shoe</td> <td>👟</td> <td>axe</td> <td>🪓</td> </tr> <tr> <td>balance-scale</td> <td>⚖️</td> <td>ballet-shoes</td> <td>🩰</td> <td>ballot-box</td> <td>🗳️</td> </tr> <tr> <td>banjo</td> <td>🪕</td> <td>bar-chart</td> <td>📊</td> <td>basket</td> <td>🧺</td> </tr> <tr> <td>bathtub</td> <td>🛁</td> <td>battery</td> <td>🔋</td> <td>bed</td> <td>🛏️</td> </tr> <tr> <td>bell</td> <td>🔔</td> <td>bikini</td> <td>👙</td> <td>billed-cap</td> <td>🧢</td> </tr> <tr> <td>black-nib</td> <td>✒️</td> <td>blue-book</td> <td>📘</td> <td>bomb</td> <td>💣</td> </tr> <tr> <td>book</td> <td>📖</td> <td>bookmark</td> <td>🔖</td> <td>bookmark-tabs</td> <td>📑</td> </tr> <tr> <td>books</td> <td>📚</td> <td>boomerang</td> <td>🪃</td> <td>boot</td> <td>👢</td> </tr> <tr> <td>bow-and-arrow</td> <td>🏹</td> <td>briefcase</td> <td>💼</td> <td>broom</td> <td>🧹</td> </tr> <tr> <td>bubbles</td> <td>🫧</td> <td>bucket</td> <td>🪣</td> <td>bulb</td> <td>💡</td> </tr> <tr> <td>calendar</td> <td>📆</td> <td>calling</td> <td>📲</td> <td>camera</td> <td>📷</td> </tr> <tr> <td>camera-flash</td> <td>📸</td> <td>candle</td> <td>🕯️</td> <td>card-file-box</td> <td>🗃️</td> </tr> <tr> <td>card-index</td> <td>📇</td> <td>card-index-dividers</td> <td>🗂️</td> <td>carpentry-saw</td> <td>🪚</td> </tr> <tr> <td>cd</td> <td>💿</td> <td>chains</td> <td>⛓️</td> <td>chair</td> <td>🪑</td> </tr> <tr> <td>chart</td> <td>💹</td> <td>chart-with-downwards-trend</td> <td>📉</td> <td>chart-with-upwards-trend</td> <td>📈</td> </tr> <tr> <td>clamp</td> <td>🗜️</td> <td>clapper</td> <td>🎬</td> <td>clipboard</td> <td>📋</td> </tr> <tr> <td>closed-book</td> <td>📕</td> <td>closed-lock-with-key</td> <td>🔐</td> <td>coat</td> <td>🧥</td> </tr> <tr> <td>coffin</td> <td>⚰️</td> <td>coin</td> <td>🪙</td> <td>computer</td> <td>💻</td> </tr> <tr> <td>computer-mouse</td> <td>🖱️</td> <td>control-knobs</td> <td>🎛️</td> <td>couch-and-lamp</td> <td>🛋️</td> </tr> <tr> <td>crayon</td> <td>🖍️</td> <td>credit-card</td> <td>💳</td> <td>crossed-swords</td> <td>⚔️</td> </tr> <tr> <td>crown</td> <td>👑</td> <td>crutch</td> <td>🩼</td> <td>dagger</td> <td>🗡️</td> </tr> <tr> <td>dark-sunglasses</td> <td>🕶️</td> <td>date</td> <td>📅</td> <td>desktop-computer</td> <td>🖥️</td> </tr> <tr> <td>diya-lamp</td> <td>🪔</td> <td>dna</td> <td>🧬</td> <td>dollar</td> <td>💵</td> </tr> <tr> <td>door</td> <td>🚪</td> <td>dress</td> <td>👗</td> <td>drop-of-blood</td> <td>🩸</td> </tr> <tr> <td>drum</td> <td>🥁</td> <td>dvd</td> <td>📀</td> <td>electric-plug</td> <td>🔌</td> </tr> <tr> <td>elevator</td> <td>🛗</td> <td>email</td> <td>📧</td> <td>envelope</td> <td>✉️</td> </tr> <tr> <td>envelope-with-arrow</td> <td>📩</td> <td>euro</td> <td>💶</td> <td>eyeglasses</td> <td>👓</td> </tr> <tr> <td>fax</td> <td>📠</td> <td>file-cabinet</td> <td>🗄️</td> <td>file-folder</td> <td>📁</td> </tr> <tr> <td>film-projector</td> <td>📽️</td> <td>film-strip</td> <td>🎞️</td> <td>fire-extinguisher</td> <td>🧯</td> </tr> <tr> <td>flashlight</td> <td>🔦</td> <td>flat-shoe</td> <td>🥿</td> <td>floppy-disk</td> <td>💾</td> </tr> <tr> <td>flute</td> <td>🪈</td> <td>folding-hand-fan</td> <td>🪭</td> <td>fountain-pen</td> <td>🖋️</td> </tr> <tr> <td>funeral-urn</td> <td>⚱️</td> <td>gear</td> <td>⚙️</td> <td>gem</td> <td>💎</td> </tr> <tr> <td>gloves</td> <td>🧤</td> <td>goggles</td> <td>🥽</td> <td>green-book</td> <td>📗</td> </tr> <tr> <td>guitar</td> <td>🎸</td> <td>hair-pick</td> <td>🪮</td> <td>hammer</td> <td>🔨</td> </tr> <tr> <td>hammer-and-pick</td> <td>⚒️</td> <td>hammer-and-wrench</td> <td>🛠️</td> <td>hamsa</td> <td>🪬</td> </tr> <tr> <td>handbag</td> <td>👜</td> <td>headphones</td> <td>🎧</td> <td>headstone</td> <td>🪦</td> </tr> <tr> <td>high-heel</td> <td>👠</td> <td>hiking-boot</td> <td>🥾</td> <td>hook</td> <td>🪝</td> </tr> <tr> <td>identification-card</td> <td>🪪</td> <td>inbox-tray</td> <td>📥</td> <td>incoming-envelope</td> <td>📨</td> </tr> <tr> <td>iphone</td> <td>📱</td> <td>izakaya-lantern</td> <td>🏮</td> <td>jeans</td> <td>👖</td> </tr> <tr> <td>key</td> <td>🔑</td> <td>keyboard</td> <td>⌨️</td> <td>kimono</td> <td>👘</td> </tr> <tr> <td>lab-coat</td> <td>🥼</td> <td>label</td> <td>🏷️</td> <td>ladder</td> <td>🪜</td> </tr> <tr> <td>ledger</td> <td>📒</td> <td>level-slider</td> <td>🎚️</td> <td>link</td> <td>🔗</td> </tr> <tr> <td>lipstick</td> <td>💄</td> <td>lock</td> <td>🔒</td> <td>lock-with-ink-pen</td> <td>🔏</td> </tr> <tr> <td>long-drum</td> <td>🪘</td> <td>lotion-bottle</td> <td>🧴</td> <td>loud-sound</td> <td>🔊</td> </tr> <tr> <td>loudspeaker</td> <td>📢</td> <td>low-battery</td> <td>🪫</td> <td>mag</td> <td>🔍</td> </tr> <tr> <td>mag-right</td> <td>🔎</td> <td>magnet</td> <td>🧲</td> <td>mailbox</td> <td>📫</td> </tr> <tr> <td>mailbox-closed</td> <td>📪</td> <td>mailbox-with-mail</td> <td>📬</td> <td>mailbox-with-no-mail</td> <td>📭</td> </tr> <tr> <td>mans-shoe</td> <td>👞</td> <td>maracas</td> <td>🪇</td> <td>mega</td> <td>📣</td> </tr> <tr> <td>memo</td> <td>📝</td> <td>microphone</td> <td>🎤</td> <td>microscope</td> <td>🔬</td> </tr> <tr> <td>military-helmet</td> <td>🪖</td> <td>minidisc</td> <td>💽</td> <td>mirror</td> <td>🪞</td> </tr> <tr> <td>money-with-wings</td> <td>💸</td> <td>moneybag</td> <td>💰</td> <td>mortar-board</td> <td>🎓</td> </tr> <tr> <td>mouse-trap</td> <td>🪤</td> <td>movie-camera</td> <td>🎥</td> <td>moyai</td> <td>🗿</td> </tr> <tr> <td>musical-keyboard</td> <td>🎹</td> <td>musical-note</td> <td>🎵</td> <td>musical-score</td> <td>🎼</td> </tr> <tr> <td>mute</td> <td>🔇</td> <td>nazar-amulet</td> <td>🧿</td> <td>necktie</td> <td>👔</td> </tr> <tr> <td>newspaper</td> <td>📰</td> <td>newspaper-roll</td> <td>🗞️</td> <td>no-bell</td> <td>🔕</td> </tr> <tr> <td>notebook</td> <td>📓</td> <td>notebook-with-decorative-cover</td> <td>📔</td> <td>notes</td> <td>🎶</td> </tr> <tr> <td>nut-and-bolt</td> <td>🔩</td> <td>old-key</td> <td>🗝️</td> <td>one-piece-swimsuit</td> <td>🩱</td> </tr> <tr> <td>open-file-folder</td> <td>📂</td> <td>orange-book</td> <td>📙</td> <td>outbox-tray</td> <td>📤</td> </tr> <tr> <td>package</td> <td>📦</td> <td>page-facing-up</td> <td>📄</td> <td>page-with-curl</td> <td>📃</td> </tr> <tr> <td>pager</td> <td>📟</td> <td>paintbrush</td> <td>🖌️</td> <td>paperclip</td> <td>📎</td> </tr> <tr> <td>paperclips</td> <td>🖇️</td> <td>pen</td> <td>🖊️</td> <td>pencil2</td> <td>✏️</td> </tr> <tr> <td>petri-dish</td> <td>🧫</td> <td>phone</td> <td>☎️</td> <td>pick</td> <td>⛏️</td> </tr> <tr> <td>pill</td> <td>💊</td> <td>placard</td> <td>🪧</td> <td>plunger</td> <td>🪠</td> </tr> <tr> <td>postal-horn</td> <td>📯</td> <td>postbox</td> <td>📮</td> <td>pouch</td> <td>👝</td> </tr> <tr> <td>pound</td> <td>💷</td> <td>prayer-beads</td> <td>📿</td> <td>printer</td> <td>🖨️</td> </tr> <tr> <td>probing-cane</td> <td>🦯</td> <td>purse</td> <td>👛</td> <td>pushpin</td> <td>📌</td> </tr> <tr> <td>radio</td> <td>📻</td> <td>razor</td> <td>🪒</td> <td>receipt</td> <td>🧾</td> </tr> <tr> <td>rescue-worker-helmet</td> <td>⛑️</td> <td>ring</td> <td>💍</td> <td>roll-of-paper</td> <td>🧻</td> </tr> <tr> <td>round-pushpin</td> <td>📍</td> <td>safety-pin</td> <td>🧷</td> <td>safety-vest</td> <td>🦺</td> </tr> <tr> <td>sandal</td> <td>👡</td> <td>sari</td> <td>🥻</td> <td>satellite</td> <td>📡</td> </tr> <tr> <td>saxophone</td> <td>🎷</td> <td>scarf</td> <td>🧣</td> <td>school-satchel</td> <td>🎒</td> </tr> <tr> <td>scissors</td> <td>✂️</td> <td>screwdriver</td> <td>🪛</td> <td>scroll</td> <td>📜</td> </tr> <tr> <td>shield</td> <td>🛡️</td> <td>shirt</td> <td>👕</td> <td>shopping</td> <td>🛍️</td> </tr> <tr> <td>shopping-cart</td> <td>🛒</td> <td>shorts</td> <td>🩳</td> <td>shower</td> <td>🚿</td> </tr> <tr> <td>smoking</td> <td>🚬</td> <td>soap</td> <td>🧼</td> <td>socks</td> <td>🧦</td> </tr> <tr> <td>sound</td> <td>🔉</td> <td>speaker</td> <td>🔈</td> <td>spiral-calendar</td> <td>🗓️</td> </tr> <tr> <td>spiral-notepad</td> <td>🗒️</td> <td>sponge</td> <td>🧽</td> <td>stethoscope</td> <td>🩺</td> </tr> <tr> <td>straight-ruler</td> <td>📏</td> <td>studio-microphone</td> <td>🎙️</td> <td>swim-brief</td> <td>🩲</td> </tr> <tr> <td>syringe</td> <td>💉</td> <td>telephone-receiver</td> <td>📞</td> <td>telescope</td> <td>🔭</td> </tr> <tr> <td>test-tube</td> <td>🧪</td> <td>thong-sandal</td> <td>🩴</td> <td>toilet</td> <td>🚽</td> </tr> <tr> <td>toolbox</td> <td>🧰</td> <td>toothbrush</td> <td>🪥</td> <td>tophat</td> <td>🎩</td> </tr> <tr> <td>trackball</td> <td>🖲️</td> <td>triangular-ruler</td> <td>📐</td> <td>trumpet</td> <td>🎺</td> </tr> <tr> <td>tv</td> <td>📺</td> <td>unlock</td> <td>🔓</td> <td>vhs</td> <td>📼</td> </tr> <tr> <td>video-camera</td> <td>📹</td> <td>violin</td> <td>🎻</td> <td>wastebasket</td> <td>🗑️</td> </tr> <tr> <td>window</td> <td>🪟</td> <td>womans-clothes</td> <td>👚</td> <td>womans-hat</td> <td>👒</td> </tr> <tr> <td>wrench</td> <td>🔧</td> <td>x-ray</td> <td>🩻</td> <td>yen</td> <td>💴</td> </tr>
</tbody>
</table>

People & Body
-------------

<table class="pod-table">
<thead><tr>
<th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th>
</tr></thead>
<tbody>
<tr> <td>+1</td> <td>👍</td> <td>-1</td> <td>👎</td> <td>adult</td> <td>🧑</td> </tr> <tr> <td>anatomical-heart</td> <td>🫀</td> <td>angel</td> <td>👼</td> <td>artist</td> <td>🧑‍🎨</td> </tr> <tr> <td>astronaut</td> <td>🧑‍🚀</td> <td>baby</td> <td>👶</td> <td>bald-man</td> <td>👨‍🦲</td> </tr> <tr> <td>bald-woman</td> <td>👩‍🦲</td> <td>bath</td> <td>🛀</td> <td>bearded-person</td> <td>🧔</td> </tr> <tr> <td>bicyclist</td> <td>🚴</td> <td>biking-man</td> <td>🚴‍♂️</td> <td>biking-woman</td> <td>🚴‍♀️</td> </tr> <tr> <td>biting-lip</td> <td>🫦</td> <td>blond-haired-man</td> <td>👱‍♂️</td> <td>blond-haired-person</td> <td>👱</td> </tr> <tr> <td>blond-haired-woman</td> <td>👱‍♀️</td> <td>bone</td> <td>🦴</td> <td>bouncing-ball-man</td> <td>⛹️‍♂️</td> </tr> <tr> <td>bouncing-ball-person</td> <td>⛹️</td> <td>bouncing-ball-woman</td> <td>⛹️‍♀️</td> <td>bow</td> <td>🙇</td> </tr> <tr> <td>bowing-man</td> <td>🙇‍♂️</td> <td>bowing-woman</td> <td>🙇‍♀️</td> <td>boy</td> <td>👦</td> </tr> <tr> <td>brain</td> <td>🧠</td> <td>breast-feeding</td> <td>🤱</td> <td>business-suit-levitating</td> <td>🕴️</td> </tr> <tr> <td>bust-in-silhouette</td> <td>👤</td> <td>busts-in-silhouette</td> <td>👥</td> <td>call-me-hand</td> <td>🤙</td> </tr> <tr> <td>cartwheeling</td> <td>🤸</td> <td>child</td> <td>🧒</td> <td>clap</td> <td>👏</td> </tr> <tr> <td>climbing</td> <td>🧗</td> <td>climbing-man</td> <td>🧗‍♂️</td> <td>climbing-woman</td> <td>🧗‍♀️</td> </tr> <tr> <td>construction-worker</td> <td>👷</td> <td>construction-worker-man</td> <td>👷‍♂️</td> <td>construction-worker-woman</td> <td>👷‍♀️</td> </tr> <tr> <td>cook</td> <td>🧑‍🍳</td> <td>couple</td> <td>👫</td> <td>couple-with-heart</td> <td>💑</td> </tr> <tr> <td>couple-with-heart-man-man</td> <td>👨‍❤️‍👨</td> <td>couple-with-heart-woman-man</td> <td>👩‍❤️‍👨</td> <td>couple-with-heart-woman-woman</td> <td>👩‍❤️‍👩</td> </tr> <tr> <td>couplekiss</td> <td>💏</td> <td>couplekiss-man-man</td> <td>👨‍❤️‍💋‍👨</td> <td>couplekiss-man-woman</td> <td>👩‍❤️‍💋‍👨</td> </tr> <tr> <td>couplekiss-woman-woman</td> <td>👩‍❤️‍💋‍👩</td> <td>crossed-fingers</td> <td>🤞</td> <td>curly-haired-man</td> <td>👨‍🦱</td> </tr> <tr> <td>curly-haired-woman</td> <td>👩‍🦱</td> <td>dancers</td> <td>👯</td> <td>dancing-men</td> <td>👯‍♂️</td> </tr> <tr> <td>dancing-women</td> <td>👯‍♀️</td> <td>deaf-man</td> <td>🧏‍♂️</td> <td>deaf-person</td> <td>🧏</td> </tr> <tr> <td>deaf-woman</td> <td>🧏‍♀️</td> <td>detective</td> <td>🕵️</td> <td>ear</td> <td>👂</td> </tr> <tr> <td>ear-with-hearing-aid</td> <td>🦻</td> <td>elf</td> <td>🧝</td> <td>elf-man</td> <td>🧝‍♂️</td> </tr> <tr> <td>elf-woman</td> <td>🧝‍♀️</td> <td>eye</td> <td>👁️</td> <td>eyes</td> <td>👀</td> </tr> <tr> <td>facepalm</td> <td>🤦</td> <td>factory-worker</td> <td>🧑‍🏭</td> <td>fairy</td> <td>🧚</td> </tr> <tr> <td>fairy-man</td> <td>🧚‍♂️</td> <td>fairy-woman</td> <td>🧚‍♀️</td> <td>family</td> <td>👪</td> </tr> <tr> <td>family-man-boy</td> <td>👨‍👦</td> <td>family-man-boy-boy</td> <td>👨‍👦‍👦</td> <td>family-man-girl</td> <td>👨‍👧</td> </tr> <tr> <td>family-man-girl-boy</td> <td>👨‍👧‍👦</td> <td>family-man-girl-girl</td> <td>👨‍👧‍👧</td> <td>family-man-man-boy</td> <td>👨‍👨‍👦</td> </tr> <tr> <td>family-man-man-boy-boy</td> <td>👨‍👨‍👦‍👦</td> <td>family-man-man-girl</td> <td>👨‍👨‍👧</td> <td>family-man-man-girl-boy</td> <td>👨‍👨‍👧‍👦</td> </tr> <tr> <td>family-man-man-girl-girl</td> <td>👨‍👨‍👧‍👧</td> <td>family-man-woman-boy</td> <td>👨‍👩‍👦</td> <td>family-man-woman-boy-boy</td> <td>👨‍👩‍👦‍👦</td> </tr> <tr> <td>family-man-woman-girl</td> <td>👨‍👩‍👧</td> <td>family-man-woman-girl-boy</td> <td>👨‍👩‍👧‍👦</td> <td>family-man-woman-girl-girl</td> <td>👨‍👩‍👧‍👧</td> </tr> <tr> <td>family-woman-boy</td> <td>👩‍👦</td> <td>family-woman-boy-boy</td> <td>👩‍👦‍👦</td> <td>family-woman-girl</td> <td>👩‍👧</td> </tr> <tr> <td>family-woman-girl-boy</td> <td>👩‍👧‍👦</td> <td>family-woman-girl-girl</td> <td>👩‍👧‍👧</td> <td>family-woman-woman-boy</td> <td>👩‍👩‍👦</td> </tr> <tr> <td>family-woman-woman-boy-boy</td> <td>👩‍👩‍👦‍👦</td> <td>family-woman-woman-girl</td> <td>👩‍👩‍👧</td> <td>family-woman-woman-girl-boy</td> <td>👩‍👩‍👧‍👦</td> </tr> <tr> <td>family-woman-woman-girl-girl</td> <td>👩‍👩‍👧‍👧</td> <td>farmer</td> <td>🧑‍🌾</td> <td>female-detective</td> <td>🕵️‍♀️</td> </tr> <tr> <td>firefighter</td> <td>🧑‍🚒</td> <td>fist-left</td> <td>🤛</td> <td>fist-oncoming</td> <td>👊</td> </tr> <tr> <td>fist-raised</td> <td>✊</td> <td>fist-right</td> <td>🤜</td> <td>foot</td> <td>🦶</td> </tr> <tr> <td>footprints</td> <td>👣</td> <td>frowning-man</td> <td>🙍‍♂️</td> <td>frowning-person</td> <td>🙍</td> </tr> <tr> <td>frowning-woman</td> <td>🙍‍♀️</td> <td>genie</td> <td>🧞</td> <td>genie-man</td> <td>🧞‍♂️</td> </tr> <tr> <td>genie-woman</td> <td>🧞‍♀️</td> <td>girl</td> <td>👧</td> <td>golfing</td> <td>🏌️</td> </tr> <tr> <td>golfing-man</td> <td>🏌️‍♂️</td> <td>golfing-woman</td> <td>🏌️‍♀️</td> <td>guard</td> <td>💂</td> </tr> <tr> <td>guardsman</td> <td>💂‍♂️</td> <td>guardswoman</td> <td>💂‍♀️</td> <td>haircut</td> <td>💇</td> </tr> <tr> <td>haircut-man</td> <td>💇‍♂️</td> <td>haircut-woman</td> <td>💇‍♀️</td> <td>hand</td> <td>✋</td> </tr> <tr> <td>hand-with-index-finger-and-thumb-crossed</td> <td>🫰</td> <td>handball-person</td> <td>🤾</td> <td>handshake</td> <td>🤝</td> </tr> <tr> <td>health-worker</td> <td>🧑‍⚕️</td> <td>heart-hands</td> <td>🫶</td> <td>horse-racing</td> <td>🏇</td> </tr> <tr> <td>index-pointing-at-the-viewer</td> <td>🫵</td> <td>judge</td> <td>🧑‍⚖️</td> <td>juggling-person</td> <td>🤹</td> </tr> <tr> <td>kneeling-man</td> <td>🧎‍♂️</td> <td>kneeling-person</td> <td>🧎</td> <td>kneeling-woman</td> <td>🧎‍♀️</td> </tr> <tr> <td>leftwards-hand</td> <td>🫲</td> <td>leftwards-pushing-hand</td> <td>🫷</td> <td>leg</td> <td>🦵</td> </tr> <tr> <td>lips</td> <td>👄</td> <td>lotus-position</td> <td>🧘</td> <td>lotus-position-man</td> <td>🧘‍♂️</td> </tr> <tr> <td>lotus-position-woman</td> <td>🧘‍♀️</td> <td>love-you-gesture</td> <td>🤟</td> <td>lungs</td> <td>🫁</td> </tr> <tr> <td>mage</td> <td>🧙</td> <td>mage-man</td> <td>🧙‍♂️</td> <td>mage-woman</td> <td>🧙‍♀️</td> </tr> <tr> <td>male-detective</td> <td>🕵️‍♂️</td> <td>man</td> <td>👨</td> <td>man-artist</td> <td>👨‍🎨</td> </tr> <tr> <td>man-astronaut</td> <td>👨‍🚀</td> <td>man-beard</td> <td>🧔‍♂️</td> <td>man-cartwheeling</td> <td>🤸‍♂️</td> </tr> <tr> <td>man-cook</td> <td>👨‍🍳</td> <td>man-dancing</td> <td>🕺</td> <td>man-facepalming</td> <td>🤦‍♂️</td> </tr> <tr> <td>man-factory-worker</td> <td>👨‍🏭</td> <td>man-farmer</td> <td>👨‍🌾</td> <td>man-feeding-baby</td> <td>👨‍🍼</td> </tr> <tr> <td>man-firefighter</td> <td>👨‍🚒</td> <td>man-health-worker</td> <td>👨‍⚕️</td> <td>man-in-manual-wheelchair</td> <td>👨‍🦽</td> </tr> <tr> <td>man-in-motorized-wheelchair</td> <td>👨‍🦼</td> <td>man-in-tuxedo</td> <td>🤵‍♂️</td> <td>man-judge</td> <td>👨‍⚖️</td> </tr> <tr> <td>man-juggling</td> <td>🤹‍♂️</td> <td>man-mechanic</td> <td>👨‍🔧</td> <td>man-office-worker</td> <td>👨‍💼</td> </tr> <tr> <td>man-pilot</td> <td>👨‍✈️</td> <td>man-playing-handball</td> <td>🤾‍♂️</td> <td>man-playing-water-polo</td> <td>🤽‍♂️</td> </tr> <tr> <td>man-scientist</td> <td>👨‍🔬</td> <td>man-shrugging</td> <td>🤷‍♂️</td> <td>man-singer</td> <td>👨‍🎤</td> </tr> <tr> <td>man-student</td> <td>👨‍🎓</td> <td>man-teacher</td> <td>👨‍🏫</td> <td>man-technologist</td> <td>👨‍💻</td> </tr> <tr> <td>man-with-gua-pi-mao</td> <td>👲</td> <td>man-with-probing-cane</td> <td>👨‍🦯</td> <td>man-with-turban</td> <td>👳‍♂️</td> </tr> <tr> <td>man-with-veil</td> <td>👰‍♂️</td> <td>massage</td> <td>💆</td> <td>massage-man</td> <td>💆‍♂️</td> </tr> <tr> <td>massage-woman</td> <td>💆‍♀️</td> <td>mechanic</td> <td>🧑‍🔧</td> <td>mechanical-arm</td> <td>🦾</td> </tr> <tr> <td>mechanical-leg</td> <td>🦿</td> <td>men-wrestling</td> <td>🤼‍♂️</td> <td>mermaid</td> <td>🧜‍♀️</td> </tr> <tr> <td>merman</td> <td>🧜‍♂️</td> <td>merperson</td> <td>🧜</td> <td>metal</td> <td>🤘</td> </tr> <tr> <td>middle-finger</td> <td>🖕</td> <td>mountain-bicyclist</td> <td>🚵</td> <td>mountain-biking-man</td> <td>🚵‍♂️</td> </tr> <tr> <td>mountain-biking-woman</td> <td>🚵‍♀️</td> <td>mrs-claus</td> <td>🤶</td> <td>muscle</td> <td>💪</td> </tr> <tr> <td>mx-claus</td> <td>🧑‍🎄</td> <td>nail-care</td> <td>💅</td> <td>ninja</td> <td>🥷</td> </tr> <tr> <td>no-good</td> <td>🙅</td> <td>no-good-man</td> <td>🙅‍♂️</td> <td>no-good-woman</td> <td>🙅‍♀️</td> </tr> <tr> <td>nose</td> <td>👃</td> <td>office-worker</td> <td>🧑‍💼</td> <td>ok-hand</td> <td>👌</td> </tr> <tr> <td>ok-man</td> <td>🙆‍♂️</td> <td>ok-person</td> <td>🙆</td> <td>ok-woman</td> <td>🙆‍♀️</td> </tr> <tr> <td>older-adult</td> <td>🧓</td> <td>older-man</td> <td>👴</td> <td>older-woman</td> <td>👵</td> </tr> <tr> <td>open-hands</td> <td>👐</td> <td>palm-down-hand</td> <td>🫳</td> <td>palm-up-hand</td> <td>🫴</td> </tr> <tr> <td>palms-up-together</td> <td>🤲</td> <td>people-holding-hands</td> <td>🧑‍🤝‍🧑</td> <td>people-hugging</td> <td>🫂</td> </tr> <tr> <td>person-bald</td> <td>🧑‍🦲</td> <td>person-curly-hair</td> <td>🧑‍🦱</td> <td>person-feeding-baby</td> <td>🧑‍🍼</td> </tr> <tr> <td>person-fencing</td> <td>🤺</td> <td>person-in-manual-wheelchair</td> <td>🧑‍🦽</td> <td>person-in-motorized-wheelchair</td> <td>🧑‍🦼</td> </tr> <tr> <td>person-in-tuxedo</td> <td>🤵</td> <td>person-red-hair</td> <td>🧑‍🦰</td> <td>person-white-hair</td> <td>🧑‍🦳</td> </tr> <tr> <td>person-with-crown</td> <td>🫅</td> <td>person-with-probing-cane</td> <td>🧑‍🦯</td> <td>person-with-turban</td> <td>👳</td> </tr> <tr> <td>person-with-veil</td> <td>👰</td> <td>pilot</td> <td>🧑‍✈️</td> <td>pinched-fingers</td> <td>🤌</td> </tr> <tr> <td>pinching-hand</td> <td>🤏</td> <td>point-down</td> <td>👇</td> <td>point-left</td> <td>👈</td> </tr> <tr> <td>point-right</td> <td>👉</td> <td>point-up</td> <td>☝️</td> <td>point-up-2</td> <td>👆</td> </tr> <tr> <td>police-officer</td> <td>👮</td> <td>policeman</td> <td>👮‍♂️</td> <td>policewoman</td> <td>👮‍♀️</td> </tr> <tr> <td>pouting-face</td> <td>🙎</td> <td>pouting-man</td> <td>🙎‍♂️</td> <td>pouting-woman</td> <td>🙎‍♀️</td> </tr> <tr> <td>pray</td> <td>🙏</td> <td>pregnant-man</td> <td>🫃</td> <td>pregnant-person</td> <td>🫄</td> </tr> <tr> <td>pregnant-woman</td> <td>🤰</td> <td>prince</td> <td>🤴</td> <td>princess</td> <td>👸</td> </tr> <tr> <td>raised-back-of-hand</td> <td>🤚</td> <td>raised-hand-with-fingers-splayed</td> <td>🖐️</td> <td>raised-hands</td> <td>🙌</td> </tr> <tr> <td>raising-hand</td> <td>🙋</td> <td>raising-hand-man</td> <td>🙋‍♂️</td> <td>raising-hand-woman</td> <td>🙋‍♀️</td> </tr> <tr> <td>red-haired-man</td> <td>👨‍🦰</td> <td>red-haired-woman</td> <td>👩‍🦰</td> <td>rightwards-hand</td> <td>🫱</td> </tr> <tr> <td>rightwards-pushing-hand</td> <td>🫸</td> <td>rowboat</td> <td>🚣</td> <td>rowing-man</td> <td>🚣‍♂️</td> </tr> <tr> <td>rowing-woman</td> <td>🚣‍♀️</td> <td>runner</td> <td>🏃</td> <td>running-man</td> <td>🏃‍♂️</td> </tr> <tr> <td>running-woman</td> <td>🏃‍♀️</td> <td>santa</td> <td>🎅</td> <td>sauna-man</td> <td>🧖‍♂️</td> </tr> <tr> <td>sauna-person</td> <td>🧖</td> <td>sauna-woman</td> <td>🧖‍♀️</td> <td>scientist</td> <td>🧑‍🔬</td> </tr> <tr> <td>selfie</td> <td>🤳</td> <td>shrug</td> <td>🤷</td> <td>singer</td> <td>🧑‍🎤</td> </tr> <tr> <td>skier</td> <td>⛷️</td> <td>sleeping-bed</td> <td>🛌</td> <td>snowboarder</td> <td>🏂</td> </tr> <tr> <td>speaking-head</td> <td>🗣️</td> <td>standing-man</td> <td>🧍‍♂️</td> <td>standing-person</td> <td>🧍</td> </tr> <tr> <td>standing-woman</td> <td>🧍‍♀️</td> <td>student</td> <td>🧑‍🎓</td> <td>superhero</td> <td>🦸</td> </tr> <tr> <td>superhero-man</td> <td>🦸‍♂️</td> <td>superhero-woman</td> <td>🦸‍♀️</td> <td>supervillain</td> <td>🦹</td> </tr> <tr> <td>supervillain-man</td> <td>🦹‍♂️</td> <td>supervillain-woman</td> <td>🦹‍♀️</td> <td>surfer</td> <td>🏄</td> </tr> <tr> <td>surfing-man</td> <td>🏄‍♂️</td> <td>surfing-woman</td> <td>🏄‍♀️</td> <td>swimmer</td> <td>🏊</td> </tr> <tr> <td>swimming-man</td> <td>🏊‍♂️</td> <td>swimming-woman</td> <td>🏊‍♀️</td> <td>teacher</td> <td>🧑‍🏫</td> </tr> <tr> <td>technologist</td> <td>🧑‍💻</td> <td>tipping-hand-man</td> <td>💁‍♂️</td> <td>tipping-hand-person</td> <td>💁</td> </tr> <tr> <td>tipping-hand-woman</td> <td>💁‍♀️</td> <td>tongue</td> <td>👅</td> <td>tooth</td> <td>🦷</td> </tr> <tr> <td>troll</td> <td>🧌</td> <td>two-men-holding-hands</td> <td>👬</td> <td>two-women-holding-hands</td> <td>👭</td> </tr> <tr> <td>v</td> <td>✌️</td> <td>vampire</td> <td>🧛</td> <td>vampire-man</td> <td>🧛‍♂️</td> </tr> <tr> <td>vampire-woman</td> <td>🧛‍♀️</td> <td>vulcan-salute</td> <td>🖖</td> <td>walking</td> <td>🚶</td> </tr> <tr> <td>walking-man</td> <td>🚶‍♂️</td> <td>walking-woman</td> <td>🚶‍♀️</td> <td>water-polo</td> <td>🤽</td> </tr> <tr> <td>wave</td> <td>👋</td> <td>weight-lifting</td> <td>🏋️</td> <td>weight-lifting-man</td> <td>🏋️‍♂️</td> </tr> <tr> <td>weight-lifting-woman</td> <td>🏋️‍♀️</td> <td>white-haired-man</td> <td>👨‍🦳</td> <td>white-haired-woman</td> <td>👩‍🦳</td> </tr> <tr> <td>woman</td> <td>👩</td> <td>woman-artist</td> <td>👩‍🎨</td> <td>woman-astronaut</td> <td>👩‍🚀</td> </tr> <tr> <td>woman-beard</td> <td>🧔‍♀️</td> <td>woman-cartwheeling</td> <td>🤸‍♀️</td> <td>woman-cook</td> <td>👩‍🍳</td> </tr> <tr> <td>woman-dancing</td> <td>💃</td> <td>woman-facepalming</td> <td>🤦‍♀️</td> <td>woman-factory-worker</td> <td>👩‍🏭</td> </tr> <tr> <td>woman-farmer</td> <td>👩‍🌾</td> <td>woman-feeding-baby</td> <td>👩‍🍼</td> <td>woman-firefighter</td> <td>👩‍🚒</td> </tr> <tr> <td>woman-health-worker</td> <td>👩‍⚕️</td> <td>woman-in-manual-wheelchair</td> <td>👩‍🦽</td> <td>woman-in-motorized-wheelchair</td> <td>👩‍🦼</td> </tr> <tr> <td>woman-in-tuxedo</td> <td>🤵‍♀️</td> <td>woman-judge</td> <td>👩‍⚖️</td> <td>woman-juggling</td> <td>🤹‍♀️</td> </tr> <tr> <td>woman-mechanic</td> <td>👩‍🔧</td> <td>woman-office-worker</td> <td>👩‍💼</td> <td>woman-pilot</td> <td>👩‍✈️</td> </tr> <tr> <td>woman-playing-handball</td> <td>🤾‍♀️</td> <td>woman-playing-water-polo</td> <td>🤽‍♀️</td> <td>woman-scientist</td> <td>👩‍🔬</td> </tr> <tr> <td>woman-shrugging</td> <td>🤷‍♀️</td> <td>woman-singer</td> <td>👩‍🎤</td> <td>woman-student</td> <td>👩‍🎓</td> </tr> <tr> <td>woman-teacher</td> <td>👩‍🏫</td> <td>woman-technologist</td> <td>👩‍💻</td> <td>woman-with-headscarf</td> <td>🧕</td> </tr> <tr> <td>woman-with-probing-cane</td> <td>👩‍🦯</td> <td>woman-with-turban</td> <td>👳‍♀️</td> <td>woman-with-veil</td> <td>👰‍♀️</td> </tr> <tr> <td>women-wrestling</td> <td>🤼‍♀️</td> <td>wrestling</td> <td>🤼</td> <td>writing-hand</td> <td>✍️</td> </tr> <tr> <td>zombie</td> <td>🧟</td> <td>zombie-man</td> <td>🧟‍♂️</td> <td>zombie-woman</td> <td>🧟‍♀️</td> </tr>
</tbody>
</table>

Smileys & Emotion
-----------------

<table class="pod-table">
<thead><tr>
<th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th>
</tr></thead>
<tbody>
<tr> <td>100</td> <td>💯</td> <td>alien</td> <td>👽</td> <td>anger</td> <td>💢</td> </tr> <tr> <td>angry</td> <td>😠</td> <td>anguished</td> <td>😧</td> <td>astonished</td> <td>😲</td> </tr> <tr> <td>black-heart</td> <td>🖤</td> <td>blue-heart</td> <td>💙</td> <td>blush</td> <td>😊</td> </tr> <tr> <td>boom</td> <td>💥</td> <td>broken-heart</td> <td>💔</td> <td>brown-heart</td> <td>🤎</td> </tr> <tr> <td>clown-face</td> <td>🤡</td> <td>cold-face</td> <td>🥶</td> <td>cold-sweat</td> <td>😰</td> </tr> <tr> <td>confounded</td> <td>😖</td> <td>confused</td> <td>😕</td> <td>cowboy-hat-face</td> <td>🤠</td> </tr> <tr> <td>cry</td> <td>😢</td> <td>crying-cat-face</td> <td>😿</td> <td>cupid</td> <td>💘</td> </tr> <tr> <td>cursing-face</td> <td>🤬</td> <td>dash</td> <td>💨</td> <td>disappointed</td> <td>😞</td> </tr> <tr> <td>disappointed-relieved</td> <td>😥</td> <td>disguised-face</td> <td>🥸</td> <td>dizzy</td> <td>💫</td> </tr> <tr> <td>dizzy-face</td> <td>😵</td> <td>dotted-line-face</td> <td>🫥</td> <td>drooling-face</td> <td>🤤</td> </tr> <tr> <td>exploding-head</td> <td>🤯</td> <td>expressionless</td> <td>😑</td> <td>eye-speech-bubble</td> <td>👁️‍🗨️</td> </tr> <tr> <td>face-exhaling</td> <td>😮‍💨</td> <td>face-holding-back-tears</td> <td>🥹</td> <td>face-in-clouds</td> <td>😶‍🌫️</td> </tr> <tr> <td>face-with-diagonal-mouth</td> <td>🫤</td> <td>face-with-head-bandage</td> <td>🤕</td> <td>face-with-open-eyes-and-hand-over-mouth</td> <td>🫢</td> </tr> <tr> <td>face-with-peeking-eye</td> <td>🫣</td> <td>face-with-spiral-eyes</td> <td>😵‍💫</td> <td>face-with-thermometer</td> <td>🤒</td> </tr> <tr> <td>fearful</td> <td>😨</td> <td>flushed</td> <td>😳</td> <td>frowning</td> <td>😦</td> </tr> <tr> <td>frowning-face</td> <td>☹️</td> <td>ghost</td> <td>👻</td> <td>gift-heart</td> <td>💝</td> </tr> <tr> <td>green-heart</td> <td>💚</td> <td>grey-heart</td> <td>🩶</td> <td>grimacing</td> <td>😬</td> </tr> <tr> <td>grin</td> <td>😁</td> <td>grinning</td> <td>😀</td> <td>hand-over-mouth</td> <td>🤭</td> </tr> <tr> <td>hankey</td> <td>💩</td> <td>hear-no-evil</td> <td>🙉</td> <td>heart</td> <td>❤️</td> </tr> <tr> <td>heart-decoration</td> <td>💟</td> <td>heart-eyes</td> <td>😍</td> <td>heart-eyes-cat</td> <td>😻</td> </tr> <tr> <td>heart-on-fire</td> <td>❤️‍🔥</td> <td>heartbeat</td> <td>💓</td> <td>heartpulse</td> <td>💗</td> </tr> <tr> <td>heavy-heart-exclamation</td> <td>❣️</td> <td>hole</td> <td>🕳️</td> <td>hot-face</td> <td>🥵</td> </tr> <tr> <td>hugs</td> <td>🤗</td> <td>hushed</td> <td>😯</td> <td>imp</td> <td>👿</td> </tr> <tr> <td>innocent</td> <td>😇</td> <td>japanese-goblin</td> <td>👺</td> <td>japanese-ogre</td> <td>👹</td> </tr> <tr> <td>joy</td> <td>😂</td> <td>joy-cat</td> <td>😹</td> <td>kiss</td> <td>💋</td> </tr> <tr> <td>kissing</td> <td>😗</td> <td>kissing-cat</td> <td>😽</td> <td>kissing-closed-eyes</td> <td>😚</td> </tr> <tr> <td>kissing-heart</td> <td>😘</td> <td>kissing-smiling-eyes</td> <td>😙</td> <td>laughing</td> <td>😆</td> </tr> <tr> <td>left-speech-bubble</td> <td>🗨️</td> <td>light-blue-heart</td> <td>🩵</td> <td>love-letter</td> <td>💌</td> </tr> <tr> <td>lying-face</td> <td>🤥</td> <td>mask</td> <td>😷</td> <td>melting-face</td> <td>🫠</td> </tr> <tr> <td>mending-heart</td> <td>❤️‍🩹</td> <td>money-mouth-face</td> <td>🤑</td> <td>monocle-face</td> <td>🧐</td> </tr> <tr> <td>nauseated-face</td> <td>🤢</td> <td>nerd-face</td> <td>🤓</td> <td>neutral-face</td> <td>😐</td> </tr> <tr> <td>no-mouth</td> <td>😶</td> <td>open-mouth</td> <td>😮</td> <td>orange-heart</td> <td>🧡</td> </tr> <tr> <td>partying-face</td> <td>🥳</td> <td>pensive</td> <td>😔</td> <td>persevere</td> <td>😣</td> </tr> <tr> <td>pink-heart</td> <td>🩷</td> <td>pleading-face</td> <td>🥺</td> <td>pouting-cat</td> <td>😾</td> </tr> <tr> <td>purple-heart</td> <td>💜</td> <td>rage</td> <td>😡</td> <td>raised-eyebrow</td> <td>🤨</td> </tr> <tr> <td>relaxed</td> <td>☺️</td> <td>relieved</td> <td>😌</td> <td>revolving-hearts</td> <td>💞</td> </tr> <tr> <td>right-anger-bubble</td> <td>🗯️</td> <td>robot</td> <td>🤖</td> <td>rofl</td> <td>🤣</td> </tr> <tr> <td>roll-eyes</td> <td>🙄</td> <td>saluting-face</td> <td>🫡</td> <td>scream</td> <td>😱</td> </tr> <tr> <td>scream-cat</td> <td>🙀</td> <td>see-no-evil</td> <td>🙈</td> <td>shaking-face</td> <td>🫨</td> </tr> <tr> <td>shushing-face</td> <td>🤫</td> <td>skull</td> <td>💀</td> <td>skull-and-crossbones</td> <td>☠️</td> </tr> <tr> <td>sleeping</td> <td>😴</td> <td>sleepy</td> <td>😪</td> <td>slightly-frowning-face</td> <td>🙁</td> </tr> <tr> <td>slightly-smiling-face</td> <td>🙂</td> <td>smile</td> <td>😄</td> <td>smile-cat</td> <td>😸</td> </tr> <tr> <td>smiley</td> <td>😃</td> <td>smiley-cat</td> <td>😺</td> <td>smiling-face-with-tear</td> <td>🥲</td> </tr> <tr> <td>smiling-face-with-three-hearts</td> <td>🥰</td> <td>smiling-imp</td> <td>😈</td> <td>smirk</td> <td>😏</td> </tr> <tr> <td>smirk-cat</td> <td>😼</td> <td>sneezing-face</td> <td>🤧</td> <td>sob</td> <td>😭</td> </tr> <tr> <td>space-invader</td> <td>👾</td> <td>sparkling-heart</td> <td>💖</td> <td>speak-no-evil</td> <td>🙊</td> </tr> <tr> <td>speech-balloon</td> <td>💬</td> <td>star-struck</td> <td>🤩</td> <td>stuck-out-tongue</td> <td>😛</td> </tr> <tr> <td>stuck-out-tongue-closed-eyes</td> <td>😝</td> <td>stuck-out-tongue-winking-eye</td> <td>😜</td> <td>sunglasses</td> <td>😎</td> </tr> <tr> <td>sweat</td> <td>😓</td> <td>sweat-drops</td> <td>💦</td> <td>sweat-smile</td> <td>😅</td> </tr> <tr> <td>thinking</td> <td>🤔</td> <td>thought-balloon</td> <td>💭</td> <td>tired-face</td> <td>😫</td> </tr> <tr> <td>triumph</td> <td>😤</td> <td>two-hearts</td> <td>💕</td> <td>unamused</td> <td>😒</td> </tr> <tr> <td>upside-down-face</td> <td>🙃</td> <td>vomiting-face</td> <td>🤮</td> <td>weary</td> <td>😩</td> </tr> <tr> <td>white-heart</td> <td>🤍</td> <td>wink</td> <td>😉</td> <td>woozy-face</td> <td>🥴</td> </tr> <tr> <td>worried</td> <td>😟</td> <td>yawning-face</td> <td>🥱</td> <td>yellow-heart</td> <td>💛</td> </tr> <tr> <td>yum</td> <td>😋</td> <td>zany-face</td> <td>🤪</td> <td>zipper-mouth-face</td> <td>🤐</td> </tr> <tr> <td>zzz</td> <td>💤</td> <td></td> <td></td> <td></td> <td></td> </tr>
</tbody>
</table>

Symbols
-------

<table class="pod-table">
<thead><tr>
<th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th>
</tr></thead>
<tbody>
<tr> <td>1234</td> <td>🔢</td> <td>a</td> <td>🅰️</td> <td>ab</td> <td>🆎</td> </tr> <tr> <td>abc</td> <td>🔤</td> <td>abcd</td> <td>🔡</td> <td>accept</td> <td>🉑</td> </tr> <tr> <td>aquarius</td> <td>♒</td> <td>aries</td> <td>♈</td> <td>arrow-backward</td> <td>◀️</td> </tr> <tr> <td>arrow-double-down</td> <td>⏬</td> <td>arrow-double-up</td> <td>⏫</td> <td>arrow-down</td> <td>⬇️</td> </tr> <tr> <td>arrow-down-small</td> <td>🔽</td> <td>arrow-forward</td> <td>▶️</td> <td>arrow-heading-down</td> <td>⤵️</td> </tr> <tr> <td>arrow-heading-up</td> <td>⤴️</td> <td>arrow-left</td> <td>⬅️</td> <td>arrow-lower-left</td> <td>↙️</td> </tr> <tr> <td>arrow-lower-right</td> <td>↘️</td> <td>arrow-right</td> <td>➡️</td> <td>arrow-right-hook</td> <td>↪️</td> </tr> <tr> <td>arrow-up</td> <td>⬆️</td> <td>arrow-up-down</td> <td>↕️</td> <td>arrow-up-small</td> <td>🔼</td> </tr> <tr> <td>arrow-upper-left</td> <td>↖️</td> <td>arrow-upper-right</td> <td>↗️</td> <td>arrows-clockwise</td> <td>🔃</td> </tr> <tr> <td>arrows-counterclockwise</td> <td>🔄</td> <td>asterisk</td> <td>*️⃣</td> <td>atm</td> <td>🏧</td> </tr> <tr> <td>atom-symbol</td> <td>⚛️</td> <td>b</td> <td>🅱️</td> <td>baby-symbol</td> <td>🚼</td> </tr> <tr> <td>back</td> <td>🔙</td> <td>baggage-claim</td> <td>🛄</td> <td>ballot-box-with-check</td> <td>☑️</td> </tr> <tr> <td>bangbang</td> <td>‼️</td> <td>beginner</td> <td>🔰</td> <td>biohazard</td> <td>☣️</td> </tr> <tr> <td>black-circle</td> <td>⚫</td> <td>black-large-square</td> <td>⬛</td> <td>black-medium-small-square</td> <td>◾</td> </tr> <tr> <td>black-medium-square</td> <td>◼️</td> <td>black-small-square</td> <td>▪️</td> <td>black-square-button</td> <td>🔲</td> </tr> <tr> <td>blue-square</td> <td>🟦</td> <td>brown-circle</td> <td>🟤</td> <td>brown-square</td> <td>🟫</td> </tr> <tr> <td>cancer</td> <td>♋</td> <td>capital-abcd</td> <td>🔠</td> <td>capricorn</td> <td>♑</td> </tr> <tr> <td>children-crossing</td> <td>🚸</td> <td>cinema</td> <td>🎦</td> <td>cl</td> <td>🆑</td> </tr> <tr> <td>congratulations</td> <td>㊗️</td> <td>cool</td> <td>🆒</td> <td>copyright</td> <td>©️</td> </tr> <tr> <td>curly-loop</td> <td>➰</td> <td>currency-exchange</td> <td>💱</td> <td>customs</td> <td>🛃</td> </tr> <tr> <td>diamond-shape-with-a-dot-inside</td> <td>💠</td> <td>do-not-litter</td> <td>🚯</td> <td>eight</td> <td>8️⃣</td> </tr> <tr> <td>eight-pointed-black-star</td> <td>✴️</td> <td>eight-spoked-asterisk</td> <td>✳️</td> <td>eject-button</td> <td>⏏️</td> </tr> <tr> <td>end</td> <td>🔚</td> <td>exclamation</td> <td>❗</td> <td>fast-forward</td> <td>⏩</td> </tr> <tr> <td>female-sign</td> <td>♀️</td> <td>five</td> <td>5️⃣</td> <td>fleur-de-lis</td> <td>⚜️</td> </tr> <tr> <td>four</td> <td>4️⃣</td> <td>free</td> <td>🆓</td> <td>gemini</td> <td>♊</td> </tr> <tr> <td>green-circle</td> <td>🟢</td> <td>green-square</td> <td>🟩</td> <td>grey-exclamation</td> <td>❕</td> </tr> <tr> <td>grey-question</td> <td>❔</td> <td>hash</td> <td>#️⃣</td> <td>heavy-check-mark</td> <td>✔️</td> </tr> <tr> <td>heavy-division-sign</td> <td>➗</td> <td>heavy-dollar-sign</td> <td>💲</td> <td>heavy-equals-sign</td> <td>🟰</td> </tr> <tr> <td>heavy-minus-sign</td> <td>➖</td> <td>heavy-multiplication-x</td> <td>✖️</td> <td>heavy-plus-sign</td> <td>➕</td> </tr> <tr> <td>high-brightness</td> <td>🔆</td> <td>id</td> <td>🆔</td> <td>ideograph-advantage</td> <td>🉐</td> </tr> <tr> <td>infinity</td> <td>♾️</td> <td>information-source</td> <td>ℹ️</td> <td>interrobang</td> <td>⁉️</td> </tr> <tr> <td>keycap-ten</td> <td>🔟</td> <td>khanda</td> <td>🪯</td> <td>koko</td> <td>🈁</td> </tr> <tr> <td>large-blue-circle</td> <td>🔵</td> <td>large-blue-diamond</td> <td>🔷</td> <td>large-orange-diamond</td> <td>🔶</td> </tr> <tr> <td>latin-cross</td> <td>✝️</td> <td>left-luggage</td> <td>🛅</td> <td>left-right-arrow</td> <td>↔️</td> </tr> <tr> <td>leftwards-arrow-with-hook</td> <td>↩️</td> <td>leo</td> <td>♌</td> <td>libra</td> <td>♎</td> </tr> <tr> <td>loop</td> <td>➿</td> <td>low-brightness</td> <td>🔅</td> <td>m</td> <td>Ⓜ️</td> </tr> <tr> <td>male-sign</td> <td>♂️</td> <td>medical-symbol</td> <td>⚕️</td> <td>menorah</td> <td>🕎</td> </tr> <tr> <td>mens</td> <td>🚹</td> <td>mobile-phone-off</td> <td>📴</td> <td>name-badge</td> <td>📛</td> </tr> <tr> <td>negative-squared-cross-mark</td> <td>❎</td> <td>new</td> <td>🆕</td> <td>next-track-button</td> <td>⏭️</td> </tr> <tr> <td>ng</td> <td>🆖</td> <td>nine</td> <td>9️⃣</td> <td>no-bicycles</td> <td>🚳</td> </tr> <tr> <td>no-entry</td> <td>⛔</td> <td>no-entry-sign</td> <td>🚫</td> <td>no-mobile-phones</td> <td>📵</td> </tr> <tr> <td>no-pedestrians</td> <td>🚷</td> <td>no-smoking</td> <td>🚭</td> <td>non-potable-water</td> <td>🚱</td> </tr> <tr> <td>o</td> <td>⭕</td> <td>o2</td> <td>🅾️</td> <td>ok</td> <td>🆗</td> </tr> <tr> <td>om</td> <td>🕉️</td> <td>on</td> <td>🔛</td> <td>one</td> <td>1️⃣</td> </tr> <tr> <td>ophiuchus</td> <td>⛎</td> <td>orange-circle</td> <td>🟠</td> <td>orange-square</td> <td>🟧</td> </tr> <tr> <td>orthodox-cross</td> <td>☦️</td> <td>parking</td> <td>🅿️</td> <td>part-alternation-mark</td> <td>〽️</td> </tr> <tr> <td>passport-control</td> <td>🛂</td> <td>pause-button</td> <td>⏸️</td> <td>peace-symbol</td> <td>☮️</td> </tr> <tr> <td>pisces</td> <td>♓</td> <td>place-of-worship</td> <td>🛐</td> <td>play-or-pause-button</td> <td>⏯️</td> </tr> <tr> <td>potable-water</td> <td>🚰</td> <td>previous-track-button</td> <td>⏮️</td> <td>purple-circle</td> <td>🟣</td> </tr> <tr> <td>purple-square</td> <td>🟪</td> <td>put-litter-in-its-place</td> <td>🚮</td> <td>question</td> <td>❓</td> </tr> <tr> <td>radio-button</td> <td>🔘</td> <td>radioactive</td> <td>☢️</td> <td>record-button</td> <td>⏺️</td> </tr> <tr> <td>recycle</td> <td>♻️</td> <td>red-circle</td> <td>🔴</td> <td>red-square</td> <td>🟥</td> </tr> <tr> <td>registered</td> <td>®️</td> <td>repeat</td> <td>🔁</td> <td>repeat-one</td> <td>🔂</td> </tr> <tr> <td>restroom</td> <td>🚻</td> <td>rewind</td> <td>⏪</td> <td>sa</td> <td>🈂️</td> </tr> <tr> <td>sagittarius</td> <td>♐</td> <td>scorpius</td> <td>♏</td> <td>secret</td> <td>㊙️</td> </tr> <tr> <td>seven</td> <td>7️⃣</td> <td>signal-strength</td> <td>📶</td> <td>six</td> <td>6️⃣</td> </tr> <tr> <td>six-pointed-star</td> <td>🔯</td> <td>small-blue-diamond</td> <td>🔹</td> <td>small-orange-diamond</td> <td>🔸</td> </tr> <tr> <td>small-red-triangle</td> <td>🔺</td> <td>small-red-triangle-down</td> <td>🔻</td> <td>soon</td> <td>🔜</td> </tr> <tr> <td>sos</td> <td>🆘</td> <td>sparkle</td> <td>❇️</td> <td>star-and-crescent</td> <td>☪️</td> </tr> <tr> <td>star-of-david</td> <td>✡️</td> <td>stop-button</td> <td>⏹️</td> <td>symbols</td> <td>🔣</td> </tr> <tr> <td>taurus</td> <td>♉</td> <td>three</td> <td>3️⃣</td> <td>tm</td> <td>™️</td> </tr> <tr> <td>top</td> <td>🔝</td> <td>transgender-symbol</td> <td>⚧️</td> <td>trident</td> <td>🔱</td> </tr> <tr> <td>twisted-rightwards-arrows</td> <td>🔀</td> <td>two</td> <td>2️⃣</td> <td>u5272</td> <td>🈹</td> </tr> <tr> <td>u5408</td> <td>🈴</td> <td>u55b6</td> <td>🈺</td> <td>u6307</td> <td>🈯</td> </tr> <tr> <td>u6708</td> <td>🈷️</td> <td>u6709</td> <td>🈶</td> <td>u6e80</td> <td>🈵</td> </tr> <tr> <td>u7121</td> <td>🈚</td> <td>u7533</td> <td>🈸</td> <td>u7981</td> <td>🈲</td> </tr> <tr> <td>u7a7a</td> <td>🈳</td> <td>underage</td> <td>🔞</td> <td>up</td> <td>🆙</td> </tr> <tr> <td>vibration-mode</td> <td>📳</td> <td>virgo</td> <td>♍</td> <td>vs</td> <td>🆚</td> </tr> <tr> <td>warning</td> <td>⚠️</td> <td>wavy-dash</td> <td>〰️</td> <td>wc</td> <td>🚾</td> </tr> <tr> <td>wheel-of-dharma</td> <td>☸️</td> <td>wheelchair</td> <td>♿</td> <td>white-check-mark</td> <td>✅</td> </tr> <tr> <td>white-circle</td> <td>⚪</td> <td>white-large-square</td> <td>⬜</td> <td>white-medium-small-square</td> <td>◽</td> </tr> <tr> <td>white-medium-square</td> <td>◻️</td> <td>white-small-square</td> <td>▫️</td> <td>white-square-button</td> <td>🔳</td> </tr> <tr> <td>wireless</td> <td>🛜</td> <td>womens</td> <td>🚺</td> <td>x</td> <td>❌</td> </tr> <tr> <td>yellow-circle</td> <td>🟡</td> <td>yellow-square</td> <td>🟨</td> <td>yin-yang</td> <td>☯️</td> </tr> <tr> <td>zero</td> <td>0️⃣</td> <td></td> <td></td> <td></td> <td></td> </tr>
</tbody>
</table>

Travel & Places
---------------

<table class="pod-table">
<thead><tr>
<th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th> <th>name</th> <th>emoji</th>
</tr></thead>
<tbody>
<tr> <td>aerial-tramway</td> <td>🚡</td> <td>airplane</td> <td>✈️</td> <td>alarm-clock</td> <td>⏰</td> </tr> <tr> <td>ambulance</td> <td>🚑</td> <td>anchor</td> <td>⚓</td> <td>articulated-lorry</td> <td>🚛</td> </tr> <tr> <td>artificial-satellite</td> <td>🛰️</td> <td>auto-rickshaw</td> <td>🛺</td> <td>bank</td> <td>🏦</td> </tr> <tr> <td>barber</td> <td>💈</td> <td>beach-umbrella</td> <td>🏖️</td> <td>bellhop-bell</td> <td>🛎️</td> </tr> <tr> <td>bike</td> <td>🚲</td> <td>blue-car</td> <td>🚙</td> <td>boat</td> <td>⛵</td> </tr> <tr> <td>bricks</td> <td>🧱</td> <td>bridge-at-night</td> <td>🌉</td> <td>building-construction</td> <td>🏗️</td> </tr> <tr> <td>bullettrain-front</td> <td>🚅</td> <td>bullettrain-side</td> <td>🚄</td> <td>bus</td> <td>🚌</td> </tr> <tr> <td>busstop</td> <td>🚏</td> <td>camping</td> <td>🏕️</td> <td>canoe</td> <td>🛶</td> </tr> <tr> <td>car</td> <td>🚗</td> <td>carousel-horse</td> <td>🎠</td> <td>church</td> <td>⛪</td> </tr> <tr> <td>circus-tent</td> <td>🎪</td> <td>city-sunrise</td> <td>🌇</td> <td>city-sunset</td> <td>🌆</td> </tr> <tr> <td>cityscape</td> <td>🏙️</td> <td>classical-building</td> <td>🏛️</td> <td>clock1</td> <td>🕐</td> </tr> <tr> <td>clock10</td> <td>🕙</td> <td>clock1030</td> <td>🕥</td> <td>clock11</td> <td>🕚</td> </tr> <tr> <td>clock1130</td> <td>🕦</td> <td>clock12</td> <td>🕛</td> <td>clock1230</td> <td>🕧</td> </tr> <tr> <td>clock130</td> <td>🕜</td> <td>clock2</td> <td>🕑</td> <td>clock230</td> <td>🕝</td> </tr> <tr> <td>clock3</td> <td>🕒</td> <td>clock330</td> <td>🕞</td> <td>clock4</td> <td>🕓</td> </tr> <tr> <td>clock430</td> <td>🕟</td> <td>clock5</td> <td>🕔</td> <td>clock530</td> <td>🕠</td> </tr> <tr> <td>clock6</td> <td>🕕</td> <td>clock630</td> <td>🕡</td> <td>clock7</td> <td>🕖</td> </tr> <tr> <td>clock730</td> <td>🕢</td> <td>clock8</td> <td>🕗</td> <td>clock830</td> <td>🕣</td> </tr> <tr> <td>clock9</td> <td>🕘</td> <td>clock930</td> <td>🕤</td> <td>closed-umbrella</td> <td>🌂</td> </tr> <tr> <td>cloud</td> <td>☁️</td> <td>cloud-with-lightning</td> <td>🌩️</td> <td>cloud-with-lightning-and-rain</td> <td>⛈️</td> </tr> <tr> <td>cloud-with-rain</td> <td>🌧️</td> <td>cloud-with-snow</td> <td>🌨️</td> <td>comet</td> <td>☄️</td> </tr> <tr> <td>compass</td> <td>🧭</td> <td>construction</td> <td>🚧</td> <td>convenience-store</td> <td>🏪</td> </tr> <tr> <td>crescent-moon</td> <td>🌙</td> <td>cyclone</td> <td>🌀</td> <td>department-store</td> <td>🏬</td> </tr> <tr> <td>derelict-house</td> <td>🏚️</td> <td>desert</td> <td>🏜️</td> <td>desert-island</td> <td>🏝️</td> </tr> <tr> <td>droplet</td> <td>💧</td> <td>earth-africa</td> <td>🌍</td> <td>earth-americas</td> <td>🌎</td> </tr> <tr> <td>earth-asia</td> <td>🌏</td> <td>european-castle</td> <td>🏰</td> <td>european-post-office</td> <td>🏤</td> </tr> <tr> <td>factory</td> <td>🏭</td> <td>ferris-wheel</td> <td>🎡</td> <td>ferry</td> <td>⛴️</td> </tr> <tr> <td>fire</td> <td>🔥</td> <td>fire-engine</td> <td>🚒</td> <td>first-quarter-moon</td> <td>🌓</td> </tr> <tr> <td>first-quarter-moon-with-face</td> <td>🌛</td> <td>flight-arrival</td> <td>🛬</td> <td>flight-departure</td> <td>🛫</td> </tr> <tr> <td>flying-saucer</td> <td>🛸</td> <td>fog</td> <td>🌫️</td> <td>foggy</td> <td>🌁</td> </tr> <tr> <td>fountain</td> <td>⛲</td> <td>fuelpump</td> <td>⛽</td> <td>full-moon</td> <td>🌕</td> </tr> <tr> <td>full-moon-with-face</td> <td>🌝</td> <td>globe-with-meridians</td> <td>🌐</td> <td>helicopter</td> <td>🚁</td> </tr> <tr> <td>hindu-temple</td> <td>🛕</td> <td>hospital</td> <td>🏥</td> <td>hotel</td> <td>🏨</td> </tr> <tr> <td>hotsprings</td> <td>♨️</td> <td>hourglass</td> <td>⌛</td> <td>hourglass-flowing-sand</td> <td>⏳</td> </tr> <tr> <td>house</td> <td>🏠</td> <td>house-with-garden</td> <td>🏡</td> <td>houses</td> <td>🏘️</td> </tr> <tr> <td>hut</td> <td>🛖</td> <td>japan</td> <td>🗾</td> <td>japanese-castle</td> <td>🏯</td> </tr> <tr> <td>kaaba</td> <td>🕋</td> <td>kick-scooter</td> <td>🛴</td> <td>last-quarter-moon</td> <td>🌗</td> </tr> <tr> <td>last-quarter-moon-with-face</td> <td>🌜</td> <td>light-rail</td> <td>🚈</td> <td>love-hotel</td> <td>🏩</td> </tr> <tr> <td>luggage</td> <td>🧳</td> <td>mantelpiece-clock</td> <td>🕰️</td> <td>manual-wheelchair</td> <td>🦽</td> </tr> <tr> <td>metro</td> <td>🚇</td> <td>milky-way</td> <td>🌌</td> <td>minibus</td> <td>🚐</td> </tr> <tr> <td>monorail</td> <td>🚝</td> <td>moon</td> <td>🌔</td> <td>mosque</td> <td>🕌</td> </tr> <tr> <td>motor-boat</td> <td>🛥️</td> <td>motor-scooter</td> <td>🛵</td> <td>motorcycle</td> <td>🏍️</td> </tr> <tr> <td>motorized-wheelchair</td> <td>🦼</td> <td>motorway</td> <td>🛣️</td> <td>mount-fuji</td> <td>🗻</td> </tr> <tr> <td>mountain</td> <td>⛰️</td> <td>mountain-cableway</td> <td>🚠</td> <td>mountain-railway</td> <td>🚞</td> </tr> <tr> <td>mountain-snow</td> <td>🏔️</td> <td>national-park</td> <td>🏞️</td> <td>new-moon</td> <td>🌑</td> </tr> <tr> <td>new-moon-with-face</td> <td>🌚</td> <td>night-with-stars</td> <td>🌃</td> <td>ocean</td> <td>🌊</td> </tr> <tr> <td>office</td> <td>🏢</td> <td>oil-drum</td> <td>🛢️</td> <td>oncoming-automobile</td> <td>🚘</td> </tr> <tr> <td>oncoming-bus</td> <td>🚍</td> <td>oncoming-police-car</td> <td>🚔</td> <td>oncoming-taxi</td> <td>🚖</td> </tr> <tr> <td>open-umbrella</td> <td>☂️</td> <td>parachute</td> <td>🪂</td> <td>parasol-on-ground</td> <td>⛱️</td> </tr> <tr> <td>partly-sunny</td> <td>⛅</td> <td>passenger-ship</td> <td>🛳️</td> <td>pickup-truck</td> <td>🛻</td> </tr> <tr> <td>playground-slide</td> <td>🛝</td> <td>police-car</td> <td>🚓</td> <td>post-office</td> <td>🏣</td> </tr> <tr> <td>racing-car</td> <td>🏎️</td> <td>railway-car</td> <td>🚃</td> <td>railway-track</td> <td>🛤️</td> </tr> <tr> <td>rainbow</td> <td>🌈</td> <td>ring-buoy</td> <td>🛟</td> <td>ringed-planet</td> <td>🪐</td> </tr> <tr> <td>rock</td> <td>🪨</td> <td>rocket</td> <td>🚀</td> <td>roller-coaster</td> <td>🎢</td> </tr> <tr> <td>roller-skate</td> <td>🛼</td> <td>rotating-light</td> <td>🚨</td> <td>school</td> <td>🏫</td> </tr> <tr> <td>seat</td> <td>💺</td> <td>shinto-shrine</td> <td>⛩️</td> <td>ship</td> <td>🚢</td> </tr> <tr> <td>skateboard</td> <td>🛹</td> <td>small-airplane</td> <td>🛩️</td> <td>snowflake</td> <td>❄️</td> </tr> <tr> <td>snowman</td> <td>⛄</td> <td>snowman-with-snow</td> <td>☃️</td> <td>speedboat</td> <td>🚤</td> </tr> <tr> <td>stadium</td> <td>🏟️</td> <td>star</td> <td>⭐</td> <td>star2</td> <td>🌟</td> </tr> <tr> <td>stars</td> <td>🌠</td> <td>station</td> <td>🚉</td> <td>statue-of-liberty</td> <td>🗽</td> </tr> <tr> <td>steam-locomotive</td> <td>🚂</td> <td>stop-sign</td> <td>🛑</td> <td>stopwatch</td> <td>⏱️</td> </tr> <tr> <td>sun-behind-large-cloud</td> <td>🌥️</td> <td>sun-behind-rain-cloud</td> <td>🌦️</td> <td>sun-behind-small-cloud</td> <td>🌤️</td> </tr> <tr> <td>sun-with-face</td> <td>🌞</td> <td>sunny</td> <td>☀️</td> <td>sunrise</td> <td>🌅</td> </tr> <tr> <td>sunrise-over-mountains</td> <td>🌄</td> <td>suspension-railway</td> <td>🚟</td> <td>synagogue</td> <td>🕍</td> </tr> <tr> <td>taxi</td> <td>🚕</td> <td>tent</td> <td>⛺</td> <td>thermometer</td> <td>🌡️</td> </tr> <tr> <td>timer-clock</td> <td>⏲️</td> <td>tokyo-tower</td> <td>🗼</td> <td>tornado</td> <td>🌪️</td> </tr> <tr> <td>tractor</td> <td>🚜</td> <td>traffic-light</td> <td>🚥</td> <td>train</td> <td>🚋</td> </tr> <tr> <td>train2</td> <td>🚆</td> <td>tram</td> <td>🚊</td> <td>trolleybus</td> <td>🚎</td> </tr> <tr> <td>truck</td> <td>🚚</td> <td>umbrella</td> <td>☔</td> <td>vertical-traffic-light</td> <td>🚦</td> </tr> <tr> <td>volcano</td> <td>🌋</td> <td>waning-crescent-moon</td> <td>🌘</td> <td>waning-gibbous-moon</td> <td>🌖</td> </tr> <tr> <td>watch</td> <td>⌚</td> <td>waxing-crescent-moon</td> <td>🌒</td> <td>wedding</td> <td>💒</td> </tr> <tr> <td>wheel</td> <td>🛞</td> <td>wind-face</td> <td>🌬️</td> <td>wood</td> <td>🪵</td> </tr> <tr> <td>world-map</td> <td>🗺️</td> <td>zap</td> <td>⚡</td> <td></td> <td></td> </tr>
</tbody>
</table>

INSPIRATION
===========

Inspired by Simon Harms' [`Avolution::Emoji`](https://github.com/ukn-ubi/Avolution-Emoji) module, but completely re-imagined from scratch using the table provided by the [`gemoji`](https://github.com/github/gemoji) library.

AUTHOR
======

Elizabeth Mattijsen <liz@raku.rocks>

Source can be located at: https://github.com/lizmat/Text-Emoji . Comments and Pull Requests are welcome.

If you like this module, or what I'm doing more generally, committing to a [small sponsorship](https://github.com/sponsors/lizmat/) would mean a great deal to me!

COPYRIGHT AND LICENSE
=====================

Copyright 2024, 2025, 2026 Elizabeth Mattijsen

This library is free software; you can redistribute it and/or modify it under the Artistic License 2.0.

