[![Actions Status](https://github.com/japhb/Terminal-Tests/actions/workflows/test.yml/badge.svg)](https://github.com/japhb/Terminal-Tests/actions)

NAME
====

Terminal::Tests - Terminal emulator, multiplexer, and font quality tests

SYNOPSIS
========

```shell
$ terminal-quick-test [--ruler]
# ... single-page test output ...

$ terminal-test
# ... multi-page survey-style test ...
```

DESCRIPTION
===========

Terminal::Tests is a collection of quality and correctness tests for terminal emulators, terminal multiplexers, Unicode configurations, and monospace fonts.

The simple `terminal-quick-test` program displays a simple test pattern that should fit in a default 80x24 terminal window, and will catch some of the most common terminal configuration problems. For a more nuanced test, try the full `terminal-test` program, which shows numerous test patterns and describes what you should expect to see in each.

Quick Test Pattern
------------------

To display the quick test program, simply run `terminal-quick-test`; you can add the `--ruler` option if you'd like to also display a screen width ruler to help detect misalignment. *Correct* output should be no more than 79 columns on any line, so you've likely run into a terminal bug if the displayed test pattern is wider than that.

At the time of writing, I've not yet seen any terminals show a perfect test pattern; the best results so far still have a few issues but get most of the big things good enough. Here's the top contender so far, as of October 2025:

![Screenshot of quick test on Ghostty 1.2.2 using DejaVu Sans Mono font](docs/images/quick-test-ghostty-1.2.2-dejavu-sans-mono-ruler.png)

That's Ghostty 1.2.2 with `font-family` set to "DejaVu Sans Mono", running on Linux Mint 22.2 (Zara), which is based on Ubuntu 24.04 LTS (Noble Numbat). There are a few issues here and there, but overall it looks pretty good.

For comparison, here's the default `gnome-terminal` (3.52.0 using VTE 0.76.0) running on the same Linux Mint 22.2 system:

![Screenshot of quick test on default gnome-terminal with ruler](docs/images/quick-test-gnome-terminal-ruler.png)

The rightmost block of face emoji should have skin tones applied, rather than shown in fallback mode as a tone swatch next to a yellow emoji, and the spacing on the text-mode (outline) faces is too wide, causing the line to stretch. Likewise, flags for ISO country codes are unsupported, while oddly region-coded flags are, and joined emoji (using ZWJ, the Zero-Width Joiner) don't actually join. Furthermore several sets of "big pixel" drawing characters are unsupported and just show up as codepoint numbers, and the circled numbers in the ruler are drawn double-width. (The VTE team expects to have the emoji problems fixed in VTE 0.84, but that will take some time to be released and work its way through the various distro package pipelines.)

On the plus side, `gnome-terminal` correctly shows the bright bar in the 3-bit color bars section in the upper left, doesn't stretch the outlined corner triangles in the right most "compass rose" block, and produces more readable and balanced line-drawing glyphs.

In between these is Kovid Goyal's kitty 0.32.2:

![Screenshot of quick test on kitty with ruler](docs/images/quick-test-kitty-ruler.png)

`kitty` does much better than `gnome-terminal` with emoji and handles facial skin tones properly. While country flags are supported, region flags aren't. Joined emoji are supported, though the spacing is increasingly off as they get more complex, and some joined emoji sequences don't join properly. There are minor artifacts and misalignments on the window frames and boxes, the bright bar on the basic colors is missing, and again three of the "big pixel" glyph sets are missing. Still, this is overall not bad.

### Terminal Multiplexers

Terminal multiplexers such as Zellij, `tmux`, and GNU Screen tend to cause relatively subtle failures, affecting only one or two features. Here's an example of the test pattern as seen inside of GNU Screen in a `gnome-terminal`:

![Screenshot of quick test running inside GNU Screen on gnome-terminal](docs/images/quick-test-gnome-terminal-gnu-screen-ruler.png)

There are two new degradations here, compared to `gnome-terminal` by itself. The first is that GNU Screen supports 4-bit and 8-bit SGR color, but not 24-bit color, so the red/green/blue bars in the top middle are missing. The second is that GNU Screen has replaced the italic attribute with inverse at the top left. (I remain mystified as to why it does this, but it is at least consistent in doing so.)

`tmux` also causes some minor degradations, though different ones than GNU Screen:

![Screenshot of quick test running inside tmux on gnome-terminal](docs/images/quick-test-gnome-terminal-tmux-ruler.png)

Instead of completely removing the RGB bars, `tmux` seems to map them down to an 8-bit palette instead, causing strong banding. It also seems to change the emoji spacing in odd ways so that some emoji entirely disappear, seemingly overwritten by their neighbors.

Interestingly, `tmux`'s corruption is different when run on Ghostty. This time it doesn't seem to affect the RGB color bars at all, but instead flag handling goes completely batty:

![Screenshot of quick test running inside tmux on Ghostty](docs/images/quick-test-ghostty-1.2.2-tmux-ruler.png)

### Font Troubles

I specified the `font-family` for Ghostty above because the default font for Ghostty 1.2.2 is "JetBrains Mono"; that font is unfortunately missing quite a few glyphs, causing Ghostty to try to fill in from other fonts. This generally makes a bit of a mismatch mess; there's more detailed discussion in [Ghostty's issue #9161](https://github.com/ghostty-org/ghostty/discussions/9161), but here's what it looks like:

![Screenshot of quick test on Ghostty 1.2.2 using JetBrains Mono font](docs/images/quick-test-ghostty-1.2.2-jetbrains-mono-ruler.png)

Notice how glyph sizes become inconsistent, several glyphs (including most of the vulgar fractions and arrows) overlap each other, the heart card suit and white chess pawn look different than their fellows, and so on.

As font problems go, this is pretty minor however. There's even a benefit: this is the first screenshot that shows programming ligatures working (see the row of glyphs just above the emoji faces).

For a whole different scale of font problems, consider `xterm` for example. By default on my Linux system if you just run `xterm`, it will use a low-res **bitmap** "fixed" font with approximately Unicode 3.0 support:

![Screenshot of quick test running on xterm using the Unicode fixed font](docs/images/quick-test-xterm-fixed-unicode-ruler.png)

Many of the symbols are nearly unreadable, most of the advanced drawing characters are missing, and emoji aren't supported at all. Seems bad.

But it gets worse! Specifying a larger bitmap font size defaults to using the *non-Unicode* version of the font. Here I've launched `xterm -fn 10x20`:

![Screenshot of quick test running on xterm using the Latin-1 fixed font](docs/images/quick-test-xterm-fixed-latin1-ruler.png)

This font is essentially limited to the Latin-1 repertoire, plus the most ancient VT-100 drawing characters. Almost everything is empty boxes, even the ruler at the bottom.

Using a scalable font will work better, even at the default small size, but color emoji are still unsupported (only text outlines are shown), and many of the glyphs are misaligned or cut off. Here I've just told `xterm` to use the default system monospace scalable font using `xterm -fa mono`:

![Screenshot of quick test running on xterm using the mono scalable font](docs/images/quick-test-xterm-mono-ruler.png)

Unsurprisingly the scalable font scales up better too (using `xterm -fa mono -fs 12`):

![Screenshot of quick test running on xterm using the mono scalable font at 12-point size](docs/images/quick-test-xterm-mono-12-ruler.png)

### Non-UTF-8 Configurations

Windows Terminal in Windows 10/11 can produce a relatively decent Unicode 7.0-compliant result aside from the emoji rows, but **only** if "beta" UTF-8 support is turned on (see separate [Windows Terminal](#windows-terminal) section below). Without that, the test pattern will absolutely fall apart as encoding garbage completely overwhelms everything:

![Screenshot of quick test on Windows Terminal in UTF-16 mode](docs/images/quick-test-windows-terminal-default-ruler.jpeg)

Here's what it looks like in UTF-8 mode:

![Screenshot of quick test on Windows Terminal in UTF-8 mode](docs/images/quick-test-windows-terminal-utf8-powershell-ruler.png)

### OS and Terminal Versions

Operating system and terminal software versions can make a significant difference. For example, here's Terminal on macOS 10.14:

![Screenshot of quick test running on Terminal on macOS 10.14](docs/images/quick-test-macOS10.14-Terminal.png)

There's a massive improvement moving to Terminal on macOS 12.6:

![Screenshot of quick test running on Terminal on macOS 12.6](docs/images/quick-test-macOS12.6-Terminal.png)

And another overall quality improvement switching to iTerm2 on macOS:

![Screenshot of quick test running on iTerm2 on macOS](docs/images/quick-test-macOS-iterm2.png)

iTerm2 isn't purely an improvement over Terminal; there are a few minor degradations as well, such as shaded blocks being the wrong size, dashed lines being offset vertically, square corners being lengthened, and some text symbols gaining unrequested color.

Full Terminal Test
------------------

The `terminal-test` program includes a far more complete set of test patterns across a range of categories, including descriptions of what you should expect to see in each pattern, as well as common artifacts that you should ideally *not* see. You can rate the display of each pattern on a simple scale, and the program will summarize the results in text or JSON (with the `--json` option) after you have rated the last test pattern.

Terminal-Specific Recommended Tweaks
------------------------------------

### Windows Terminal

By default Windows Terminal under Windows 10/11 supports only UTF-16, an old Unicode encoding that has otherwise been replaced by the UTF-8 encoding. You'll need to change the settings for Windows Terminal to use UTF-8 instead. (Backwards compatibility with ancient software is certainly a thing, but modern terminal-interface software doesn't really speak anything but UTF-8 anymore.)

Thanks to [sapeurfaire](https://github.com/sapeurfaire)++, we now have instructions to change this setting either temporarily or permanently.

If you would like to change to UTF-8 **just for PowerShell**, you can simply tell it to use Code Page 65001 (Microsoft naming for UTF-8) -- either when running it manually or as part of the command that Windows Terminal launches for your PowerShell profile -- by adding the following options to the PowerShell command line:

`-NoExit -Command "chcp 65001"`

If you'd like to switch to UTF-8 for **ALL** terminal applications, you can follow this path in the system settings:

Settings --> Time & language --> Language & region --> Administrative language settings --> Change system locale

You should see this window:

![Screenshot of Windows Region Settings dialog](docs/images/Windows-Region-Settings-Beta-UTF-8.png)

Select the "Beta: Use Unicode UTF-8 for worldwide language support" checkbox. You will then need to restart your computer so the change can take effect:

![Screenshot of Change System Locale restart dialog](docs/images/Windows-Region-Settings-Restart-Needed.png)

If you prefer to make such changes via script rather than dialog boxes, you can use this PowerShell script to elevate privileges and edit the registry for you:

[PowerShell UTF-8 registry editing script](https://gist.github.com/sapeurfaire/8e0a9518a89f0bde064c4d49afd09f5f)

For best Unicode and emoji handling, you will also want to set the Windows Terminal Compatibility setting for Text measurement mode to "Grapheme clusters":

![Screenshot of Windows Terminal Compatibility settings dialog](docs/images/Windows-Terminal-Settings-Grapheme-clusters.png)

### Ghostty 1.2.x

For best results change Ghostty's base font; the default used in 1.2.x produces numerous artifacts. DejaVu Sans Mono seems to work well on Linux; if you're on a Mac or Windows box you may need to either install that font family or find another mostly-complete monospace font family instead.

To use a different font, you can set Ghostty's `font-family`, either in the config file (`~/.config/ghostty/config` on Linux) or directly using a command-line option to `ghostty`:

    ghostty --font-family="DejaVu Sans Mono"

AUTHOR
======

Geoffrey Broadwell <gjb@sonic.net>

COPYRIGHT AND LICENSE
=====================

Copyright © 2022-2025 Geoffrey Broadwell

This library is free software; you can redistribute it and/or modify it under the Artistic License 2.0.
