use Terminal::Widgets::Events;
use Terminal::Widgets::Simple;
use Terminal::Widgets::Plugins::Anolis;

class FormUI is TopLevel {
    has Proc::Async $!proc .= new: :pty(:rows(32), :cols(72)), 'vim', 'lib/Terminal/Widgets/Plugins/Anolis.rakumod';
    #has Proc::Async $!proc .= new: :pty(:rows(32), :cols(72)), '/usr/bin/htop';
    #has Proc::Async $!proc .= new: :pty(:rows(32), :cols(72)), '/usr/bin/bash';

    method initial-layout($builder, $width, $height) {
        with $builder {
            .text-input(id => 'cols', prompt-string => 'TTY cols:'),
            .text-input(id => 'rows', prompt-string => 'TTY rows:'),
            .node(
                .button(label => 'Quit',
                                   process-input  => { $.terminal.quit }),
                .button(label => 'Resize',
                                   process-input  => {
                                       my $cols = %.by-id<cols>.input-field.buffer.contents.Int;
                                       my $rows = %.by-id<rows>.input-field.buffer.contents.Int;
                                       $!proc.resize-pty: :$cols, :$rows;
                                   }),
            ),
            .divider(line-style => 'light1', style => %(set-h => 1)),
            .spacer,
            .divider(line-style => 'light1', style => %(set-h => 1)),
            .node(
                .anolis(process-log => { self!add-to-log($_) },
                                   style => %(set-w => 72, set-h => 32),
                                   proc-async => $!proc,
                ),
                .with-scrollbars(
                    .log-viewer(id => 'lv')
                ),
            ),
        }
    }

    method !add-to-log($text) {
        my $log-viewer = %.by-id<lv>;
        $log-viewer.add-entry($text);
        $log-viewer.refresh-for-scroll;
    }

    multi method handle-event(Terminal::Widgets::Events::LayoutBuilt:D, BubbleUp) {
        unless $!proc.started {
            temp %*ENV<TERM> = 'xterm-256color';
            $!proc.start: :%*ENV;
        }
    }
}


sub MAIN() {
    App.new.boot-to-screen('form', FormUI, title => 'Anolis Example');
}
