use v6.d;

unit module Sub::Name:ver<0.0.10>:auth<zef:lizmat>;

# only export the proto
proto sub subname(|) is export {*}
# handle name, { ... } case
multi sub subname($name, &callable) { set-subname($name,     &callable)   }
# handle "foo" => { ... } case
multi sub subname(Pair:D $pair)     { set-subname($pair.key, $pair.value) }
# handle foo => { ... } case
multi sub subname(*%_ where * == 1) { set-subname(|%_.kv) }

# the workhorse
sub set-subname($name, &callable) {
    &callable.set_name(
      $name.contains('::')
        ?? $name
        !! callframe(2).my<::?PACKAGE>.^name ~ '::' ~ $name
    );
    &callable
}

# vim: expandtab shiftwidth=4
