#!raku

unit module Sparky::Job;
use JSON::Fast;

sub job-queue-fs (%config,%trigger,$sparrowfile,$sparrowdo-config) is export {

  my $project = %config<project>;

  my $job-id =  %config<job-id>;

  my $sparky-project-dir = "{%*ENV<HOME>}/.sparky/projects/{$project}";

  mkdir "{$sparky-project-dir}/.triggers" unless "{$sparky-project-dir}/.triggers".IO ~~ :d;

  unless "{$sparky-project-dir}/sparrowfile".IO ~~ :f {
    spurt "{$sparky-project-dir}/sparrowfile", "# dummy file, generated by sparrowdo";
  }

  my $cache-dir = "{%*ENV<HOME>}/.sparky/.cache/$job-id/";

  mkdir $cache-dir;

  "{$cache-dir}/config.raku".IO.spurt($sparrowdo-config.raku);

  %trigger<cwd> = $cache-dir;

  # override parent job sparrowdo configuration
  # by %config<sparrowdo>

  %trigger<sparrowdo> ||= {};

  if %config<sparrowdo> {
    for %config<sparrowdo>.keys -> $k {
      %trigger<sparrowdo>{$k} = %config<sparrowdo>{$k};
    }
    # handle conflicting parameters
    if %config<sparrowdo><localhost> {
      %trigger<sparrowdo><docker>:delete;
      %trigger<sparrowdo><host>:delete;
    } elsif %config<sparrowdo><host> {
      %trigger<sparrowdo><docker>:delete;
      %trigger<sparrowdo><localhost>:delete;
    } elsif %config<sparrowdo><docker> {
      %trigger<sparrowdo><host>:delete;
      %trigger<sparrowdo><localhost>:delete;
    }
    if %config<sparrowdo><sudo> {
      %trigger<sparrowdo><no_sudo>:delete;
    }
  }


  %trigger<description> = %config<description> || "spawned job";

  # override sparrowdo tags by %config<tags>

  if %config<tags> {
    %trigger<sparrowdo><tags> = %config<tags>.map({
      my $k = $_.key;
      my $v = $_.value;
      $v = "" unless defined($v);
      my $v-safe = $v.subst(',',"___comma___",:g).subst('=','___eq___',:g);
      "{$k}={$v-safe}"
    }).join(","); 
  }

  %trigger<sparrowdo><conf> = "config.raku";

  say "job-queue-fs: create trigger file: {$sparky-project-dir}/.triggers/$job-id";

  "{$sparky-project-dir}/.triggers/$job-id".IO.spurt(%trigger.perl);

  "{$cache-dir}/sparrowfile".IO.spurt($sparrowfile);

   return  { project => $project, job-id => $job-id };

}


sub put-job-stash (%config,%data) is export {

  my $project = %config<project>;

  my $job-id =  %config<job-id>;

  my $sparky-project-dir = "{%*ENV<HOME>}/.sparky/projects/{$project}";

  mkdir "{$sparky-project-dir}/.stash" unless "{$sparky-project-dir}/.stash".IO ~~ :d;

  say "put-job-stash: put data to stash - {$sparky-project-dir}/.stash/$job-id ...";

  "{$sparky-project-dir}/.stash/$job-id".IO.spurt(to-json(%data));

  return { path => "{$sparky-project-dir}/.stash/$job-id" };
}

sub put-job-file ($project,$job-id,$filename,$data) is export {

  my $sparky-project-dir = "{%*ENV<HOME>}/.sparky/projects/{$project}";

  mkdir "{$sparky-project-dir}/.files" unless "{$sparky-project-dir}/.files".IO ~~ :d;

  mkdir "{$sparky-project-dir}/.files/{$job-id}" unless "{$sparky-project-dir}/.files/{$job-id}".IO ~~ :d;

  say "put-job-file: create job file - {$sparky-project-dir}/.files/{$job-id}/{$filename} ...";

  "{$sparky-project-dir}/.files/{$job-id}/{$filename}".IO.spurt($data);

  return { path => "{$sparky-project-dir}/.files/{$job-id}/$filename" };

 }

sub get-job-stash ($project,$job-id) is export {

  my $sparky-project-dir = "{%*ENV<HOME>}/.sparky/projects/{$project}";

  return 
    "{$sparky-project-dir}/.stash/$job-id".IO ~~ :f ??
    "{$sparky-project-dir}/.stash/$job-id".IO.slurp !!
    '{}'
}

sub get-job-file ($project,$job-id,$filename) is export {

  my $sparky-project-dir = "{%*ENV<HOME>}/.sparky/projects/{$project}";

  return "{$sparky-project-dir}/.files/{$job-id}/{$filename}";

}

sub get-job-dir ($project,$job-id) is export {

  my $sparky-project-dir = "{%*ENV<HOME>}/.sparky/projects/{$project}";

  return "{$sparky-project-dir}/.files/{$job-id}";

}
