Red Agent Guide
- Dependencies: Raku >= 2022.07. Install deps: `zef install --/test --test-depends --deps-only .`.
- Run all tests: `prove6 -lj8 t` (CI uses this). Alt: `zef test . --verbose`.
- Run a single test file: `prove6 -lv t/35-create.rakutest` (replace with target file).
- Quick compile check (lint): `raku -c lib/Red.rakumod` and for any changed files.
- Install locally: `zef install --/test .`. Generate docs: `make docs` or `raku tools/make-docs.raku`.
- DB config for tests/examples: set `RED_DATABASE` (e.g. `Pg host=localhost ...`); many tests work with SQLite by default.
- Imports: prefer explicit `use`; examples use `use Red:api<2>`; internal modules as `use Red::...`.
- Formatting: 4-space indent, no tabs, trim trailing spaces, ~100 char lines, one statement per line.
- Types: add type constraints on attributes/signatures (Int, Str, Bool, DateTime, etc.); use `is rw` only when mutation is required.
- Naming: Types/Models CamelCase; methods/attributes kebab-case (e.g., `create-table`, `author-id`); SQL/table/column names snake_case.
- Errors: throw typed exceptions (`X::Red::*`) instead of generic `die`; use `CATCH { default { ... } }` to transform/rethrow; avoid silent Nil—return `Failure` or throw.
- ORM traits: columns via `is column`, ids via `is serial`/`is id`, FKs via `is referencing{ ... }`, relations via `is relationship{ ... }`; keep `inflate/deflate` pure.
- Immutability: prefer immutable updates; call `.^save` explicitly for persistence.
- Tests: place under `t/` as `.rakutest`; avoid external state; prefer temp SQLite unless `RED_DATABASE` is required.
- CI reference: see `.github/workflows/matrix.yaml` (Raku setup, deps, `prove6`). Replicate locally when debugging.
- Docs: `make clean-docs` then `make docs` to refresh API docs.
- Cursor/Copilot: none present (`.cursor/rules/`, `.cursorrules`, and `.github/copilot-instructions.md` not found).
- Commits: keep diffs minimal and focused; match existing patterns and avoid unrelated formatting changes.

Project Links
- GitHub repo: https://github.com/FCO/Red
- Issue tracker: https://github.com/FCO/Red/issues
- Wiki: https://github.com/FCO/Red/wiki
- Docs (GitHub Pages): https://fco.github.io/Red/
- API index: https://fco.github.io/Red/API
- Tutorials index: https://fco.github.io/Red/#tutorials
- Coverage report: https://fco.github.io/Red/coverage/report.html

Release to Zef
- Prereqs: `zef install App::Mi6 fez`; ensure `dist.ini` has `[UploadToZef]` and `META6.json` has `auth` like `zef:FCO`.
- Login: `fez login` (stores token) or set `FEZ_TOKEN` environment variable.
- Verify: tests green (`prove6 -lj8 t` or `zef test .`); rebuild docs if needed (`make docs`).
- Prepare: update `Changes` under `{{$NEXT}}` with notes; keep the format consistent with prior entries.
- Bump + release (preferred): `mi6 release --bump patch` (or `minor`/`major`). This updates `META6.json` and `Changes`, creates and pushes a git tag, then uploads to the Zef ecosystem via Fez (because `[UploadToZef]` is enabled).
- Manual alternative: bump `META6.json` and `Changes`, commit and tag; `mi6 build`; then `fez upload` from the repo root.
- Verify: after a few minutes, `zef search Red` or check the Zef index; consumers can `zef install Red:ver<NEW>`.
- Troubleshooting: if upload/auth fails, rerun `fez login`; ensure the version is new and the git tree is clean; make sure the tarball includes `META6.json` and README (generated by `ReadmeFromPod` during build).
