#!/usr/bin/env raku

use lib $*PROGRAM.parent.parent.parent.add('lib');
use lib $*PROGRAM.parent.parent.add('lib');
use HtmlHighlight;
use Rainbow;

sub MAIN(Str $input-file, Str $output-file?, :$lang = 'raku', :@opt) {
    my $title = $input-file.IO.basename;
    my $source = $input-file.IO.slurp;
    my %opt-params = @opt.map: { Pair.new($_, True) };
    my @tokens;
    given $lang {
        when 'raku'    { @tokens = Rainbow::tokenize($source, |%opt-params); }
        when 'string'  { @tokens = Rainbow::tokenize-string($source, |%opt-params); }
        when 'regex'   { @tokens = Rainbow::tokenize-regex($source, |%opt-params); }
        when 'rakudoc' { @tokens = Rainbow::tokenize-rakudoc($source, |%opt-params); }
        default { die "Unknown language given."; }
    }

    my $html = HtmlHighlight::make-html(@tokens, $input-file);

    with $output-file {
        $output-file.IO.spurt: $html;
        say "firefox \"$output-file\"";
        # run "firefox", $output-file;
    }
    else {
        say $html;
    }
}
