enum Rainbow::TokenType <
    NAME_SCALAR
    NAME_ARRAY
    NAME_HASH
    NAME_CODE
    NAME
    NUM_LITERAL
    KEYWORD
    OPERATOR
    TYPE
    ROUTINE
    STRING
    STRING_DELIMITER
    ESCAPE
    TEXT
    COMMENT
    REGEX_SPECIAL
    REGEX_LITERAL
    REGEX_DELIMITER
    RAKUDOC_TEXT
    RAKUDOC_MARKUP
>;

class Rainbow::Token {
    has Rainbow::TokenType $.type;
    has Str $.text is rw;

    method new(Rainbow::TokenType $type, Str() $text) {
        self.bless: :$type, :$text;
    }

    method copy-with-text(Rainbow::Token:D: $text) {
        self.bless: :$!type, :$text;
    }
}

