unit module Rainbow;

use Rainbow::RakuGrammar;
use Rainbow::RakuGrammarActions;
#use Grammar::Profiler::Simple;

our sub tokenize(Str $source) {
    my $actions = Rainbow::RakuGrammarActions.new;
    my $match = Rainbow::RakuGrammar.parse: $source, :$actions;
    # dd get-timing(Rainbow::RakuGrammar);
    $match.made
}

our sub tokenize-regex(Str $source) {
    my $actions = Rainbow::RakuGrammarActions.new;
    my $match = Rainbow::RakuGrammar.parse: $source, :$actions, :rule<regex-TOP>;
    $match.made
}

our sub tokenize-string(Str $source, :$q, :$s, :$a, :$h, :$f, :$c, :$b) {
    my $actions = Rainbow::RakuGrammarActions.new;
    my $*quote-mode = QuoteMode.new: :$q, :$s, :$a, :$h, :$f, :$c, :$b;
    my $match = Rainbow::RakuGrammar.parse: $source, :$actions, :rule<string-TOP>;
    $match.made
}

our sub tokenize-rakudoc(Str $source) {
    my $actions = Rainbow::RakuGrammarActions.new;
    my $*rakudoc-block-can-nest = True;
    my $match = Rainbow::RakuGrammar.parse: $source, :$actions, :rule<rakudoc-TOP>;
    $match.made
}
