NAME
====

Rainbow

Raku source code lexer

Synopsis
========

    use Rainbow;

    my %mapping =
        TEXT     => '#ffffff',
        KEYWORD  => "#e04c86",
        OPERATOR => "#e04c86",
        TYPE     => "#00ffff",
        ROUTINE  => "#978deb",
        STRING   => "#68f3ca",
        # ...
    ;

    my $code = 'my $greet = "hello"; say "Oh $greet there!";';

    my @tokens = Rainbow::tokenize($code);

    my @fragments = @tokens.map: -> $t {
        my $color = %mapping{$t.type.key} // %mapping<TEXT>;
        say "$color: {$t.text}";
    }

Description
===========

This module can turn a piece of Raku code into a list of tokens. Assign each
token a color and you have made yourself a Raku syntax highlighter.

See `lib/Rainbow/Token.rakumod` for the complete list of tokens.

Tokenizing sub-languages
------------------------

In addition to the `tokenize` sub the following subs are provided that can be
used to tokenize the respective sub-language. For strings you can provide
modifiers that change which interpolations are possible.

    sub tokenize-regex(Str $source)
    sub tokenize-string(Str $source, :$q, :$s, :$a, :$h, :$f, :$c, :$b)
    sub tokenize-rakudoc(Str $source)

AUTHOR
======

Patrick Böker <patrick.boeker@posteo.de>

THANKS
======

Thanks to Siavash Askari Nasr (CIAvash) for the Chroma Raku lexer which this
module took as inspiration.

License
=======

This module is distributed under the terms of the Artistic License 2.0.


