use v6;

unit class PDF::IO::Handle;

use PDF::IO;
also does PDF::IO;

has IO::Handle $.value is required handles <read close eof seek slurp path>;
has Str $!str;
has UInt $.codes is rw;

multi submethod TWEAK {
    $!value.seek( 0, SeekFromEnd );
    $!codes = $!value.tell;
    $!value.seek( 0, SeekFromBeginning );
}

multi method Str {
    $.byte-str(0, $!codes);
}

multi method subbuf(WhateverCode $whence!, |c --> Blob) {
    my UInt $from = $whence( $!codes );
    $.subbuf( $from, |c );
}

multi method subbuf( UInt $from!, UInt $length = $.codes - $from + 1 --> Blob) {
    $!value.seek( $from, SeekFromBeginning );
    $!value.read( $length );
}

multi method COERCE(::?CLASS $_) is default { $_ }
multi method COERCE(IO::Handle:D $value!, |c ) {
    self.bless( :$value, |c );
}

