[![Actions Status](https://github.com/lizmat/P5built-ins/actions/workflows/linux.yml/badge.svg)](https://github.com/lizmat/P5built-ins/actions) [![Actions Status](https://github.com/lizmat/P5built-ins/actions/workflows/macos.yml/badge.svg)](https://github.com/lizmat/P5built-ins/actions) [![Actions Status](https://github.com/lizmat/P5built-ins/actions/workflows/windows.yml/badge.svg)](https://github.com/lizmat/P5built-ins/actions)

NAME
====

Raku port of Perl's built-ins

SYNOPSIS
========

```raku
use P5built-ins;   # import all P5 built-in functions supported

use P5built-ins <tie untie>;  # only import specific ones

tie my @a, Foo;
```

DESCRIPTION
===========

This module provides an easy way to import a growing number of built-in functions of Perl in Raku Currently supported at:

    abs caller chdir chomp chop chr closedir cos crypt defined each endgrent
    endnetent endprotoent endpwent endservent exp fc fileno getgrent getgrgid
    getgrnam getlogin getnetbyaddr getnetbyname getnetent getpgrp getppid
    getpriority getprotobyname getprotobynumber getprotoent getpwent getpwnam
    getpwuid getservbyname getservbyport getservent gmtime hex index int lc
    lcfirst length localtime log oct opendir ord pack pop print printf push
    quotemeta rand readdir readlink ref reset reverse rewinddir rindex say
    seek seekdir setgrent setnetent setpriority setprotoent setpwent setservent
    shift sin sleep sqrt study substr telldir tie tied times uc ucfirst undef
    unpack unshift untie

The following file test operators are also available:

    -r -w -x -e -f -d -s -z -l

And the following terms:

    __FILE__ __LINE__ __PACKAGE__ __SUB__ SEEK_CUR SEEK_END SEEK_SET
    STDERR STDIN STDOUT

PORTING CAVEATS
===============

Please look at the porting caveats of the underlying modules that actually provide the functionality:

<table class="pod-table">
<thead><tr>
<th>module</th> <th>built-in functions</th>
</tr></thead>
<tbody>
<tr> <td>P5caller</td> <td>caller</td> </tr> <tr> <td>P5chdir</td> <td>chdir</td> </tr> <tr> <td>P5chomp</td> <td>chomp chop</td> </tr> <tr> <td>P5chr</td> <td>chr ord</td> </tr> <tr> <td>P5defined</td> <td>defined undef</td> </tr> <tr> <td>P5each</td> <td>each</td> </tr> <tr> <td>P5fc</td> <td>fc</td> </tr> <tr> <td>P5fileno</td> <td>fileno</td> </tr> <tr> <td>P5getgrnam</td> <td>endgrent getgrent getgrgid getgrnam setgrent</td> </tr> <tr> <td>P5getnetbyname</td> <td>endnetent getnetbyname getnetbyaddr getnetent setnetent</td> </tr> <tr> <td>P5getpriority</td> <td>getpriority setpriority getppid getpgrp</td> </tr> <tr> <td>P5getprotobyname</td> <td>endprotoent getprotobyname getprotobynumber getprotoent setprotoent</td> </tr> <tr> <td>P5getpwnam</td> <td>endpwent getlogin getpwent getpwnam getpwuid setpwent</td> </tr> <tr> <td>P5getservbyname</td> <td>endservent getservbyname getservbyport getservent setservent</td> </tr> <tr> <td>P5hex</td> <td>hex oct</td> </tr> <tr> <td>P5lc</td> <td>lc uc</td> </tr> <tr> <td>P5lcfirst</td> <td>lcfirst ucfirst</td> </tr> <tr> <td>P5length</td> <td>length</td> </tr> <tr> <td>P5localtime</td> <td>localtime gmtime</td> </tr> <tr> <td>P5math</td> <td>abs cos crypt exp int log rand sin sqrt</td> </tr> <tr> <td>P5opendir</td> <td>opendir readdir telldir seekdir rewinddir closedir</td> </tr> <tr> <td>P5pack</td> <td>pack unpack</td> </tr> <tr> <td>P5print</td> <td>print printf say</td> </tr> <tr> <td>P5push</td> <td>push pop</td> </tr> <tr> <td>P5readlink</td> <td>readlink</td> </tr> <tr> <td>P5ref</td> <td>ref</td> </tr> <tr> <td>P5reset</td> <td>reset</td> </tr> <tr> <td>P5reverse</td> <td>reverse</td> </tr> <tr> <td>P5study</td> <td>study</td> </tr> <tr> <td>P5tie</td> <td>tie, tied, untie</td> </tr> <tr> <td>P5times</td> <td>times</td> </tr> <tr> <td>P5-X</td> <td>-r -w -x -e -f -d -s -z -l</td> </tr>
</tbody>
</table>

AUTHOR
======

Elizabeth Mattijsen <liz@raku.rocks>

Source can be located at: https://github.com/lizmat/P5built-ins . Comments and Pull Requests are welcome.

If you like this module, or what I'm doing more generally, committing to a [small sponsorship](https://github.com/sponsors/lizmat/) would mean a great deal to me!

COPYRIGHT AND LICENSE
=====================

Copyright 2018, 2019, 2020, 2021, 2025 Elizabeth Mattijsen

Re-imagined from Perl as part of the CPAN Butterfly Plan.

This library is free software; you can redistribute it and/or modify it under the Artistic License 2.0.

