BEGIN;
CREATE TABLE types(id INTEGER PRIMARY KEY ASC, name TEXT, extra_info JSON, type_links JSON);
CREATE TABLE routines(id INTEGER PRIMARY KEY ASC, name TEXT, line INT, file TEXT);
CREATE TABLE gcs(time INT, retained_bytes INT, promoted_bytes INT, gen2_roots INT, stolen_gen2_roots INT, full INT, responsible INT, cleared_bytes INT, start_time INT, sequence_num INT, thread_id INT, PRIMARY KEY(sequence_num, thread_id));
CREATE TABLE calls(id INTEGER PRIMARY KEY ASC, parent_id INT, routine_id INT, osr INT, spesh_entries INT, jit_entries INT, inlined_entries INT, inclusive_time INT, exclusive_time INT, entries INT, deopt_one INT, deopt_all INT, rec_depth INT, first_entry_time INT, highest_child_id INT, FOREIGN KEY(routine_id) REFERENCES routines(id));
CREATE TABLE profile(total_time INT, spesh_time INT, thread_id INT, parent_thread_id INT, root_node INT, first_entry_time INT, FOREIGN KEY(root_node) REFERENCES calls(id));
CREATE TABLE allocations(call_id INT, type_id INT, spesh INT, jit INT, count INT, replaced INT, PRIMARY KEY(call_id, type_id), FOREIGN KEY(call_id) REFERENCES calls(id), FOREIGN KEY(type_id) REFERENCES types(id));
CREATE TABLE deallocations(gc_seq_num INT, gc_thread_id INT, type_id INT, nursery_fresh INT, nursery_seen INT, gen2 INT, PRIMARY KEY(gc_seq_num, gc_thread_id, type_id), FOREIGN KEY(gc_seq_num, gc_thread_id) REFERENCES gcs(sequence_num, thread_id), FOREIGN KEY(type_id) REFERENCES types(id));
INSERT INTO routines VALUES ('31','','4761','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('39','capture','297','SETTING::src/core.c/Parameter.rakumod'), ('19','mro','239','src/Perl6/Metamodel/C3MRO.nqp'), ('46','!find_wrappee','12','src/Perl6/Metamodel/Nominalizable.nqp'), ('26','','595','NQP::src/core/dispatchers.nqp'), ('134','AT_KEY_CONTAINER','44','SETTING::src/core.c/Hash.rakumod'), ('41','','4879','src/vm/moar/dispatchers.nqp'), ('122','protect','27','SETTING::src/core.c/Lock.rakumod'), ('112','','2','-e'), ('118','is_textual_stage','766','NQP::src/vm/moar/HLL/Backend.nqp'), ('65','has-named-args-mismatch','2107','src/vm/moar/dispatchers.nqp'), ('78','','672','src/vm/moar/dispatchers.nqp'), ('150','accepted','3581','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('155','','167','NQP::src/vm/moar/HLL/Backend.nqp'), ('45','wrappee-lookup','45','src/Perl6/Metamodel/Nominalizable.nqp'), ('43','archetype','10','src/Perl6/Metamodel/DefiniteHOW.nqp'), ('27','','3431','src/vm/moar/dispatchers.nqp'), ('131','default','200','SETTING::src/core.c/traits.rakumod'), ('104','','2332','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('88','is_mixin','10','src/Perl6/Metamodel/Mixins.nqp'), ('8','','105','src/vm/moar/ModuleLoader.nqp'), ('54','wrappee','32','src/Perl6/Metamodel/Nominalizable.nqp'), ('22','','3925','src/vm/moar/dispatchers.nqp'), ('77','','657','src/vm/moar/dispatchers.nqp'), ('25','delegate-constant','8','src/vm/moar/dispatchers.nqp'), ('56','coercive','95','src/Perl6/Metamodel/Archetypes.nqp'), ('49','base_type','85','src/Perl6/Metamodel/DefiniteHOW.nqp'), ('80','of','1433','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('102','','6010','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('120','','1787','SETTING::src/core.c/Rakudo/Internals.rakumod'), ('137','default','1485','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('9','','5','NQP::src/core/dispatchers.nqp'), ('86','','908','src/vm/moar/dispatchers.nqp'), ('30','','4812','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('132','postcircumfix:<{ }>','6','SETTING::src/core.c/hash_slice.rakumod'), ('17','','152','NQP::src/core/dispatchers.nqp'), ('148','possible','3572','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('146','new','3565','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('83','nominal','87','src/Perl6/Metamodel/Archetypes.nqp'), ('24','find_method_fallback','368','src/Perl6/Metamodel/ClassHOW.nqp'), ('142','','3302','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('127','','138','SETTING::src/core.c/Deprecations.rakumod'), ('75','POPULATE','1092','SETTING::src/core.c/Exception.rakumod'), ('110','','4011','src/vm/moar/dispatchers.nqp'), ('61','','3888','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('106','','983','src/vm/moar/dispatchers.nqp'), ('53','definite','96','src/Perl6/Metamodel/Archetypes.nqp'), ('119','','85','src/main.nqp'), ('89','new','39','SETTING::src/core.c/Failure.rakumod'), ('98','backtrace','10','SETTING::src/core.c/Exception.rakumod'), ('143','','3312','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('138','next','1478','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('154','return','44','SETTING::src/core.c/control.rakumod'), ('125','','1793','SETTING::src/core.c/Rakudo/Internals.rakumod'), ('67','new','2034','src/vm/moar/dispatchers.nqp'), ('40','','4862','src/vm/moar/dispatchers.nqp'), ('5','','1125','src/vm/moar/dispatchers.nqp'), ('69','set-next','2039','src/vm/moar/dispatchers.nqp'), ('52','runtime-only','4882','src/vm/moar/dispatchers.nqp'), ('152','report','27','SETTING::src/core.c/Deprecations.rakumod'), ('12','method_table','772','NQP::src/how/NQPClassHOW.nqp'), ('95','AT-POS','492','SETTING::src/core.c/List.rakumod'), ('108','','3037','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('126','','1794','SETTING::src/core.c/Rakudo/Internals.rakumod'), ('107','<unit>','1','-e'), ('20','method_table','155','src/Perl6/Metamodel/MethodContainer.nqp'), ('35','signature','32','SETTING::src/core.c/Code.rakumod'), ('96','type','259','SETTING::src/core.c/Parameter.rakumod'), ('117','infix:<*>','348','SETTING::src/core.c/Int.rakumod'), ('121','','1788','SETTING::src/core.c/Rakudo/Internals.rakumod'), ('111','delegate-code-syscall','34','src/vm/moar/dispatchers.nqp'), ('71','candidate','2040','src/vm/moar/dispatchers.nqp'), ('123','','1789','SETTING::src/core.c/Rakudo/Internals.rakumod'), ('114','foo','1','-e'), ('42','archetypes','32','src/Perl6/Metamodel/DefiniteHOW.nqp'), ('1','','189','NQP::src/HLL/Compiler.nqp'), ('141','','3608','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('151','remove_if_accepted','3589','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('38','','253','src/vm/moar/ModuleLoader.nqp'), ('92','','2992','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('91','','1040','src/vm/moar/dispatchers.nqp'), ('13','','32','src/vm/moar/ModuleLoader.nqp'), ('93','params','141','SETTING::src/core.c/Signature.rakumod'), ('105','reset-backtrace','24','SETTING::src/core.c/Exception.rakumod'), ('97','SET-SELF','11','SETTING::src/core.c/Failure.rakumod'), ('58','slurpy','288','SETTING::src/core.c/Parameter.rakumod'), ('62','raku-multi-plan','2172','src/vm/moar/dispatchers.nqp'), ('84','','227','src/vm/moar/dispatchers.nqp'), ('124','','1790','SETTING::src/core.c/Rakudo/Internals.rakumod'), ('18','submethod_table','158','src/Perl6/Metamodel/MethodContainer.nqp'), ('15','find_method','13','src/Perl6/Metamodel/MROBasedMethodDispatch.nqp'), ('153','Bool','54','SETTING::src/core.c/Map.rakumod'), ('47','nominalizable_kind','140','src/Perl6/Metamodel/DefiniteHOW.nqp'), ('87','mixin_base','144','src/Perl6/Metamodel/Mixins.nqp'), ('145','','4822','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('82','','469','src/Perl6/Metamodel/ClassHOW.nqp'), ('57','accepts_type','129','src/Perl6/Metamodel/DefiniteHOW.nqp'), ('37','guard-type-concreteness','55','src/vm/moar/dispatchers.nqp'), ('50','check_instantiated','80','src/Perl6/Metamodel/DefiniteHOW.nqp'), ('144','','2943','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('72','new','139','SETTING::src/core.c/Mu.rakumod'), ('59','named','282','SETTING::src/core.c/Parameter.rakumod'), ('149','is_narrower','3616','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('55','definite','90','src/Perl6/Metamodel/DefiniteHOW.nqp'), ('23','int-zero','16','src/vm/moar/ModuleLoader.nqp'), ('51','archetypes','57','src/Perl6/Metamodel/EnumHOW.nqp'), ('28','','3242','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('79','delegate-whence','680','src/vm/moar/dispatchers.nqp'), ('139','default','1435','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('60','','2901','src/vm/moar/dispatchers.nqp'), ('85','','614','src/vm/moar/dispatchers.nqp'), ('115','Num','78','SETTING::src/core.c/Int.rakumod'), ('0','','-1',''), ('10','find_method','861','NQP::src/how/NQPClassHOW.nqp'), ('70','trivial','2042','src/vm/moar/dispatchers.nqp'), ('29','','1873','src/vm/moar/dispatchers.nqp'), ('103','','5992','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('21','','1452','src/vm/moar/dispatchers.nqp'), ('133','AT-KEY','50','SETTING::src/core.c/Hash.rakumod'), ('128','DYNAMIC','33','SETTING::src/core.c/stubs.rakumod'), ('32','is-simple-args-proto','1810','src/vm/moar/dispatchers.nqp'), ('99','new','107','SETTING::src/core.c/Backtrace.rakumod'), ('156','','-1',''), ('2','<unit-outer>','1','-e'), ('135','new','1605','src/Perl6/bootstrap.c/BOOTSTRAP.nqp'), ('140','','139','SETTING::src/core.c/Deprecations.rakumod'), ('44','nominalizable','88','src/Perl6/Metamodel/Archetypes.nqp'), ('14','','273','NQP::src/core/dispatchers.nqp'), ('34','pass-decontainerized','3701','src/vm/moar/dispatchers.nqp'), ('81','archetypes','53','src/Perl6/Metamodel/ClassHOW.nqp'), ('36','','94','src/vm/moar/dispatchers.nqp'), ('101','SET-SELF','90','SETTING::src/core.c/Backtrace.rakumod'), ('48','!wrappee','141','src/Perl6/Metamodel/DefiniteHOW.nqp');
INSERT INTO types VALUES ('4','BOOTArray',json_object('typename', 'BOOTArray','type', null,'scdesc', '','repr', 'VMArray','managed_size', 56,'has_unmanaged_data', 1),json_object()), ('113','Int',json_object('typename', 'Int','type', null,'scdesc', 'gen/moar/BOOTSTRAP/v6c.nqp','repr', 'P6opaque','managed_size', 40),json_object()), ('90','Failure',json_object('typename', 'Failure','type', null,'scdesc', 'gen/moar/CORE.c.setting','repr', 'P6opaque','managed_size', 56),json_object()), ('116','Num',json_object('typename', 'Num','type', null,'scdesc', 'gen/moar/BOOTSTRAP/v6c.nqp','repr', 'P6opaque','managed_size', 40),json_object()), ('165','QAST::SVal',json_object('typename', 'QAST::SVal','type', null,'scdesc', 'gen/moar/stage2/QASTNode.nqp','repr', 'P6opaque','managed_size', 72),json_object()), ('6','BOOTTracked',json_object('typename', 'BOOTTracked','type', null,'scdesc', '','repr', 'MVMTracked','managed_size', 40),json_object()), ('7','BOOTCapture',json_object('typename', 'BOOTCapture','type', null,'scdesc', '','repr', 'MVMCapture','managed_size', 40),json_object()), ('11','BOOTStr',json_object('typename', 'BOOTStr','type', null,'scdesc', '','repr', 'P6str','managed_size', 32),json_object()), ('164','MAST::Lexical',json_object('typename', 'MAST::Lexical','type', null,'scdesc', 'gen/moar/stage2/MASTNodes.nqp','repr', 'P6opaque','managed_size', 48),json_object()), ('68','MultiDispatchCall',json_object('typename', 'MultiDispatchCall','type', null,'scdesc', 'gen/moar/BOOTSTRAP/v6c.nqp','repr', 'P6opaque','managed_size', 48),json_object()), ('162','MAST::InstructionList',json_object('typename', 'MAST::InstructionList','type', null,'scdesc', 'gen/moar/stage2/QAST.nqp','repr', 'P6opaque','managed_size', 48),json_object()), ('173','QAST::Block',json_object('typename', 'QAST::Block','type', null,'scdesc', 'gen/moar/stage2/QASTNode.nqp','repr', 'P6opaque','managed_size', 160),json_object()), ('147','Node',json_object('typename', 'Node','type', null,'scdesc', 'gen/moar/BOOTSTRAP/v6c.nqp','repr', 'P6opaque','managed_size', 56),json_object()), ('171','QAST::IVal',json_object('typename', 'QAST::IVal','type', null,'scdesc', 'gen/moar/stage2/QASTNode.nqp','repr', 'P6opaque','managed_size', 72),json_object()), ('74','X::Experimental',json_object('typename', 'X::Experimental','type', null,'scdesc', 'gen/moar/CORE.c.setting','repr', 'P6opaque','managed_size', 144),json_object()), ('73','Hash',json_object('typename', 'Hash','type', null,'scdesc', 'gen/moar/BOOTSTRAP/v6c.nqp','repr', 'P6opaque','managed_size', 48),json_object()), ('64','BOOTIntArray',json_object('typename', 'BOOTIntArray','type', null,'scdesc', '','repr', 'VMArray','managed_size', 56,'has_unmanaged_data', 1),json_object()), ('129','Array',json_object('typename', 'Array','type', null,'scdesc', 'gen/moar/BOOTSTRAP/v6c.nqp','repr', 'P6opaque','managed_size', 56),json_object()), ('178','NQPDecoder',json_object('typename', 'NQPDecoder','type', null,'scdesc', 'gen/moar/stage2/NQPCORE.setting','repr', 'Decoder','managed_size', 48),json_object()), ('158','MASTCompilerInstance',json_object('typename', 'MASTCompilerInstance','type', null,'scdesc', 'gen/moar/stage2/QAST.nqp','repr', 'P6opaque','managed_size', 120),json_object()), ('181','MoarVM::BytecodeWriter',json_object('typename', 'MoarVM::BytecodeWriter','type', null,'scdesc', 'gen/moar/stage2/QAST.nqp','repr', 'P6opaque','managed_size', 120),json_object()), ('16','BOOTHash',json_object('typename', 'BOOTHash','type', null,'scdesc', '','repr', 'VMHash','managed_size', 32,'has_unmanaged_data', 1),json_object()), ('109','Block',json_object('typename', 'Block','type', null,'scdesc', 'gen/moar/BOOTSTRAP/v6c.nqp','repr', 'P6opaque','managed_size', 72),json_object()), ('166','MAST::Bytecode',json_object('typename', 'MAST::Bytecode','type', null,'scdesc', 'gen/moar/stage2/MASTNodes.nqp','repr', 'VMArray','managed_size', 56,'has_unmanaged_data', 1),json_object()), ('130','VMString',json_object('typename', 'VMString','type', null,'scdesc', '','repr', 'MVMString','managed_size', 48,'has_unmanaged_data', 1),json_object()), ('174','QAST::Stmt',json_object('typename', 'QAST::Stmt','type', null,'scdesc', 'gen/moar/stage2/QASTNode.nqp','repr', 'P6opaque','managed_size', 80),json_object()), ('163','BOOTInt',json_object('typename', 'BOOTInt','type', null,'scdesc', '','repr', 'P6int','managed_size', 32),json_object()), ('160','RegAlloc',json_object('typename', 'RegAlloc','type', null,'scdesc', 'gen/moar/stage2/QAST.nqp','repr', 'P6opaque','managed_size', 56),json_object()), ('3','BOOTCode',json_object('typename', 'BOOTCode','type', null,'scdesc', '','repr', 'MVMCode','managed_size', 72),json_object()), ('183','MAST::Frame',json_object('typename', 'MAST::Frame','type', null,'scdesc', 'gen/moar/stage2/MASTNodes.nqp','repr', 'P6opaque','managed_size', 280),json_object()), ('167','QAST::Op',json_object('typename', 'QAST::Op','type', null,'scdesc', 'gen/moar/stage2/QASTNode.nqp','repr', 'P6opaque','managed_size', 104),json_object()), ('161','MAST::Local',json_object('typename', 'MAST::Local','type', null,'scdesc', 'gen/moar/stage2/MASTNodes.nqp','repr', 'P6opaque','managed_size', 40),json_object()), ('66','BOOTStrArray',json_object('typename', 'BOOTStrArray','type', null,'scdesc', '','repr', 'VMArray','managed_size', 56,'has_unmanaged_data', 1),json_object()), ('63','NQPArray',json_object('typename', 'NQPArray','type', null,'scdesc', 'gen/moar/stage2/NQPCORE.setting','repr', 'VMArray','managed_size', 56,'has_unmanaged_data', 1),json_object()), ('33','NQPArrayIter',json_object('typename', 'NQPArrayIter','type', null,'scdesc', 'gen/moar/stage2/NQPCORE.setting','repr', 'VMIter','managed_size', 56),json_object()), ('136','ContainerDescriptor::BindHashKey',json_object('typename', 'ContainerDescriptor::BindHashKey','type', null,'scdesc', 'gen/moar/BOOTSTRAP/v6c.nqp','repr', 'P6opaque','managed_size', 56),json_object()), ('172','QAST::Stmts',json_object('typename', 'QAST::Stmts','type', null,'scdesc', 'gen/moar/stage2/QASTNode.nqp','repr', 'P6opaque','managed_size', 80),json_object()), ('179','QAST::Var',json_object('typename', 'QAST::Var','type', null,'scdesc', 'gen/moar/stage2/QASTNode.nqp','repr', 'P6opaque','managed_size', 112),json_object()), ('176','MoarVM::StringHeap',json_object('typename', 'MoarVM::StringHeap','type', null,'scdesc', 'gen/moar/stage2/QAST.nqp','repr', 'P6opaque','managed_size', 64),json_object()), ('175','NQPMatch',json_object('typename', 'NQPMatch','type', null,'scdesc', 'gen/moar/stage2/QRegex.nqp','repr', 'P6opaque','managed_size', 144),json_object()), ('159','BlockInfo',json_object('typename', 'BlockInfo','type', null,'scdesc', 'gen/moar/stage2/QAST.nqp','repr', 'P6opaque','managed_size', 168),json_object()), ('94','List',json_object('typename', 'List','type', null,'scdesc', 'gen/moar/BOOTSTRAP/v6c.nqp','repr', 'P6opaque','managed_size', 48),json_object()), ('76','Scalar',json_object('typename', 'Scalar','type', null,'scdesc', 'gen/moar/BOOTSTRAP/v6c.nqp','repr', 'P6opaque','managed_size', 48),json_object()), ('182','MAST::CompUnit',json_object('typename', 'MAST::CompUnit','type', null,'scdesc', 'gen/moar/stage2/MASTNodes.nqp','repr', 'P6opaque','managed_size', 144),json_object()), ('100','Backtrace',json_object('typename', 'Backtrace','type', null,'scdesc', 'gen/moar/CORE.c.setting','repr', 'P6opaque','managed_size', 56),json_object()), ('169','NQPHashIter',json_object('typename', 'NQPHashIter','type', null,'scdesc', 'gen/moar/stage2/NQPCORE.setting','repr', 'VMIter','managed_size', 56),json_object()), ('170','SubBuffer',json_object('typename', 'SubBuffer','type', null,'scdesc', 'gen/moar/stage2/MASTNodes.nqp','repr', 'P6opaque','managed_size', 72),json_object()), ('177','MoarVM::Callsites',json_object('typename', 'MoarVM::Callsites','type', null,'scdesc', 'gen/moar/stage2/QAST.nqp','repr', 'P6opaque','managed_size', 64),json_object()), ('180','QAST::CompUnit',json_object('typename', 'QAST::CompUnit','type', null,'scdesc', 'gen/moar/stage2/QASTNode.nqp','repr', 'P6opaque','managed_size', 152),json_object()), ('157','SpeshLog',json_object('typename', 'SpeshLog','type', null,'scdesc', '','repr', 'MVMSpeshLog','managed_size', 80,'has_unmanaged_data', 1),json_object()), ('168','QAST::VM',json_object('typename', 'QAST::VM','type', null,'scdesc', 'gen/moar/stage2/QASTNode.nqp','repr', 'P6opaque','managed_size', 80),json_object());
INSERT INTO gcs VALUES (2907,17640,806264,7542,138,0,1,3370360,6417,1,1), (2146,80,17560,129,18,0,1,4176640,16712,2,1), (1662,80,0,13,0,0,1,4194200,26086,3,1), (1560,80,0,13,0,0,1,4194200,34927,4,1), (1570,80,0,13,0,0,1,4194200,43528,5,1), (1495,80,0,13,0,0,1,4194200,51978,6,1), (1566,80,0,13,0,0,1,4194200,60414,7,1), (1548,80,0,13,0,0,1,4194200,69031,8,1), (1504,80,0,13,0,0,1,4194200,77711,9,1), (1489,80,0,13,0,0,1,4194200,86419,10,1), (1501,80,0,13,0,0,1,4194200,95096,11,1), (1572,80,0,13,0,0,1,4194200,103763,12,1), (1490,80,0,13,0,0,1,4194200,112489,13,1), (1505,80,0,13,0,0,1,4194200,121198,14,1), (1534,80,0,13,0,0,1,4194200,129869,15,1), (1541,80,0,13,0,0,1,4194200,138564,16,1), (1544,80,0,13,0,0,1,4194200,147059,17,1), (1477,80,0,13,0,0,1,4194200,155477,18,1), (1467,80,0,13,0,0,1,4194200,163836,19,1);
INSERT INTO deallocations VALUES (1,1,33,361,1,0), (1,1,63,548,3,0), (1,1,157,7,1,0), (1,1,7,6147,27,0), (1,1,3,503,4,0), (1,1,16,459,2,0), (1,1,158,2,1,0), (1,1,11,1405,2,0), (1,1,6,3684,1,0), (1,1,159,8,0,0), (1,1,160,8,0,0), (1,1,64,99,0,0), (1,1,161,47,0,0), (1,1,162,207,0,0), (1,1,163,284,0,0), (1,1,164,18,0,0), (1,1,130,20,0,0), (1,1,165,11,0,0), (1,1,166,39,0,0), (1,1,167,13,0,0), (1,1,168,2,0,0), (1,1,66,36,0,0), (1,1,169,48,0,0), (1,1,170,12,0,0), (1,1,171,1,0,0), (1,1,172,1,0,0), (1,1,173,4,0,0), (1,1,174,5,0,0), (1,1,175,1,0,0), (1,1,176,1,0,0), (1,1,177,1,0,0), (1,1,178,1,0,0), (1,1,179,1,0,0), (1,1,180,2,0,0), (1,1,181,2,0,0), (1,1,182,2,0,0), (1,1,183,2,0,0), (1,1,68,5,0,0), (1,1,73,1,0,0), (1,1,94,2,0,0), (1,1,76,845,0,0), (1,1,116,1,0,0), (1,1,113,64265,0,0), (2,1,113,104414,2,0), (3,1,113,104853,2,0), (4,1,113,104853,2,0), (5,1,113,104853,2,0), (6,1,113,104853,2,0), (7,1,113,104853,2,0), (8,1,113,104853,2,0), (9,1,113,104853,2,0), (10,1,113,104853,2,0), (11,1,113,104853,2,0), (12,1,113,104853,2,0), (13,1,113,104853,2,0), (14,1,113,104853,2,0), (15,1,113,104853,2,0), (16,1,113,104853,2,0), (17,1,113,104853,2,0), (18,1,113,104853,2,0), (19,1,113,104853,2,0);
INSERT INTO calls VALUES (0,0,0,0,0,0,0,139110,267,1,0,0,0,0,1230), (1,0,1,0,0,0,0,137209,6,1,0,0,0,243,738), (2,1,2,0,0,0,0,137202,268,1,0,0,0,250,738), (3,2,5,0,0,0,0,386,296,2,0,0,0,262,24), (4,3,8,0,0,0,0,3,3,1,0,0,0,478,4);
INSERT INTO calls VALUES (5,3,9,0,0,0,0,31,11,1,0,0,0,489,10), (6,5,8,0,0,0,0,0,0,1,0,0,0,490,6), (7,5,10,0,0,0,0,19,14,1,0,0,0,498,10), (8,7,8,0,0,0,0,1,1,3,0,0,0,499,8), (9,7,12,0,0,0,0,0,0,1,0,0,0,504,9), (10,7,13,0,0,0,0,2,2,1,0,0,0,514,10), (11,3,14,0,0,0,0,4,3,1,0,0,0,536,12), (12,11,8,0,0,0,0,0,0,1,0,0,0,538,12), (13,3,15,0,0,0,0,50,34,2,0,0,0,548,24), (14,13,17,0,0,0,0,5,4,1,0,0,0,556,17), (15,14,8,0,0,0,0,0,0,1,0,0,0,557,15), (16,14,10,0,0,0,0,1,0,1,0,0,0,560,17), (17,16,12,0,0,0,0,0,0,1,0,0,0,560,17), (18,13,9,0,0,0,0,4,2,3,0,0,0,562,20), (19,18,10,0,0,0,0,1,1,3,0,0,0,563,20), (20,19,12,0,0,0,0,0,0,3,0,0,0,563,20), (21,13,14,0,0,0,0,2,2,3,0,0,0,564,21), (22,13,18,0,0,0,0,0,0,2,0,0,0,567,22), (23,13,19,0,0,0,0,1,1,2,0,0,0,575,23), (24,13,20,0,0,0,0,0,0,5,0,0,0,581,24), (25,2,21,0,0,0,0,133,56,2,0,0,0,607,70), (26,25,8,0,0,0,0,0,0,1,0,0,0,609,26), (27,25,22,0,0,0,0,51,7,2,0,0,0,617,59), (28,27,8,0,0,0,0,0,0,1,0,0,0,617,28), (29,27,9,0,0,0,0,1,0,1,0,0,0,620,31), (30,29,10,0,0,0,0,0,0,1,0,0,0,620,31), (31,30,12,0,0,0,0,0,0,1,0,0,0,620,31), (32,27,14,0,0,0,0,0,0,1,0,0,0,621,32), (33,27,15,0,0,0,0,40,14,2,0,0,0,622,58), (34,33,18,0,0,0,0,0,0,2,0,0,0,623,34), (35,33,19,0,0,0,0,0,0,2,0,0,0,623,35), (36,33,20,0,0,0,0,1,1,12,0,0,0,624,36), (37,33,8,0,0,0,0,6,3,1,0,0,0,626,41), (38,37,10,0,0,0,0,1,0,1,0,0,0,627,40), (39,38,12,0,0,0,0,0,0,1,0,0,0,628,39), (40,38,8,0,0,0,0,0,0,1,0,0,1,628,40), (41,37,23,0,0,0,0,1,1,1,0,0,0,631,41), (42,33,17,0,0,0,0,1,0,1,0,0,0,633,44), (43,42,10,0,0,0,0,0,0,1,0,0,0,633,44), (44,43,12,0,0,0,0,0,0,1,0,0,0,633,44), (45,33,9,0,0,0,0,1,0,1,0,0,0,635,47), (46,45,10,0,0,0,0,0,0,1,0,0,0,635,47), (47,46,12,0,0,0,0,0,0,1,0,0,0,635,47), (48,33,14,0,0,0,0,0,0,1,0,0,0,636,48), (49,33,24,0,0,0,0,13,7,2,0,0,0,646,58), (50,49,9,0,0,0,0,1,1,2,0,0,0,647,52), (51,50,10,0,0,0,0,0,0,2,0,0,0,647,52), (52,51,12,0,0,0,0,0,0,2,0,0,0,647,52), (53,49,14,0,0,0,0,1,1,2,0,0,0,648,53), (54,49,19,0,0,0,0,0,0,2,0,0,0,649,54), (55,49,17,0,0,0,0,0,0,1,0,0,0,650,57), (56,55,10,0,0,0,0,0,0,1,0,0,0,650,57), (57,56,12,0,0,0,0,0,0,1,0,0,0,651,57), (58,49,24,0,0,0,0,2,2,10,0,0,1,655,58), (59,27,25,0,0,0,0,1,1,2,0,0,0,661,59), (60,25,5,0,0,0,0,2,1,1,0,0,0,669,64), (61,60,15,0,0,0,0,1,0,1,0,0,0,670,64), (62,61,18,0,0,0,0,0,0,1,0,0,0,670,62), (63,61,19,0,0,0,0,0,0,1,0,0,0,670,63), (64,61,20,0,0,0,0,0,0,2,0,0,0,671,64), (65,25,21,0,0,0,0,19,11,1,0,0,1,672,67), (66,65,26,0,0,0,0,8,7,1,0,0,0,683,67), (67,66,8,0,0,0,0,0,0,3,0,0,0,683,67), (68,25,27,0,0,0,0,2,2,1,0,0,0,732,69), (69,68,8,0,0,0,0,0,0,1,0,0,0,733,69), (70,25,28,0,0,0,0,0,0,2,0,0,0,738,70), (71,2,29,0,0,0,0,284,18,2,0,0,0,742,228), (72,71,5,0,0,0,0,2,0,1,0,0,0,742,76), (73,72,15,0,0,0,0,1,0,1,0,0,0,743,76), (74,73,18,0,0,0,0,0,0,1,0,0,0,743,74), (75,73,19,0,0,0,0,0,0,1,0,0,0,743,75), (76,73,20,0,0,0,0,0,0,2,0,0,0,744,76), (77,71,21,0,0,0,0,0,0,1,0,0,0,745,77), (78,71,27,0,0,0,0,0,0,1,0,0,0,745,78), (79,71,30,0,0,0,0,7,3,2,0,0,0,750,88), (80,79,5,0,0,0,0,2,0,1,0,0,0,751,84), (81,80,15,0,0,0,0,1,0,1,0,0,0,751,84), (82,81,18,0,0,0,0,0,0,1,0,0,0,751,82), (83,81,19,0,0,0,0,0,0,1,0,0,0,751,83), (84,81,20,0,0,0,0,0,0,2,0,0,0,752,84), (85,79,21,0,0,0,0,0,0,1,0,0,0,753,85), (86,79,27,0,0,0,0,0,0,1,0,0,0,753,86), (87,79,31,0,0,0,0,1,0,2,0,0,0,756,88), (88,87,8,0,0,0,0,0,0,1,0,0,0,756,88), (89,71,8,0,0,0,0,0,0,2,0,0,0,757,89), (90,71,32,0,0,0,0,254,29,2,0,0,0,770,228), (91,90,5,0,0,0,0,8,2,4,0,0,0,771,95), (92,91,15,0,0,0,0,5,3,4,0,0,0,772,95), (93,92,18,0,0,0,0,0,0,4,0,0,0,772,93), (94,92,19,0,0,0,0,1,1,4,0,0,0,772,94), (95,92,20,0,0,0,0,0,0,7,0,0,0,772,95), (96,90,21,0,0,0,0,4,3,4,0,0,0,774,97), (97,96,28,0,0,0,0,0,0,4,0,0,0,774,97), (98,90,27,0,0,0,0,36,17,4,0,0,0,775,108), (99,98,9,0,0,0,0,2,1,2,0,0,0,775,101), (100,99,10,0,0,0,0,0,0,2,0,0,0,776,101), (101,100,12,0,0,0,0,0,0,2,0,0,0,776,101), (102,98,14,0,0,0,0,1,1,2,0,0,0,777,102), (103,98,15,0,0,0,0,15,8,8,0,0,0,779,107), (104,103,18,0,0,0,0,1,0,8,0,0,0,779,104), (105,103,19,0,0,0,0,2,1,8,0,0,0,780,105), (106,103,20,0,0,0,0,3,2,48,0,0,0,780,106), (107,103,8,0,0,0,0,0,0,1,0,0,0,781,107), (108,98,34,0,0,0,0,1,1,4,0,0,0,794,108), (109,90,35,0,0,0,0,16,11,2,0,0,0,800,112), (110,109,36,0,0,0,0,4,3,1,0,0,0,811,112), (111,110,8,0,0,0,0,0,0,1,0,0,0,812,111), (112,110,37,0,0,0,0,0,0,1,0,0,0,814,112), (113,90,38,0,0,0,0,2,2,1,0,0,0,825,113), (114,90,39,0,0,0,0,138,6,4,0,0,0,841,174), (115,114,40,0,0,0,0,131,27,1,0,0,0,847,174), (116,115,41,0,0,0,0,104,37,1,0,0,0,873,174), (117,116,9,0,0,0,0,10,5,10,0,0,0,875,119), (118,117,10,0,0,0,0,4,3,10,0,0,0,875,119), (119,118,12,0,0,0,0,0,0,10,0,0,0,875,119), (120,116,14,0,0,0,0,5,5,11,0,0,0,876,120), (121,116,42,0,0,0,0,4,2,3,0,0,0,880,126), (122,121,9,0,0,0,0,1,0,1,0,0,0,880,124), (123,122,10,0,0,0,0,0,0,1,0,0,0,881,124), (124,123,12,0,0,0,0,0,0,1,0,0,0,881,124), (125,121,14,0,0,0,0,0,0,1,0,0,0,882,125), (126,121,43,0,0,0,0,0,0,3,0,0,0,883,126), (127,116,44,0,0,0,0,0,0,1,0,0,0,889,127), (128,116,45,0,0,0,0,30,5,2,0,0,0,895,148), (129,128,9,0,0,0,0,1,0,1,0,0,0,895,131), (130,129,10,0,0,0,0,0,0,1,0,0,0,895,131), (131,130,12,0,0,0,0,0,0,1,0,0,0,896,131), (132,128,14,0,0,0,0,0,0,1,0,0,0,896,132), (133,128,46,0,0,0,0,23,9,2,0,0,0,901,148), (134,133,9,0,0,0,0,4,2,4,0,0,0,902,136), (135,134,10,0,0,0,0,1,1,4,0,0,0,902,136), (136,135,12,0,0,0,0,0,0,4,0,0,0,902,136), (137,133,14,0,0,0,0,1,1,4,0,0,0,903,137), (138,133,47,0,0,0,0,0,0,2,0,0,0,904,138), (139,133,13,0,0,0,0,0,0,1,0,0,0,905,139), (140,133,48,0,0,0,0,7,2,2,0,0,0,909,146), (141,140,9,0,0,0,0,1,0,1,0,0,0,910,143), (142,141,10,0,0,0,0,0,0,1,0,0,0,910,143), (143,142,12,0,0,0,0,0,0,1,0,0,0,910,143), (144,140,14,0,0,0,0,0,0,1,0,0,0,911,144), (145,140,49,0,0,0,0,2,2,2,0,0,0,913,146), (146,145,50,0,0,0,0,0,0,2,0,0,0,916,146), (147,133,51,0,0,0,0,0,0,2,0,0,0,920,147), (148,133,44,0,0,0,0,0,0,2,0,0,0,922,148), (149,116,52,0,0,0,0,0,0,1,0,0,0,927,149), (150,116,8,0,0,0,0,0,0,2,0,0,0,928,150), (151,116,53,0,0,0,0,0,0,1,0,0,0,939,151), (152,116,54,0,0,0,0,3,1,1,0,0,0,946,158), (153,152,9,0,0,0,0,0,0,1,0,0,0,947,155), (154,153,10,0,0,0,0,0,0,1,0,0,0,947,155), (155,154,12,0,0,0,0,0,0,1,0,0,0,947,155), (156,152,14,0,0,0,0,0,0,1,0,0,0,948,156), (157,152,46,0,0,0,0,0,0,1,0,0,0,949,158), (158,157,47,0,0,0,0,0,0,1,0,0,0,949,158), (159,116,55,0,0,0,0,0,0,1,0,0,0,953,160), (160,159,50,0,0,0,0,0,0,1,0,0,0,954,160), (161,116,56,0,0,0,0,0,0,1,0,0,0,960,161), (162,116,26,0,0,0,0,5,4,1,0,0,0,962,164), (163,162,10,0,0,0,0,0,0,1,0,0,0,964,164), (164,163,12,0,0,0,0,0,0,1,0,0,0,964,164), (165,116,57,0,0,0,0,7,2,1,0,0,0,971,174), (166,165,9,0,0,0,0,3,2,2,0,0,0,971,168), (167,166,10,0,0,0,0,0,0,2,0,0,0,971,168), (168,167,12,0,0,0,0,0,0,2,0,0,0,972,168), (169,165,14,0,0,0,0,0,0,2,0,0,0,974,169), (170,165,49,0,0,0,0,0,0,1,0,0,0,975,171), (171,170,50,0,0,0,0,0,0,1,0,0,0,975,171), (172,165,55,0,0,0,0,0,0,1,0,0,0,977,173), (173,172,50,0,0,0,0,0,0,1,0,0,0,977,173), (174,165,8,0,0,0,0,0,0,1,0,0,0,978,174), (175,90,58,0,0,0,0,9,0,2,0,0,0,991,201), (176,175,40,0,0,0,0,8,0,1,0,0,0,991,201), (177,176,41,0,0,0,0,7,2,1,0,0,0,992,201), (178,177,42,0,0,0,0,0,0,3,0,0,0,992,179), (179,178,43,0,0,0,0,0,0,3,0,0,0,993,179), (180,177,44,0,0,0,0,0,0,1,0,0,0,993,180), (181,177,45,0,0,0,0,2,0,2,0,0,0,993,188), (182,181,46,0,0,0,0,2,1,2,0,0,0,993,188), (183,182,47,0,0,0,0,0,0,2,0,0,0,994,183), (184,182,48,0,0,0,0,0,0,2,0,0,0,994,186), (185,184,49,0,0,0,0,0,0,2,0,0,0,994,186), (186,185,50,0,0,0,0,0,0,2,0,0,0,994,186), (187,182,51,0,0,0,0,0,0,2,0,0,0,994,187), (188,182,44,0,0,0,0,0,0,2,0,0,0,995,188), (189,177,52,0,0,0,0,0,0,1,0,0,0,995,189), (190,177,53,0,0,0,0,0,0,1,0,0,0,997,190), (191,177,54,0,0,0,0,0,0,1,0,0,0,997,193), (192,191,46,0,0,0,0,0,0,1,0,0,0,997,193), (193,192,47,0,0,0,0,0,0,1,0,0,0,997,193), (194,177,55,0,0,0,0,0,0,1,0,0,0,998,195), (195,194,50,0,0,0,0,0,0,1,0,0,0,998,195), (196,177,56,0,0,0,0,0,0,1,0,0,0,998,196), (197,177,57,0,0,0,0,0,0,1,0,0,0,999,201), (198,197,49,0,0,0,0,0,0,1,0,0,0,999,199), (199,198,50,0,0,0,0,0,0,1,0,0,0,999,199), (200,197,55,0,0,0,0,0,0,1,0,0,0,999,201), (201,200,50,0,0,0,0,0,0,1,0,0,0,999,201), (202,90,59,0,0,0,0,7,0,2,0,0,0,1012,228), (203,202,40,0,0,0,0,6,0,1,0,0,0,1012,228), (204,203,41,0,0,0,0,6,1,1,0,0,0,1013,228), (205,204,42,0,0,0,0,0,0,3,0,0,0,1013,206), (206,205,43,0,0,0,0,0,0,3,0,0,0,1013,206), (207,204,44,0,0,0,0,0,0,1,0,0,0,1013,207), (208,204,45,0,0,0,0,2,0,2,0,0,0,1014,215), (209,208,46,0,0,0,0,1,1,2,0,0,0,1014,215), (210,209,47,0,0,0,0,0,0,2,0,0,0,1014,210), (211,209,48,0,0,0,0,0,0,2,0,0,0,1014,213), (212,211,49,0,0,0,0,0,0,2,0,0,0,1014,213), (213,212,50,0,0,0,0,0,0,2,0,0,0,1014,213), (214,209,51,0,0,0,0,0,0,2,0,0,0,1015,214), (215,209,44,0,0,0,0,0,0,2,0,0,0,1015,215), (216,204,52,0,0,0,0,0,0,1,0,0,0,1015,216), (217,204,53,0,0,0,0,0,0,1,0,0,0,1017,217), (218,204,54,0,0,0,0,0,0,1,0,0,0,1017,220), (219,218,46,0,0,0,0,0,0,1,0,0,0,1017,220), (220,219,47,0,0,0,0,0,0,1,0,0,0,1017,220), (221,204,55,0,0,0,0,0,0,1,0,0,0,1017,222), (222,221,50,0,0,0,0,0,0,1,0,0,0,1017,222), (223,204,56,0,0,0,0,0,0,1,0,0,0,1018,223), (224,204,57,0,0,0,0,0,0,1,0,0,0,1018,228), (225,224,49,0,0,0,0,0,0,1,0,0,0,1018,226), (226,225,50,0,0,0,0,0,0,1,0,0,0,1018,226), (227,224,55,0,0,0,0,0,0,1,0,0,0,1019,228), (228,227,50,0,0,0,0,0,0,1,0,0,0,1019,228), (229,2,60,0,0,0,0,116,59,2,0,0,0,1035,270), (230,229,5,0,0,0,0,2,0,1,0,0,0,1036,234), (231,230,15,0,0,0,0,1,0,1,0,0,0,1036,234), (232,231,18,0,0,0,0,0,0,1,0,0,0,1036,232), (233,231,19,0,0,0,0,0,0,1,0,0,0,1037,233), (234,231,20,0,0,0,0,0,0,2,0,0,0,1037,234), (235,229,21,0,0,0,0,0,0,1,0,0,0,1038,235), (236,229,27,0,0,0,0,0,0,1,0,0,0,1039,236), (237,229,61,0,0,0,0,0,0,2,0,0,0,1042,237), (238,229,62,0,0,0,0,44,27,2,0,0,0,1090,255), (239,238,8,0,0,0,0,1,1,5,0,0,0,1091,239), (240,238,65,0,0,0,0,4,4,2,0,0,0,1103,240), (241,238,22,0,0,0,0,6,1,1,0,0,0,1107,249), (242,241,15,0,0,0,0,5,1,1,0,0,0,1108,248), (243,242,18,0,0,0,0,0,0,1,0,0,0,1108,243), (244,242,19,0,0,0,0,0,0,1,0,0,0,1109,244), (245,242,20,0,0,0,0,0,0,6,0,0,0,1109,245), (246,242,24,0,0,0,0,2,1,1,0,0,0,1111,248), (247,246,19,0,0,0,0,0,0,1,0,0,0,1111,247), (248,246,24,0,0,0,0,0,0,5,0,0,1,1112,248), (249,241,25,0,0,0,0,0,0,1,0,0,0,1114,249), (250,238,9,0,0,0,0,2,1,2,0,0,0,1117,252), (251,250,10,0,0,0,0,1,1,2,0,0,0,1117,252), (252,251,12,0,0,0,0,0,0,2,0,0,0,1118,252), (253,238,14,0,0,0,0,1,1,2,0,0,0,1119,253), (254,238,67,0,0,0,0,0,0,2,0,0,0,1121,254);
INSERT INTO calls VALUES (255,238,69,0,0,0,0,0,0,2,0,0,0,1126,255), (256,229,9,0,0,0,0,2,1,2,0,0,0,1127,258), (257,256,10,0,0,0,0,0,0,2,0,0,0,1127,258), (258,257,12,0,0,0,0,0,0,2,0,0,0,1127,258), (259,229,14,0,0,0,0,0,0,2,0,0,0,1128,259), (260,229,70,0,0,0,0,0,0,2,0,0,0,1130,260), (261,229,71,0,0,0,0,0,0,2,0,0,0,1135,261), (262,229,22,0,0,0,0,5,1,1,0,0,0,1135,270), (263,262,15,0,0,0,0,4,1,1,0,0,0,1136,269), (264,263,18,0,0,0,0,0,0,1,0,0,0,1136,264), (265,263,19,0,0,0,0,0,0,1,0,0,0,1136,265), (266,263,20,0,0,0,0,0,0,6,0,0,0,1137,266), (267,263,24,0,0,0,0,2,1,1,0,0,0,1138,269), (268,267,19,0,0,0,0,0,0,1,0,0,0,1138,268), (269,267,24,0,0,0,0,0,0,5,0,0,1,1139,269), (270,262,25,0,0,0,0,0,0,1,0,0,0,1141,270), (271,2,27,0,0,0,0,10,3,2,0,0,0,1143,276), (272,271,15,0,0,0,0,7,4,4,0,0,0,1143,275), (273,272,18,0,0,0,0,0,0,4,0,0,0,1143,273), (274,272,19,0,0,0,0,1,1,4,0,0,0,1143,274), (275,272,20,0,0,0,0,1,1,24,0,0,0,1144,275), (276,271,34,0,0,0,0,0,0,2,0,0,0,1147,276), (277,2,72,0,0,0,0,345,187,1,0,0,0,1367,339), (278,277,22,0,0,0,0,5,1,2,0,0,0,1369,283), (279,278,15,0,0,0,0,3,1,2,0,0,0,1369,282), (280,279,18,0,0,0,0,0,0,2,0,0,0,1370,280), (281,279,19,0,0,0,0,0,0,2,0,0,0,1370,281), (282,279,20,0,0,0,0,0,0,5,0,0,0,1371,282), (283,278,25,0,0,0,0,0,0,2,0,0,0,1372,283), (284,277,5,0,0,0,0,1,0,1,0,0,0,1376,286), (285,284,15,0,0,0,0,0,0,1,0,0,0,1376,286), (286,285,18,0,0,0,0,0,0,1,0,0,0,1376,286), (287,277,21,0,0,0,0,31,2,1,0,0,0,1377,304), (288,287,22,0,0,0,0,26,15,2,0,0,0,1378,296), (289,288,15,0,0,0,0,9,3,2,0,0,0,1393,295), (290,289,18,0,0,0,0,0,0,2,0,0,0,1393,290), (291,289,19,0,0,0,0,0,0,2,0,0,0,1393,291), (292,289,20,0,0,0,0,1,0,14,0,0,0,1394,292), (293,289,24,0,0,0,0,4,2,2,0,0,0,1395,295), (294,293,19,0,0,0,0,0,0,2,0,0,0,1396,294), (295,293,24,0,0,0,0,1,1,12,0,0,1,1396,295), (296,288,25,0,0,0,0,0,0,2,0,0,0,1398,296), (297,287,5,0,0,0,0,1,0,1,0,0,0,1405,301), (298,297,15,0,0,0,0,1,0,1,0,0,0,1405,301), (299,298,18,0,0,0,0,0,0,1,0,0,0,1405,299), (300,298,19,0,0,0,0,0,0,1,0,0,0,1405,300), (301,298,20,0,0,0,0,0,0,3,0,0,0,1406,301), (302,287,21,0,0,0,0,0,0,1,0,0,1,1407,302), (303,287,27,0,0,0,0,0,0,1,0,0,0,1407,303), (304,287,28,0,0,0,0,0,0,1,0,0,0,1408,304), (305,277,27,0,0,0,0,5,1,1,0,0,0,1409,310), (306,305,15,0,0,0,0,3,2,2,0,0,0,1409,309), (307,306,18,0,0,0,0,0,0,2,0,0,0,1409,307), (308,306,19,0,0,0,0,0,0,2,0,0,0,1409,308), (309,306,20,0,0,0,0,1,0,14,0,0,0,1410,309), (310,305,34,0,0,0,0,0,0,1,0,0,0,1414,310), (311,277,75,0,0,0,0,112,22,1,0,0,0,1598,337), (312,311,77,0,0,0,0,68,19,3,0,0,0,1603,323), (313,312,37,0,0,0,0,0,0,3,0,0,0,1605,313), (314,312,78,0,0,0,0,48,14,3,0,0,0,1619,323), (315,314,79,0,0,0,0,34,11,2,0,0,0,1638,323), (316,315,9,0,0,0,0,4,2,3,0,0,0,1640,318), (317,316,10,0,0,0,0,2,2,3,0,0,0,1640,318), (318,317,12,0,0,0,0,0,0,4,0,0,0,1641,318), (319,315,14,0,0,0,0,1,1,3,0,0,0,1643,319), (320,315,80,0,0,0,0,0,0,2,0,0,0,1645,320), (321,315,81,0,0,0,0,15,9,2,0,0,0,1650,322), (322,321,82,0,0,0,0,5,5,1,0,0,0,1659,322), (323,315,83,0,0,0,0,0,0,2,0,0,0,1669,323), (324,311,84,0,0,0,0,0,0,1,0,0,0,1626,324), (325,311,85,0,0,0,0,0,0,2,0,0,0,1673,325), (326,311,86,0,0,0,0,21,10,2,0,0,0,1684,337), (327,326,9,0,0,0,0,1,0,1,0,0,0,1685,329), (328,327,10,0,0,0,0,0,0,1,0,0,0,1686,329), (329,328,12,0,0,0,0,0,0,1,0,0,0,1686,329), (330,326,14,0,0,0,0,0,0,1,0,0,0,1687,330), (331,326,87,0,0,0,0,9,4,2,0,0,0,1692,337), (332,331,9,0,0,0,0,1,1,2,0,0,0,1693,334), (333,332,10,0,0,0,0,0,0,2,0,0,0,1693,334), (334,333,12,0,0,0,0,0,0,2,0,0,0,1693,334), (335,331,14,0,0,0,0,0,0,2,0,0,0,1694,335), (336,331,19,0,0,0,0,1,1,2,0,0,0,1695,336), (337,331,88,0,0,0,0,0,0,2,0,0,0,1700,337), (338,277,36,0,0,0,0,0,0,1,0,0,0,1711,339), (339,338,37,0,0,0,0,0,0,1,0,0,0,1712,339), (340,2,89,0,0,0,0,299,17,1,0,0,0,1789,514), (341,340,91,0,0,0,0,107,20,1,0,0,0,1799,430), (342,341,5,0,0,0,0,10,3,5,0,0,0,1801,346), (343,342,15,0,0,0,0,6,3,5,0,0,0,1801,346), (344,343,18,0,0,0,0,0,0,5,0,0,0,1802,344), (345,343,19,0,0,0,0,1,1,5,0,0,0,1802,345), (346,343,20,0,0,0,0,0,0,11,0,0,0,1802,346), (347,341,21,0,0,0,0,22,6,5,0,0,0,1804,364), (348,347,28,0,0,0,0,0,0,4,0,0,0,1811,348), (349,347,22,0,0,0,0,12,1,2,0,0,0,1833,357), (350,349,15,0,0,0,0,10,3,2,0,0,0,1834,356), (351,350,18,0,0,0,0,0,0,2,0,0,0,1834,351), (352,350,19,0,0,0,0,0,0,2,0,0,0,1834,352), (353,350,20,0,0,0,0,1,0,14,0,0,0,1835,353), (354,350,24,0,0,0,0,5,2,2,0,0,0,1837,356), (355,354,19,0,0,0,0,0,0,2,0,0,0,1837,355), (356,354,24,0,0,0,0,2,1,12,0,0,1,1838,356), (357,349,25,0,0,0,0,0,0,2,0,0,0,1840,357), (358,347,5,0,0,0,0,1,0,1,0,0,0,1847,362), (359,358,15,0,0,0,0,1,0,1,0,0,0,1847,362), (360,359,18,0,0,0,0,0,0,1,0,0,0,1847,360), (361,359,19,0,0,0,0,0,0,1,0,0,0,1847,361), (362,359,20,0,0,0,0,0,0,3,0,0,0,1848,362), (363,347,21,0,0,0,0,0,0,1,0,0,1,1849,363), (364,347,27,0,0,0,0,0,0,1,0,0,0,1849,364), (365,341,27,0,0,0,0,18,4,5,0,0,0,1804,370), (366,365,15,0,0,0,0,13,7,8,0,0,0,1812,369), (367,366,18,0,0,0,0,0,0,8,0,0,0,1812,367), (368,366,19,0,0,0,0,1,1,8,0,0,0,1812,368), (369,366,20,0,0,0,0,3,2,48,0,0,0,1813,369), (370,365,34,0,0,0,0,0,0,4,0,0,0,1816,370), (371,341,92,0,0,0,0,0,0,1,0,0,0,1806,371), (372,341,13,0,0,0,0,0,0,1,0,0,0,1807,372), (373,341,35,0,0,0,0,0,0,1,0,0,0,1817,373), (374,341,93,0,0,0,0,2,1,1,0,0,0,1827,376), (375,374,36,0,0,0,0,0,0,1,0,0,0,1828,376), (376,375,37,0,0,0,0,0,0,1,0,0,0,1828,376), (377,341,29,0,0,0,0,19,1,1,0,0,0,1851,411), (378,377,5,0,0,0,0,1,0,1,0,0,0,1851,382), (379,378,15,0,0,0,0,1,0,1,0,0,0,1851,382), (380,379,18,0,0,0,0,0,0,1,0,0,0,1851,380), (381,379,19,0,0,0,0,0,0,1,0,0,0,1852,381), (382,379,20,0,0,0,0,0,0,3,0,0,0,1852,382), (383,377,21,0,0,0,0,0,0,1,0,0,0,1853,383), (384,377,27,0,0,0,0,0,0,1,0,0,0,1853,384), (385,377,30,0,0,0,0,3,1,1,0,0,0,1854,393), (386,385,5,0,0,0,0,1,0,1,0,0,0,1854,390), (387,386,15,0,0,0,0,1,0,1,0,0,0,1855,390), (388,387,18,0,0,0,0,0,0,1,0,0,0,1855,388), (389,387,19,0,0,0,0,0,0,1,0,0,0,1855,389), (390,387,20,0,0,0,0,0,0,3,0,0,0,1855,390), (391,385,21,0,0,0,0,0,0,1,0,0,0,1856,391), (392,385,27,0,0,0,0,0,0,1,0,0,0,1856,392), (393,385,31,0,0,0,0,0,0,1,0,0,0,1857,393), (394,377,32,0,0,0,0,11,2,1,0,0,0,1858,411), (395,394,5,0,0,0,0,2,0,1,0,0,0,1859,399), (396,395,15,0,0,0,0,1,0,1,0,0,0,1859,399), (397,396,18,0,0,0,0,0,0,1,0,0,0,1859,397), (398,396,19,0,0,0,0,0,0,1,0,0,0,1859,398), (399,396,20,0,0,0,0,0,0,5,0,0,0,1860,399), (400,394,21,0,0,0,0,0,0,1,0,0,0,1861,401), (401,400,28,0,0,0,0,0,0,1,0,0,0,1861,401), (402,394,27,0,0,0,0,4,1,1,0,0,0,1862,407), (403,402,15,0,0,0,0,3,1,2,0,0,0,1862,406), (404,403,18,0,0,0,0,0,0,2,0,0,0,1862,404), (405,403,19,0,0,0,0,0,0,2,0,0,0,1862,405), (406,403,20,0,0,0,0,0,0,12,0,0,0,1863,406), (407,402,34,0,0,0,0,0,0,1,0,0,0,1866,407), (408,394,35,0,0,0,0,0,0,1,0,0,0,1867,408), (409,394,39,0,0,0,0,0,0,2,0,0,0,1868,409), (410,394,58,0,0,0,0,0,0,1,0,0,0,1868,410), (411,394,59,0,0,0,0,0,0,1,0,0,0,1869,411), (412,341,60,0,0,0,0,11,1,1,0,0,0,1870,426), (413,412,5,0,0,0,0,1,0,1,0,0,0,1870,417), (414,413,15,0,0,0,0,1,0,1,0,0,0,1870,417), (415,414,18,0,0,0,0,0,0,1,0,0,0,1871,415), (416,414,19,0,0,0,0,0,0,1,0,0,0,1871,416), (417,414,20,0,0,0,0,0,0,3,0,0,0,1871,417), (418,412,21,0,0,0,0,0,0,1,0,0,0,1872,418), (419,412,27,0,0,0,0,0,0,1,0,0,0,1872,419), (420,412,61,0,0,0,0,0,0,1,0,0,0,1873,420), (421,412,62,0,0,0,0,6,5,1,0,0,0,1874,424), (422,421,65,0,0,0,0,0,0,1,0,0,0,1878,422), (423,421,67,0,0,0,0,0,0,1,0,0,0,1879,423), (424,421,69,0,0,0,0,0,0,1,0,0,0,1880,424), (425,412,70,0,0,0,0,0,0,1,0,0,0,1880,425), (426,412,71,0,0,0,0,0,0,1,0,0,0,1880,426), (427,341,95,0,0,0,0,1,1,1,0,0,0,1891,427), (428,341,96,0,0,0,0,1,0,1,0,0,0,1902,430), (429,428,36,0,0,0,0,0,0,1,0,0,0,1903,430), (430,429,37,0,0,0,0,0,0,1,0,0,0,1903,430), (431,340,21,0,0,0,0,0,0,1,0,0,0,1907,432), (432,431,28,0,0,0,0,0,0,1,0,0,0,1907,432), (433,340,27,0,0,0,0,4,1,1,0,0,0,1908,438), (434,433,15,0,0,0,0,3,1,2,0,0,0,1908,437), (435,434,18,0,0,0,0,0,0,2,0,0,0,1908,435), (436,434,19,0,0,0,0,0,0,2,0,0,0,1908,436), (437,434,20,0,0,0,0,1,0,12,0,0,0,1909,437), (438,433,34,0,0,0,0,0,0,1,0,0,0,1912,438), (439,340,97,0,0,0,0,168,23,1,0,0,0,1919,512), (440,439,5,0,0,0,0,42,39,3,0,0,0,1920,444), (441,440,15,0,0,0,0,3,1,3,0,0,0,1920,444), (442,441,18,0,0,0,0,0,0,3,0,0,0,1920,442), (443,441,19,0,0,0,0,0,0,3,0,0,0,1920,443), (444,441,20,0,0,0,0,0,0,5,0,0,0,1921,444), (445,439,21,0,0,0,0,2,2,3,0,0,0,1922,446), (446,445,28,0,0,0,0,0,0,3,0,0,0,1922,446), (447,439,27,0,0,0,0,13,3,3,0,0,0,1922,452), (448,447,15,0,0,0,0,10,5,6,0,0,0,1923,451), (449,448,18,0,0,0,0,0,0,6,0,0,0,1923,449), (450,448,19,0,0,0,0,1,1,6,0,0,0,1923,450), (451,448,20,0,0,0,0,2,2,36,0,0,0,1924,451), (452,447,34,0,0,0,0,0,0,3,0,0,0,1927,452), (453,439,98,0,0,0,0,1,1,1,0,0,0,1933,455), (454,453,36,0,0,0,0,0,0,1,0,0,0,1934,455), (455,454,37,0,0,0,0,0,0,1,0,0,0,1935,455), (456,439,29,0,0,0,0,3,0,1,0,0,0,1976,463), (457,456,30,0,0,0,0,0,0,1,0,0,0,1976,458), (458,457,31,0,0,0,0,0,0,1,0,0,0,1977,458), (459,456,32,0,0,0,0,2,1,1,0,0,0,1977,463), (460,459,35,0,0,0,0,0,0,1,0,0,0,1978,460), (461,459,39,0,0,0,0,0,0,2,0,0,0,1979,461), (462,459,58,0,0,0,0,0,0,1,0,0,0,1979,462), (463,459,59,0,0,0,0,0,0,1,0,0,0,1979,463), (464,439,60,0,0,0,0,6,1,1,0,0,0,1980,471), (465,464,61,0,0,0,0,0,0,1,0,0,0,1980,465), (466,464,62,0,0,0,0,5,4,1,0,0,0,1981,469), (467,466,65,0,0,0,0,0,0,1,0,0,0,1984,467), (468,466,67,0,0,0,0,0,0,1,0,0,0,1985,468), (469,466,69,0,0,0,0,0,0,1,0,0,0,1986,469), (470,464,70,0,0,0,0,0,0,1,0,0,0,1986,470), (471,464,71,0,0,0,0,0,0,1,0,0,0,1987,471), (472,439,99,0,0,0,0,70,13,1,0,0,0,1997,509), (473,472,91,0,0,0,0,4,2,1,0,0,0,2003,480), (474,473,92,0,0,0,0,0,0,1,0,0,0,2004,474), (475,473,35,0,0,0,0,0,0,1,0,0,0,2004,475), (476,473,93,0,0,0,0,0,0,1,0,0,0,2005,476), (477,473,95,0,0,0,0,0,0,1,0,0,0,2005,477), (478,473,96,0,0,0,0,1,0,1,0,0,0,2006,480), (479,478,36,0,0,0,0,0,0,1,0,0,0,2006,480), (480,479,37,0,0,0,0,0,0,1,0,0,0,2007,480), (481,472,21,0,0,0,0,0,0,1,0,0,0,2008,482), (482,481,28,0,0,0,0,0,0,1,0,0,0,2009,482), (483,472,27,0,0,0,0,4,1,1,0,0,0,2009,488), (484,483,15,0,0,0,0,3,2,2,0,0,0,2009,487), (485,484,18,0,0,0,0,0,0,2,0,0,0,2010,485), (486,484,19,0,0,0,0,0,0,2,0,0,0,2010,486), (487,484,20,0,0,0,0,0,0,12,0,0,0,2010,487), (488,483,34,0,0,0,0,0,0,1,0,0,0,2013,488), (489,472,101,0,0,0,0,46,18,1,0,0,0,2020,507), (490,489,102,0,0,0,0,4,3,1,0,0,0,2028,491), (491,490,8,0,0,0,0,1,0,2,0,0,0,2030,491), (492,489,103,0,0,0,0,0,0,1,0,0,0,2034,492), (493,489,104,0,0,0,0,22,4,2,0,0,0,2042,507), (494,493,9,0,0,0,0,5,2,4,0,0,0,2043,496), (495,494,10,0,0,0,0,2,2,4,0,0,0,2043,496), (496,495,12,0,0,0,0,0,0,5,0,0,0,2044,496), (497,493,14,0,0,0,0,2,2,4,0,0,0,2045,497), (498,493,80,0,0,0,0,0,0,2,0,0,0,2046,498), (499,493,81,0,0,0,0,10,1,2,0,0,0,2049,506), (500,499,82,0,0,0,0,8,3,2,0,0,0,2049,506), (501,500,22,0,0,0,0,5,1,2,0,0,0,2050,506), (502,501,15,0,0,0,0,3,1,2,0,0,0,2051,505), (503,502,18,0,0,0,0,0,0,2,0,0,0,2051,503), (504,502,19,0,0,0,0,0,0,2,0,0,0,2051,504);
INSERT INTO calls VALUES (505,502,20,0,0,0,0,0,0,5,0,0,0,2052,505), (506,501,25,0,0,0,0,0,0,2,0,0,0,2052,506), (507,493,56,0,0,0,0,0,0,2,0,0,0,2056,507), (508,472,36,0,0,0,0,0,0,1,0,0,0,2067,509), (509,508,37,0,0,0,0,0,0,1,0,0,0,2067,509), (510,439,105,0,0,0,0,0,0,1,0,0,0,2078,510), (511,439,106,0,0,0,0,2,2,1,0,0,0,2085,512), (512,511,37,0,0,0,0,0,0,1,0,0,0,2086,512), (513,340,36,0,0,0,0,0,0,1,0,0,0,2088,514), (514,513,37,0,0,0,0,0,0,1,0,0,0,2088,514), (515,2,107,1,1,0,0,135356,33850,1,0,0,0,2096,738), (516,515,5,0,0,0,0,1,0,1,0,0,0,2097,520), (517,516,15,0,0,0,0,1,0,1,0,0,0,2097,520), (518,517,18,0,0,0,0,0,0,1,0,0,0,2097,518), (519,517,19,0,0,0,0,0,0,1,0,0,0,2097,519), (520,517,20,0,0,0,0,0,0,1,0,0,0,2098,520), (521,515,21,0,0,0,0,0,0,1,0,0,0,2099,521), (522,515,27,0,0,0,0,7,4,2,0,0,0,2099,527), (523,522,37,0,0,0,0,0,0,1,0,0,0,2118,523), (524,522,15,0,0,0,0,2,1,2,0,0,0,2119,527), (525,524,18,0,0,0,0,0,0,2,0,0,0,2119,525), (526,524,19,0,0,0,0,0,0,2,0,0,0,2119,526), (527,524,20,0,0,0,0,0,0,8,0,0,0,2119,527), (528,515,108,0,0,0,0,0,0,1,0,0,0,2104,528), (529,515,110,0,0,0,0,8,4,1,0,0,0,2106,530), (530,529,111,0,0,0,0,4,4,1,0,0,0,2110,530), (531,515,91,0,0,0,0,1,1,1,0,0,0,2116,531), (532,515,112,0,999094,0,998873,118478,25706,1000000,0,0,0,2127,736), (533,532,91,0,0,0,0,19,4,1,0,0,0,2128,550), (534,533,22,0,0,0,0,10,1,2,0,0,0,2129,542), (535,534,15,0,0,0,0,8,2,2,0,0,0,2129,541), (536,535,18,0,0,0,0,0,0,2,0,0,0,2129,536), (537,535,19,0,0,0,0,0,0,2,0,0,0,2130,537), (538,535,20,0,0,0,0,0,0,12,0,0,0,2130,538), (539,535,24,0,0,0,0,4,2,2,0,0,0,2131,541), (540,539,19,0,0,0,0,0,0,2,0,0,0,2132,540), (541,539,24,0,0,0,0,1,1,10,0,0,1,2132,541), (542,534,25,0,0,0,0,0,0,2,0,0,0,2134,542), (543,533,5,0,0,0,0,3,0,1,0,0,0,2141,547), (544,543,15,0,0,0,0,2,0,1,0,0,0,2141,547), (545,544,18,0,0,0,0,0,0,1,0,0,0,2142,545), (546,544,19,0,0,0,0,1,1,1,0,0,0,2142,546), (547,544,20,0,0,0,0,0,0,2,0,0,0,2144,547), (548,533,21,0,0,0,0,0,0,1,0,0,0,2145,548), (549,533,27,0,0,0,0,0,0,1,0,0,0,2146,549), (550,533,28,0,0,0,0,0,0,1,0,0,0,2147,550), (551,532,27,0,0,0,0,6,1,1,0,0,0,2148,556), (552,551,15,0,0,0,0,4,2,2,0,0,0,2148,555), (553,552,18,0,0,0,0,0,0,2,0,0,0,2148,553), (554,552,19,0,0,0,0,0,0,2,0,0,0,2149,554), (555,552,20,0,0,0,0,1,0,12,0,0,0,2149,555), (556,551,34,0,0,0,0,0,0,1,0,0,0,2153,556), (557,532,114,0,999156,0,999094,92731,32855,1000000,0,0,0,2158,726), (558,557,91,0,0,0,0,16,3,1,0,0,0,2159,575), (559,558,22,0,0,0,0,10,1,2,0,0,0,2160,567), (560,559,15,0,0,0,0,9,2,2,0,0,0,2160,566), (561,560,18,0,0,0,0,0,0,2,0,0,0,2160,561), (562,560,19,0,0,0,0,0,0,2,0,0,0,2161,562), (563,560,20,0,0,0,0,1,0,14,0,0,0,2161,563), (564,560,24,0,0,0,0,4,2,2,0,0,0,2163,566), (565,564,19,0,0,0,0,0,0,2,0,0,0,2163,565), (566,564,24,0,0,0,0,1,1,12,0,0,1,2164,566), (567,559,25,0,0,0,0,0,0,2,0,0,0,2166,567), (568,558,5,0,0,0,0,1,0,1,0,0,0,2172,572), (569,568,15,0,0,0,0,1,0,1,0,0,0,2172,572), (570,569,18,0,0,0,0,0,0,1,0,0,0,2172,570), (571,569,19,0,0,0,0,0,0,1,0,0,0,2173,571), (572,569,20,0,0,0,0,0,0,3,0,0,0,2173,572), (573,558,21,0,0,0,0,0,0,1,0,0,0,2174,573), (574,558,27,0,0,0,0,0,0,1,0,0,0,2174,574), (575,558,28,0,0,0,0,0,0,1,0,0,0,2175,575), (576,557,29,0,0,0,0,268,1,1,0,0,0,2176,654), (577,576,5,0,0,0,0,1,0,1,0,0,0,2176,581), (578,577,15,0,0,0,0,1,0,1,0,0,0,2177,581), (579,578,18,0,0,0,0,0,0,1,0,0,0,2177,579), (580,578,19,0,0,0,0,0,0,1,0,0,0,2177,580), (581,578,20,0,0,0,0,0,0,3,0,0,0,2177,581), (582,576,21,0,0,0,0,0,0,1,0,0,0,2178,582), (583,576,27,0,0,0,0,0,0,1,0,0,0,2179,583), (584,576,30,0,0,0,0,3,1,1,0,0,0,2179,592), (585,584,5,0,0,0,0,1,0,1,0,0,0,2180,589), (586,585,15,0,0,0,0,1,0,1,0,0,0,2180,589), (587,586,18,0,0,0,0,0,0,1,0,0,0,2180,587), (588,586,19,0,0,0,0,0,0,1,0,0,0,2180,588), (589,586,20,0,0,0,0,0,0,3,0,0,0,2181,589), (590,584,21,0,0,0,0,0,0,1,0,0,0,2181,590), (591,584,27,0,0,0,0,0,0,1,0,0,0,2182,591), (592,584,31,0,0,0,0,0,0,1,0,0,0,2183,592), (593,576,32,0,0,0,0,261,209,1,0,0,0,2183,654), (594,593,5,0,0,0,0,5,1,3,0,0,0,2184,598), (595,594,15,0,0,0,0,3,1,3,0,0,0,2184,598), (596,595,18,0,0,0,0,0,0,3,0,0,0,2184,596), (597,595,19,0,0,0,0,0,0,3,0,0,0,2185,597), (598,595,20,0,0,0,0,0,0,7,0,0,0,2185,598), (599,593,21,0,0,0,0,2,2,3,0,0,0,2186,600), (600,599,28,0,0,0,0,0,0,3,0,0,0,2187,600), (601,593,27,0,0,0,0,13,3,3,0,0,0,2187,606), (602,601,15,0,0,0,0,10,5,6,0,0,0,2187,605), (603,602,18,0,0,0,0,0,0,6,0,0,0,2188,603), (604,602,19,0,0,0,0,1,1,6,0,0,0,2188,604), (605,602,20,0,0,0,0,2,2,36,0,0,0,2188,605), (606,601,34,0,0,0,0,0,0,3,0,0,0,2191,606), (607,593,35,0,0,0,0,0,0,1,0,0,0,2192,607), (608,593,38,0,0,0,0,7,3,1,0,0,0,2193,616), (609,608,9,0,0,0,0,1,0,1,0,0,0,2194,611), (610,609,10,0,0,0,0,0,0,1,0,0,0,2194,611), (611,610,12,0,0,0,0,0,0,1,0,0,0,2194,611), (612,608,14,0,0,0,0,0,0,1,0,0,0,2195,612), (613,608,15,0,0,0,0,1,0,1,0,0,0,2197,616), (614,613,18,0,0,0,0,0,0,1,0,0,0,2197,614), (615,613,19,0,0,0,0,0,0,1,0,0,0,2197,615), (616,613,20,0,0,0,0,0,0,1,0,0,0,2198,616), (617,593,115,0,0,0,0,21,1,1,0,0,0,2412,651), (618,617,40,0,0,0,0,19,1,1,0,0,0,2413,651), (619,618,41,0,0,0,0,18,4,1,0,0,0,2414,651), (620,619,42,0,0,0,0,0,0,3,0,0,0,2415,621), (621,620,43,0,0,0,0,0,0,3,0,0,0,2415,621), (622,619,44,0,0,0,0,0,0,1,0,0,0,2415,622), (623,619,45,0,0,0,0,7,0,2,0,0,0,2416,634), (624,623,46,0,0,0,0,6,2,2,0,0,0,2417,634), (625,624,47,0,0,0,0,0,0,2,0,0,0,2417,625), (626,624,48,0,0,0,0,1,0,2,0,0,0,2417,628), (627,626,49,0,0,0,0,0,0,2,0,0,0,2418,628), (628,627,50,0,0,0,0,0,0,2,0,0,0,2418,628), (629,624,9,0,0,0,0,1,0,1,0,0,0,2419,631), (630,629,10,0,0,0,0,0,0,1,0,0,0,2419,631), (631,630,12,0,0,0,0,0,0,1,0,0,0,2419,631), (632,624,14,0,0,0,0,0,0,1,0,0,0,2420,632), (633,624,81,0,0,0,0,0,0,2,0,0,0,2421,633), (634,624,44,0,0,0,0,0,0,2,0,0,0,2422,634), (635,619,52,0,0,0,0,0,0,1,0,0,0,2422,635), (636,619,53,0,0,0,0,0,0,1,0,0,0,2424,636), (637,619,54,0,0,0,0,0,0,1,0,0,0,2424,639), (638,637,46,0,0,0,0,0,0,1,0,0,0,2425,639), (639,638,47,0,0,0,0,0,0,1,0,0,0,2425,639), (640,619,55,0,0,0,0,0,0,1,0,0,0,2425,641), (641,640,50,0,0,0,0,0,0,1,0,0,0,2425,641), (642,619,56,0,0,0,0,0,0,1,0,0,0,2426,642), (643,619,26,0,0,0,0,2,1,1,0,0,0,2427,645), (644,643,10,0,0,0,0,0,0,1,0,0,0,2428,645), (645,644,12,0,0,0,0,0,0,1,0,0,0,2428,645), (646,619,14,0,0,0,0,0,0,1,0,0,0,2429,646), (647,619,57,0,0,0,0,1,0,1,0,0,0,2431,651), (648,647,49,0,0,0,0,0,0,1,0,0,0,2431,649), (649,648,50,0,0,0,0,0,0,1,0,0,0,2431,649), (650,647,55,0,0,0,0,0,0,1,0,0,0,2432,651), (651,650,50,0,0,0,0,0,0,1,0,0,0,2432,651), (652,593,39,0,0,0,0,0,0,3,0,0,0,2433,652), (653,593,58,0,0,0,0,0,0,3,0,0,0,2434,653), (654,593,59,0,0,0,0,0,0,3,0,0,0,2434,654), (655,557,60,0,0,0,0,31,2,1,0,0,0,2445,687), (656,655,5,0,0,0,0,2,0,1,0,0,0,2445,660), (657,656,15,0,0,0,0,1,0,1,0,0,0,2446,660), (658,657,18,0,0,0,0,0,0,1,0,0,0,2446,658), (659,657,19,0,0,0,0,0,0,1,0,0,0,2446,659), (660,657,20,0,0,0,0,0,0,3,0,0,0,2446,660), (661,655,21,0,0,0,0,0,0,1,0,0,0,2447,661), (662,655,27,0,0,0,0,0,0,1,0,0,0,2448,662), (663,655,61,0,0,0,0,0,0,1,0,0,0,2449,663), (664,655,62,0,0,0,0,20,12,1,0,0,0,2449,676), (665,664,65,0,0,0,0,0,0,1,0,0,0,2458,665), (666,664,22,0,0,0,0,6,1,1,0,0,0,2459,674), (667,666,15,0,0,0,0,5,1,1,0,0,0,2460,673), (668,667,18,0,0,0,0,0,0,1,0,0,0,2460,668), (669,667,19,0,0,0,0,0,0,1,0,0,0,2460,669), (670,667,20,0,0,0,0,0,0,7,0,0,0,2461,670), (671,667,24,0,0,0,0,2,1,1,0,0,0,2462,673), (672,671,19,0,0,0,0,0,0,1,0,0,0,2463,672), (673,671,24,0,0,0,0,0,0,6,0,0,1,2463,673), (674,666,25,0,0,0,0,0,0,1,0,0,0,2466,674), (675,664,67,0,0,0,0,0,0,1,0,0,0,2467,675), (676,664,69,0,0,0,0,0,0,1,0,0,0,2470,676), (677,655,70,0,0,0,0,0,0,1,0,0,0,2470,677), (678,655,71,0,0,0,0,0,0,1,0,0,0,2470,678), (679,655,22,0,0,0,0,5,0,1,0,0,0,2471,687), (680,679,15,0,0,0,0,4,1,1,0,0,0,2471,686), (681,680,18,0,0,0,0,0,0,1,0,0,0,2471,681), (682,680,19,0,0,0,0,0,0,1,0,0,0,2472,682), (683,680,20,0,0,0,0,0,0,7,0,0,0,2472,683), (684,680,24,0,0,0,0,2,1,1,0,0,0,2473,686), (685,684,19,0,0,0,0,0,0,1,0,0,0,2474,685), (686,684,24,0,0,0,0,0,0,6,0,0,1,2474,686), (687,679,25,0,0,0,0,0,0,1,0,0,0,2476,687), (688,557,27,0,0,0,0,8,1,1,0,0,0,2477,693), (689,688,15,0,0,0,0,3,2,2,0,0,0,2477,692), (690,689,18,0,0,0,0,0,0,2,0,0,0,2477,690), (691,689,19,0,0,0,0,0,0,2,0,0,0,2478,691), (692,689,20,0,0,0,0,1,0,14,0,0,0,2478,692), (693,688,34,0,0,0,0,3,3,1,0,0,0,2482,693), (694,557,117,0,999203,0,999156,59549,42530,1000000,0,0,0,2668,724), (695,694,40,0,0,0,0,19,1,1,0,0,0,2670,724), (696,695,41,0,0,0,0,17,5,1,0,0,0,2671,724), (697,696,42,0,0,0,0,1,0,3,0,0,0,2672,698), (698,697,43,0,0,0,0,0,0,3,0,0,0,2673,698), (699,696,44,0,0,0,0,0,0,1,0,0,0,2673,699), (700,696,45,0,0,0,0,4,0,2,0,0,0,2673,707), (701,700,46,0,0,0,0,3,1,2,0,0,0,2674,707), (702,701,47,0,0,0,0,0,0,2,0,0,0,2674,702), (703,701,48,0,0,0,0,1,0,2,0,0,0,2675,705), (704,703,49,0,0,0,0,0,0,2,0,0,0,2675,705), (705,704,50,0,0,0,0,0,0,2,0,0,0,2675,705), (706,701,81,0,0,0,0,0,0,2,0,0,0,2676,706), (707,701,44,0,0,0,0,0,0,2,0,0,0,2676,707), (708,696,52,0,0,0,0,0,0,1,0,0,0,2677,708), (709,696,53,0,0,0,0,0,0,1,0,0,0,2679,709), (710,696,54,0,0,0,0,0,0,1,0,0,0,2679,712), (711,710,46,0,0,0,0,0,0,1,0,0,0,2679,712), (712,711,47,0,0,0,0,0,0,1,0,0,0,2679,712), (713,696,55,0,0,0,0,0,0,1,0,0,0,2680,714), (714,713,50,0,0,0,0,0,0,1,0,0,0,2680,714), (715,696,56,0,0,0,0,0,0,1,0,0,0,2681,715), (716,696,26,0,0,0,0,3,2,1,0,0,0,2681,718), (717,716,10,0,0,0,0,1,1,1,0,0,0,2683,718), (718,717,12,0,0,0,0,0,0,1,0,0,0,2683,718), (719,696,14,0,0,0,0,1,1,1,0,0,0,2685,719), (720,696,57,0,0,0,0,1,0,1,0,0,0,2688,724), (721,720,49,0,0,0,0,0,0,1,0,0,0,2688,722), (722,721,50,0,0,0,0,0,0,1,0,0,0,2688,722), (723,720,55,0,0,0,0,0,0,1,0,0,0,2688,724), (724,723,50,0,0,0,0,0,0,1,0,0,0,2688,724), (725,557,36,0,0,0,0,1,0,1,0,0,0,2690,726), (726,725,37,0,0,0,0,0,0,1,0,0,0,2690,726), (727,532,106,0,0,0,0,13,5,1,0,0,0,2691,736), (728,727,37,0,0,0,0,0,0,1,0,0,0,2692,728), (729,727,9,0,0,0,0,3,2,2,0,0,0,2692,731), (730,729,10,0,0,0,0,1,1,2,0,0,0,2693,731), (731,730,12,0,0,0,0,0,0,2,0,0,0,2693,731), (732,727,14,0,0,0,0,1,1,2,0,0,0,2694,732), (733,727,15,0,0,0,0,4,2,2,0,0,0,2696,736), (734,733,18,0,0,0,0,0,0,2,0,0,0,2697,734), (735,733,19,0,0,0,0,1,1,2,0,0,0,2697,735), (736,733,20,0,0,0,0,0,0,5,0,0,0,2698,736), (737,515,106,0,0,0,0,6,5,1,0,0,0,168529,738), (738,737,37,0,0,0,0,1,0,1,0,0,0,168533,738), (739,0,13,0,0,0,0,2,2,1,0,0,0,168539,739), (740,0,9,0,0,0,0,7,3,1,0,0,0,168550,742), (741,740,10,0,0,0,0,3,3,1,0,0,0,168551,742), (742,741,12,0,0,0,0,0,0,1,0,0,0,168553,742), (743,0,14,0,0,0,0,2,2,1,0,0,0,168557,743), (744,0,118,0,0,0,0,0,0,1,0,0,0,168566,744), (745,0,119,0,0,0,0,1620,12,1,0,0,0,168574,1230), (746,745,91,0,0,0,0,2,2,1,0,0,0,168575,746), (747,745,27,0,0,0,0,13,4,1,0,0,0,168578,752), (748,747,37,0,0,0,0,0,0,1,0,0,0,168579,748), (749,747,15,0,0,0,0,8,4,2,0,0,0,168580,752), (750,749,18,0,0,0,0,1,1,2,0,0,0,168581,750), (751,749,19,0,0,0,0,1,1,2,0,0,0,168583,751), (752,749,20,0,0,0,0,1,1,8,0,0,0,168585,752), (753,745,120,0,0,0,0,1591,4,1,0,0,0,168603,1230), (754,753,121,0,0,0,0,1587,14,1,0,0,0,168607,1230), (755,754,5,0,0,0,0,6,3,2,0,0,0,168611,759), (756,755,15,0,0,0,0,2,1,2,0,0,0,168613,759), (757,756,18,0,0,0,0,0,0,2,0,0,0,168613,757);
INSERT INTO calls VALUES (758,756,19,0,0,0,0,0,0,2,0,0,0,168614,758), (759,756,20,0,0,0,0,0,0,2,0,0,0,168614,759), (760,754,21,0,0,0,0,5,4,2,0,0,0,168616,761), (761,760,28,0,0,0,0,0,0,1,0,0,0,168629,761), (762,754,27,0,0,0,0,9,3,2,0,0,0,168618,767), (763,762,15,0,0,0,0,4,2,2,0,0,0,168655,766), (764,763,18,0,0,0,0,0,0,2,0,0,0,168655,764), (765,763,19,0,0,0,0,0,0,2,0,0,0,168656,765), (766,763,20,0,0,0,0,1,0,12,0,0,0,168656,766), (767,762,34,0,0,0,0,1,1,1,0,0,0,168661,767), (768,754,108,0,0,0,0,0,0,1,0,0,0,168620,768), (769,754,110,0,0,0,0,2,0,1,0,0,0,168621,770), (770,769,111,0,0,0,0,1,1,1,0,0,0,168621,770), (771,754,29,0,0,0,0,10,1,1,0,0,0,168630,778), (772,771,30,0,0,0,0,0,0,1,0,0,0,168631,773), (773,772,31,0,0,0,0,0,0,1,0,0,0,168631,773), (774,771,32,0,0,0,0,8,5,1,0,0,0,168632,778), (775,774,35,0,0,0,0,0,0,1,0,0,0,168634,775), (776,774,39,0,0,0,0,0,0,2,0,0,0,168637,776), (777,774,58,0,0,0,0,0,0,1,0,0,0,168638,777), (778,774,59,0,0,0,0,0,0,1,0,0,0,168639,778), (779,754,60,0,0,0,0,12,3,1,0,0,0,168641,786), (780,779,61,0,0,0,0,0,0,1,0,0,0,168642,780), (781,779,62,0,0,0,0,9,7,1,0,0,0,168643,784), (782,781,65,0,0,0,0,0,0,1,0,0,0,168647,782), (783,781,67,0,0,0,0,0,0,1,0,0,0,168649,783), (784,781,69,0,0,0,0,0,0,1,0,0,0,168652,784), (785,779,70,0,0,0,0,0,0,1,0,0,0,168653,785), (786,779,71,0,0,0,0,0,0,1,0,0,0,168653,786), (787,754,122,0,0,0,0,1525,5,1,0,0,0,168669,1230), (788,787,91,0,0,0,0,0,0,1,0,0,0,168671,788), (789,787,27,0,0,0,0,4,1,1,0,0,0,168672,794), (790,789,37,0,0,0,0,0,0,1,0,0,0,168672,790), (791,789,15,0,0,0,0,2,1,2,0,0,0,168673,794), (792,791,18,0,0,0,0,0,0,2,0,0,0,168673,792), (793,791,19,0,0,0,0,0,0,2,0,0,0,168673,793), (794,791,20,0,0,0,0,0,0,8,0,0,0,168674,794), (795,787,123,0,0,0,0,1515,12,1,0,0,0,168680,1230), (796,795,124,0,0,0,0,1502,4,1,0,0,0,168692,1230), (797,796,125,0,0,0,0,1498,10,2,0,0,0,168696,1230), (798,797,5,0,0,0,0,2,0,1,0,0,0,168697,802), (799,798,15,0,0,0,0,1,0,1,0,0,0,168698,802), (800,799,18,0,0,0,0,0,0,1,0,0,0,168698,800), (801,799,19,0,0,0,0,0,0,1,0,0,0,168698,801), (802,799,20,0,0,0,0,0,0,1,0,0,0,168699,802), (803,797,21,0,0,0,0,0,0,1,0,0,0,168699,803), (804,797,27,0,0,0,0,4,1,2,0,0,0,168700,809), (805,804,37,0,0,0,0,0,0,1,0,0,0,168704,805), (806,804,15,0,0,0,0,2,1,2,0,0,0,168705,809), (807,806,18,0,0,0,0,0,0,2,0,0,0,168705,807), (808,806,19,0,0,0,0,0,0,2,0,0,0,168705,808), (809,806,20,0,0,0,0,0,0,8,0,0,0,168706,809), (810,797,108,0,0,0,0,0,0,2,0,0,0,168701,810), (811,797,110,0,0,0,0,1,0,1,0,0,0,168702,812), (812,811,111,0,0,0,0,0,0,1,0,0,0,168702,812), (813,797,91,0,0,0,0,0,0,1,0,0,0,168704,813), (814,797,126,0,0,0,0,1478,21,2,0,0,0,168715,1228), (815,814,5,0,0,0,0,1,0,1,0,0,0,168715,819), (816,815,15,0,0,0,0,1,0,1,0,0,0,168716,819), (817,816,18,0,0,0,0,0,0,1,0,0,0,168716,817), (818,816,19,0,0,0,0,0,0,1,0,0,0,168716,818), (819,816,20,0,0,0,0,0,0,1,0,0,0,168717,819), (820,814,21,0,0,0,0,0,0,1,0,0,0,168717,820), (821,814,27,0,0,0,0,6,2,2,0,0,0,168718,826), (822,821,37,0,0,0,0,0,0,1,0,0,0,168728,822), (823,821,15,0,0,0,0,3,1,2,0,0,0,168729,826), (824,823,18,0,0,0,0,0,0,2,0,0,0,168729,824), (825,823,19,0,0,0,0,0,0,2,0,0,0,168730,825), (826,823,20,0,0,0,0,0,0,8,0,0,0,168730,826), (827,814,108,0,0,0,0,0,0,2,0,0,0,168719,827), (828,814,110,0,0,0,0,0,0,1,0,0,0,168719,829), (829,828,111,0,0,0,0,0,0,1,0,0,0,168719,829), (830,814,91,0,0,0,0,0,0,1,0,0,0,168727,830), (831,814,127,0,0,0,0,1383,17,1,0,0,0,168741,1220), (832,831,91,0,0,0,0,38,6,2,0,0,0,168743,849), (833,832,22,0,0,0,0,25,3,4,0,0,0,168744,841), (834,833,15,0,0,0,0,20,6,4,0,0,0,168745,840), (835,834,18,0,0,0,0,0,0,4,0,0,0,168746,835), (836,834,19,0,0,0,0,1,1,4,0,0,0,168746,836), (837,834,20,0,0,0,0,2,1,28,0,0,0,168747,837), (838,834,24,0,0,0,0,9,6,4,0,0,0,168749,840), (839,838,19,0,0,0,0,0,0,4,0,0,0,168750,839), (840,838,24,0,0,0,0,3,2,24,0,0,1,168750,840), (841,833,25,0,0,0,0,1,1,4,0,0,0,168753,841), (842,832,5,0,0,0,0,4,1,2,0,0,0,168761,846), (843,842,15,0,0,0,0,2,1,2,0,0,0,168761,846), (844,843,18,0,0,0,0,0,0,2,0,0,0,168762,844), (845,843,19,0,0,0,0,0,0,2,0,0,0,168762,845), (846,843,20,0,0,0,0,0,0,6,0,0,0,168762,846), (847,832,21,0,0,0,0,1,1,2,0,0,0,168764,847), (848,832,27,0,0,0,0,0,0,2,0,0,0,168764,848), (849,832,28,0,0,0,0,0,0,2,0,0,0,168765,849), (850,831,27,0,0,0,0,10,2,2,0,0,0,168766,855), (851,850,15,0,0,0,0,6,3,4,0,0,0,168766,854), (852,851,18,0,0,0,0,0,0,4,0,0,0,168766,852), (853,851,19,0,0,0,0,0,0,4,0,0,0,168767,853), (854,851,20,0,0,0,0,2,1,28,0,0,0,168767,854), (855,850,34,0,0,0,0,0,0,2,0,0,0,168771,855), (856,831,128,0,0,0,0,3,3,1,0,0,0,168779,856), (857,831,29,0,0,0,0,22,1,1,0,0,0,168800,892), (858,857,5,0,0,0,0,1,0,1,0,0,0,168800,862), (859,858,15,0,0,0,0,1,0,1,0,0,0,168800,862), (860,859,18,0,0,0,0,0,0,1,0,0,0,168800,860), (861,859,19,0,0,0,0,0,0,1,0,0,0,168801,861), (862,859,20,0,0,0,0,0,0,3,0,0,0,168801,862), (863,857,21,0,0,0,0,0,0,1,0,0,0,168802,863), (864,857,27,0,0,0,0,0,0,1,0,0,0,168802,864), (865,857,30,0,0,0,0,3,1,1,0,0,0,168803,873), (866,865,5,0,0,0,0,1,0,1,0,0,0,168803,870), (867,866,15,0,0,0,0,1,0,1,0,0,0,168804,870), (868,867,18,0,0,0,0,0,0,1,0,0,0,168804,868), (869,867,19,0,0,0,0,0,0,1,0,0,0,168804,869), (870,867,20,0,0,0,0,0,0,3,0,0,0,168804,870), (871,865,21,0,0,0,0,0,0,1,0,0,0,168805,871), (872,865,27,0,0,0,0,0,0,1,0,0,0,168806,872), (873,865,31,0,0,0,0,0,0,1,0,0,0,168807,873), (874,857,32,0,0,0,0,14,4,1,0,0,0,168807,892), (875,874,5,0,0,0,0,2,0,1,0,0,0,168808,879), (876,875,15,0,0,0,0,2,1,1,0,0,0,168808,879), (877,876,18,0,0,0,0,0,0,1,0,0,0,168808,877), (878,876,19,0,0,0,0,0,0,1,0,0,0,168808,878), (879,876,20,0,0,0,0,0,0,5,0,0,0,168809,879), (880,874,21,0,0,0,0,1,0,1,0,0,0,168811,881), (881,880,28,0,0,0,0,0,0,1,0,0,0,168811,881), (882,874,27,0,0,0,0,4,1,1,0,0,0,168812,887), (883,882,15,0,0,0,0,3,1,2,0,0,0,168812,886), (884,883,18,0,0,0,0,0,0,2,0,0,0,168812,884), (885,883,19,0,0,0,0,0,0,2,0,0,0,168813,885), (886,883,20,0,0,0,0,0,0,12,0,0,0,168813,886), (887,882,34,0,0,0,0,0,0,1,0,0,0,168816,887), (888,874,35,0,0,0,0,0,0,1,0,0,0,168817,888), (889,874,115,0,0,0,0,0,0,1,0,0,0,168817,889), (890,874,39,0,0,0,0,0,0,4,0,0,0,168819,890), (891,874,58,0,0,0,0,0,0,4,0,0,0,168819,891), (892,874,59,0,0,0,0,0,0,4,0,0,0,168820,892), (893,831,60,0,0,0,0,60,2,1,0,0,0,168822,939), (894,893,5,0,0,0,0,1,0,1,0,0,0,168823,898), (895,894,15,0,0,0,0,1,0,1,0,0,0,168823,898), (896,895,18,0,0,0,0,0,0,1,0,0,0,168823,896), (897,895,19,0,0,0,0,0,0,1,0,0,0,168823,897), (898,895,20,0,0,0,0,0,0,3,0,0,0,168824,898), (899,893,21,0,0,0,0,0,0,1,0,0,0,168825,899), (900,893,27,0,0,0,0,0,0,1,0,0,0,168825,900), (901,893,61,0,0,0,0,0,0,1,0,0,0,168826,901), (902,893,62,0,0,0,0,49,30,1,0,0,0,168826,928), (903,902,65,0,0,0,0,4,4,18,0,0,0,168846,903), (904,902,22,0,0,0,0,7,1,2,0,0,0,168854,912), (905,904,15,0,0,0,0,5,2,2,0,0,0,168855,911), (906,905,18,0,0,0,0,0,0,2,0,0,0,168855,906), (907,905,19,0,0,0,0,0,0,2,0,0,0,168855,907), (908,905,20,0,0,0,0,0,0,7,0,0,0,168856,908), (909,905,24,0,0,0,0,2,1,1,0,0,0,168871,911), (910,909,19,0,0,0,0,0,0,1,0,0,0,168872,910), (911,909,24,0,0,0,0,0,0,5,0,0,1,168872,911), (912,904,25,0,0,0,0,0,0,2,0,0,0,168856,912), (913,902,5,0,0,0,0,1,0,1,0,0,0,168857,917), (914,913,15,0,0,0,0,0,0,1,0,0,0,168857,917), (915,914,18,0,0,0,0,0,0,1,0,0,0,168857,915), (916,914,19,0,0,0,0,0,0,1,0,0,0,168858,916), (917,914,20,0,0,0,0,0,0,1,0,0,0,168858,917), (918,902,21,0,0,0,0,0,0,1,0,0,0,168858,919), (919,918,28,0,0,0,0,0,0,1,0,0,0,168859,919), (920,902,27,0,0,0,0,4,1,1,0,0,0,168859,925), (921,920,15,0,0,0,0,3,1,2,0,0,0,168860,924), (922,921,18,0,0,0,0,0,0,2,0,0,0,168860,922), (923,921,19,0,0,0,0,0,0,2,0,0,0,168860,923), (924,921,20,0,0,0,0,1,0,12,0,0,0,168860,924), (925,920,34,0,0,0,0,0,0,1,0,0,0,168863,925), (926,902,131,0,0,0,0,0,0,1,0,0,0,168867,926), (927,902,67,0,0,0,0,0,0,1,0,0,0,168875,927), (928,902,69,0,0,0,0,0,0,1,0,0,0,168876,928), (929,893,70,0,0,0,0,0,0,1,0,0,0,168876,929), (930,893,71,0,0,0,0,0,0,1,0,0,0,168877,930), (931,893,22,0,0,0,0,4,0,1,0,0,0,168877,939), (932,931,15,0,0,0,0,4,1,1,0,0,0,168877,938), (933,932,18,0,0,0,0,0,0,1,0,0,0,168878,933), (934,932,19,0,0,0,0,0,0,1,0,0,0,168878,934), (935,932,20,0,0,0,0,0,0,7,0,0,0,168878,935), (936,932,24,0,0,0,0,2,1,1,0,0,0,168879,938), (937,936,19,0,0,0,0,0,0,1,0,0,0,168880,937), (938,936,24,0,0,0,0,0,0,6,0,0,1,168880,938), (939,931,25,0,0,0,0,0,0,1,0,0,0,168882,939), (940,831,132,0,0,0,0,950,837,1,0,0,0,168890,1011), (941,940,5,0,0,0,0,18,1,1,0,0,0,168891,956), (942,941,9,0,0,0,0,2,1,1,0,0,0,168892,944), (943,942,10,0,0,0,0,1,1,1,0,0,0,168892,944), (944,943,12,0,0,0,0,0,0,2,0,0,0,168893,944), (945,941,14,0,0,0,0,1,1,1,0,0,0,168895,945), (946,941,15,0,0,0,0,13,4,1,0,0,0,168896,956), (947,946,17,0,1,0,0,2,1,1,0,0,0,168897,949), (948,947,10,0,0,0,0,1,0,1,0,0,0,168898,949), (949,948,12,0,0,0,0,0,0,2,0,0,0,168898,949), (950,946,9,0,0,0,0,4,1,3,0,0,0,168900,952), (951,950,10,0,0,0,0,2,2,3,0,0,0,168900,952), (952,951,12,0,0,0,0,0,0,6,0,0,0,168900,952), (953,946,14,0,0,0,0,1,1,3,0,0,0,168901,953), (954,946,18,0,0,0,0,0,0,1,0,0,0,168902,954), (955,946,19,0,0,0,0,0,0,1,0,0,0,168906,955), (956,946,20,0,0,0,0,0,0,1,0,0,0,168909,956), (957,940,21,0,0,0,0,1,0,1,0,0,0,168910,958), (958,957,28,0,0,0,0,0,0,1,0,0,0,168911,958), (959,940,29,0,0,0,0,3,0,1,0,0,0,168911,966), (960,959,30,0,0,0,0,0,0,1,0,0,0,168912,961), (961,960,31,0,0,0,0,0,0,1,0,0,0,168912,961), (962,959,32,0,0,0,0,2,1,1,0,0,0,168912,966), (963,962,35,0,0,0,0,0,0,1,0,0,0,168913,963), (964,962,39,0,0,0,0,0,0,2,0,0,0,168914,964), (965,962,58,0,0,0,0,0,0,1,0,0,0,168914,965), (966,962,59,0,0,0,0,0,0,1,0,0,0,168914,966), (967,940,60,0,0,0,0,5,1,1,0,0,0,168915,974), (968,967,61,0,0,0,0,0,0,1,0,0,0,168915,968), (969,967,62,0,0,0,0,4,3,1,0,0,0,168916,972), (970,969,65,0,0,0,0,0,0,1,0,0,0,168918,970), (971,969,67,0,0,0,0,0,0,1,0,0,0,168919,971), (972,969,69,0,0,0,0,0,0,1,0,0,0,168920,972), (973,967,70,0,0,0,0,0,0,1,0,0,0,168920,973), (974,967,71,0,0,0,0,0,0,1,0,0,0,168921,974), (975,940,27,0,0,0,0,5,1,1,0,0,0,168921,980), (976,975,15,0,0,0,0,4,2,2,0,0,0,168922,979), (977,976,18,0,0,0,0,0,0,2,0,0,0,168922,977), (978,976,19,0,0,0,0,0,0,2,0,0,0,168922,978), (979,976,20,0,0,0,0,1,0,12,0,0,0,168923,979), (980,975,34,0,0,0,0,0,0,1,0,0,0,168926,980), (981,940,133,0,0,0,0,77,15,1,0,0,0,169763,1011), (982,981,91,0,0,0,0,27,11,1,0,0,0,169773,989), (983,982,92,0,0,0,0,0,0,1,0,0,0,169776,983), (984,982,35,0,0,0,0,1,1,1,0,0,0,169781,984), (985,982,93,0,0,0,0,0,0,1,0,0,0,169784,985), (986,982,95,0,0,0,0,1,1,1,0,0,0,169786,986), (987,982,96,0,0,0,0,11,2,1,0,0,0,169788,989), (988,987,36,0,0,0,0,9,9,1,0,0,0,169790,989), (989,988,37,0,0,0,0,0,0,1,0,0,0,169799,989), (990,981,21,0,0,0,0,1,1,1,0,0,0,169801,991), (991,990,28,0,0,0,0,0,0,1,0,0,0,169802,991), (992,981,27,0,0,0,0,6,1,1,0,0,0,169802,997), (993,992,15,0,0,0,0,4,2,2,0,0,0,169803,996), (994,993,18,0,0,0,0,0,0,2,0,0,0,169803,994), (995,993,19,0,0,0,0,0,0,2,0,0,0,169804,995), (996,993,20,0,0,0,0,0,0,12,0,0,0,169805,996), (997,992,34,0,0,0,0,0,0,1,0,0,0,169808,997), (998,981,134,0,0,0,0,26,8,1,0,0,0,169814,1011), (999,998,9,0,0,0,0,4,2,2,0,0,0,169815,1001), (1000,999,10,0,0,0,0,2,1,2,0,0,0,169815,1001), (1001,1000,12,0,0,0,0,0,0,2,0,0,0,169816,1001), (1002,998,14,0,0,0,0,1,1,2,0,0,0,169818,1002), (1003,998,135,0,0,0,0,0,0,1,0,0,0,169823,1003), (1004,998,102,0,0,0,0,2,2,1,0,0,0,169824,1004), (1005,998,137,0,0,0,0,8,4,1,0,0,0,169831,1011), (1006,1005,9,0,0,0,0,2,1,2,0,0,0,169831,1008), (1007,1006,10,0,0,0,0,1,1,2,0,0,0,169831,1008), (1008,1007,12,0,0,0,0,0,0,3,0,0,0,169832,1008);
INSERT INTO calls VALUES (1009,1005,14,0,0,0,0,0,0,2,0,0,0,169832,1009), (1010,1005,138,0,0,0,0,0,0,1,0,0,0,169836,1010), (1011,1005,139,0,0,0,0,0,0,1,0,0,0,169840,1011), (1012,831,140,0,0,0,0,280,23,1,0,0,0,169845,1220), (1013,1012,5,0,0,0,0,3,1,1,0,0,0,169846,1017), (1014,1013,15,0,0,0,0,2,1,1,0,0,0,169846,1017), (1015,1014,18,0,0,0,0,0,0,1,0,0,0,169847,1015), (1016,1014,19,0,0,0,0,0,0,1,0,0,0,169847,1016), (1017,1014,20,0,0,0,0,0,0,1,0,0,0,169848,1017), (1018,1012,21,0,0,0,0,1,1,1,0,0,0,169849,1019), (1019,1018,28,0,0,0,0,0,0,1,0,0,0,169850,1019), (1020,1012,29,0,0,0,0,4,0,1,0,0,0,169850,1027), (1021,1020,30,0,0,0,0,0,0,1,0,0,0,169851,1022), (1022,1021,31,0,0,0,0,0,0,1,0,0,0,169851,1022), (1023,1020,32,0,0,0,0,3,2,1,0,0,0,169851,1027), (1024,1023,35,0,0,0,0,0,0,1,0,0,0,169852,1024), (1025,1023,39,0,0,0,0,0,0,2,0,0,0,169853,1025), (1026,1023,58,0,0,0,0,0,0,1,0,0,0,169854,1026), (1027,1023,59,0,0,0,0,0,0,1,0,0,0,169854,1027), (1028,1012,60,0,0,0,0,148,1,1,0,0,0,169855,1099), (1029,1028,61,0,0,0,0,142,14,1,0,0,0,169855,1093), (1030,1029,5,0,0,0,0,2,0,1,0,0,0,169856,1034), (1031,1030,15,0,0,0,0,1,0,1,0,0,0,169856,1034), (1032,1031,18,0,0,0,0,0,0,1,0,0,0,169856,1032), (1033,1031,19,0,0,0,0,0,0,1,0,0,0,169856,1033), (1034,1031,20,0,0,0,0,0,0,2,0,0,0,169857,1034), (1035,1029,21,0,0,0,0,0,0,1,0,0,0,169858,1035), (1036,1029,27,0,0,0,0,0,0,1,0,0,0,169858,1036), (1037,1029,141,0,0,0,0,124,32,1,0,0,0,169872,1093), (1038,1037,5,0,0,0,0,1,0,1,0,0,0,169873,1042), (1039,1038,15,0,0,0,0,1,0,1,0,0,0,169874,1042), (1040,1039,18,0,0,0,0,0,0,1,0,0,0,169874,1040), (1041,1039,19,0,0,0,0,0,0,1,0,0,0,169874,1041), (1042,1039,20,0,0,0,0,0,0,2,0,0,0,169874,1042), (1043,1037,21,0,0,0,0,0,0,1,0,0,0,169875,1043), (1044,1037,27,0,0,0,0,0,0,1,0,0,0,169876,1044), (1045,1037,142,0,0,0,0,68,28,2,0,0,0,169879,1083), (1046,1045,5,0,0,0,0,1,0,1,0,0,0,169879,1050), (1047,1046,15,0,0,0,0,1,0,1,0,0,0,169879,1050), (1048,1047,18,0,0,0,0,0,0,1,0,0,0,169880,1048), (1049,1047,19,0,0,0,0,0,0,1,0,0,0,169880,1049), (1050,1047,20,0,0,0,0,0,0,2,0,0,0,169880,1050), (1051,1045,21,0,0,0,0,0,0,1,0,0,0,169881,1051), (1052,1045,27,0,0,0,0,0,0,1,0,0,0,169881,1052), (1053,1045,143,0,0,0,0,37,14,2,0,0,0,169909,1083), (1054,1053,9,0,0,0,0,3,1,2,0,0,0,169912,1056), (1055,1054,10,0,0,0,0,2,2,2,0,0,0,169912,1056), (1056,1055,12,0,0,0,0,0,0,2,0,0,0,169912,1056), (1057,1053,14,0,0,0,0,1,1,2,0,0,0,169913,1057), (1058,1053,81,0,0,0,0,8,1,2,0,0,0,169915,1065), (1059,1058,82,0,0,0,0,7,4,1,0,0,0,169916,1065), (1060,1059,22,0,0,0,0,3,0,1,0,0,0,169917,1065), (1061,1060,15,0,0,0,0,1,1,1,0,0,0,169918,1064), (1062,1061,18,0,0,0,0,0,0,1,0,0,0,169918,1062), (1063,1061,19,0,0,0,0,0,0,1,0,0,0,169918,1063), (1064,1061,20,0,0,0,0,0,0,3,0,0,0,169919,1064), (1065,1060,25,0,0,0,0,0,0,1,0,0,0,169920,1065), (1066,1053,56,0,0,0,0,0,0,2,0,0,0,169926,1066), (1067,1053,5,0,0,0,0,4,1,2,0,0,0,169928,1071), (1068,1067,15,0,0,0,0,3,1,2,0,0,0,169928,1071), (1069,1068,18,0,0,0,0,0,0,2,0,0,0,169928,1069), (1070,1068,19,0,0,0,0,0,0,2,0,0,0,169929,1070), (1071,1068,20,0,0,0,0,0,0,3,0,0,0,169930,1071), (1072,1053,21,0,0,0,0,0,0,2,0,0,0,169931,1072), (1073,1053,27,0,0,0,0,0,0,2,0,0,0,169931,1073), (1074,1053,144,0,0,0,0,0,0,2,0,0,0,169934,1074), (1075,1053,145,0,0,0,0,3,1,2,0,0,0,169940,1083), (1076,1075,5,0,0,0,0,1,0,1,0,0,0,169940,1080), (1077,1076,15,0,0,0,0,1,0,1,0,0,0,169940,1080), (1078,1077,18,0,0,0,0,0,0,1,0,0,0,169941,1078), (1079,1077,19,0,0,0,0,0,0,1,0,0,0,169941,1079), (1080,1077,20,0,0,0,0,0,0,2,0,0,0,169941,1080), (1081,1075,21,0,0,0,0,0,0,1,0,0,0,169942,1081), (1082,1075,27,0,0,0,0,0,0,1,0,0,0,169942,1082), (1083,1075,31,0,0,0,0,0,0,2,0,0,0,169943,1083), (1084,1037,9,0,0,0,0,10,2,5,0,0,0,169945,1086), (1085,1084,10,0,0,0,0,7,7,5,0,0,0,169945,1086), (1086,1085,12,0,0,0,0,0,0,5,0,0,0,169951,1086), (1087,1037,14,0,0,0,0,2,2,5,0,0,0,169951,1087), (1088,1037,146,0,0,0,0,0,0,2,0,0,0,169954,1088), (1089,1037,148,0,0,0,0,0,0,4,0,0,0,169961,1089), (1090,1037,149,0,0,0,0,7,5,2,0,0,0,169978,1091), (1091,1090,8,0,0,0,0,2,2,4,0,0,0,169979,1091), (1092,1037,150,0,0,0,0,0,0,2,0,0,0,169991,1092), (1093,1037,151,0,0,0,0,0,0,2,0,0,0,169997,1093), (1094,1028,62,0,0,0,0,5,4,1,0,0,0,169998,1097), (1095,1094,65,0,0,0,0,0,0,1,0,0,0,170000,1095), (1096,1094,67,0,0,0,0,0,0,1,0,0,0,170002,1096), (1097,1094,69,0,0,0,0,0,0,1,0,0,0,170003,1097), (1098,1028,70,0,0,0,0,0,0,1,0,0,0,170003,1098), (1099,1028,71,0,0,0,0,0,0,1,0,0,0,170003,1099), (1100,1012,27,0,0,0,0,5,1,1,0,0,0,170004,1105), (1101,1100,15,0,0,0,0,3,2,2,0,0,0,170004,1104), (1102,1101,18,0,0,0,0,0,0,2,0,0,0,170005,1102), (1103,1101,19,0,0,0,0,0,0,2,0,0,0,170005,1103), (1104,1101,20,0,0,0,0,0,0,12,0,0,0,170005,1104), (1105,1100,34,0,0,0,0,0,0,1,0,0,0,170009,1105), (1106,1012,152,0,0,0,0,94,9,1,0,0,0,170030,1220), (1107,1106,91,0,0,0,0,6,3,2,0,0,0,170032,1115), (1108,1107,92,0,0,0,0,0,0,1,0,0,0,170032,1108), (1109,1107,35,0,0,0,0,0,0,1,0,0,0,170033,1109), (1110,1107,93,0,0,0,0,0,0,1,0,0,0,170033,1110), (1111,1107,95,0,0,0,0,0,0,1,0,0,0,170034,1111), (1112,1107,96,0,0,0,0,1,0,1,0,0,0,170035,1114), (1113,1112,36,0,0,0,0,0,0,1,0,0,0,170035,1114), (1114,1113,37,0,0,0,0,0,0,1,0,0,0,170036,1114), (1115,1107,28,0,0,0,0,0,0,1,0,0,0,170076,1115), (1116,1106,21,0,0,0,0,1,0,1,0,0,0,170037,1117), (1117,1116,28,0,0,0,0,0,0,1,0,0,0,170037,1117), (1118,1106,29,0,0,0,0,23,2,2,0,0,0,170038,1153), (1119,1118,30,0,0,0,0,3,1,2,0,0,0,170038,1127), (1120,1119,31,0,0,0,0,0,0,2,0,0,0,170038,1120), (1121,1119,5,0,0,0,0,1,0,1,0,0,0,170081,1125), (1122,1121,15,0,0,0,0,1,0,1,0,0,0,170081,1125), (1123,1122,18,0,0,0,0,0,0,1,0,0,0,170081,1123), (1124,1122,19,0,0,0,0,0,0,1,0,0,0,170082,1124), (1125,1122,20,0,0,0,0,0,0,2,0,0,0,170082,1125), (1126,1119,21,0,0,0,0,0,0,1,0,0,0,170083,1126), (1127,1119,27,0,0,0,0,0,0,1,0,0,0,170083,1127), (1128,1118,32,0,0,0,0,13,4,2,0,0,0,170038,1146), (1129,1128,35,0,0,0,0,0,0,2,0,0,0,170039,1129), (1130,1128,115,0,0,0,0,0,0,1,0,0,0,170039,1130), (1131,1128,39,0,0,0,0,0,0,3,0,0,0,170040,1131), (1132,1128,58,0,0,0,0,0,0,2,0,0,0,170041,1132), (1133,1128,59,0,0,0,0,0,0,2,0,0,0,170041,1133), (1134,1128,5,0,0,0,0,2,0,1,0,0,0,170085,1138), (1135,1134,15,0,0,0,0,1,0,1,0,0,0,170085,1138), (1136,1135,18,0,0,0,0,0,0,1,0,0,0,170086,1136), (1137,1135,19,0,0,0,0,0,0,1,0,0,0,170086,1137), (1138,1135,20,0,0,0,0,0,0,4,0,0,0,170086,1138), (1139,1128,21,0,0,0,0,0,0,1,0,0,0,170087,1140), (1140,1139,28,0,0,0,0,0,0,1,0,0,0,170088,1140), (1141,1128,27,0,0,0,0,4,1,1,0,0,0,170088,1146), (1142,1141,15,0,0,0,0,3,1,2,0,0,0,170088,1145), (1143,1142,18,0,0,0,0,0,0,2,0,0,0,170088,1143), (1144,1142,19,0,0,0,0,0,0,2,0,0,0,170089,1144), (1145,1142,20,0,0,0,0,0,0,12,0,0,0,170089,1145), (1146,1141,34,0,0,0,0,0,0,1,0,0,0,170092,1146), (1147,1118,5,0,0,0,0,2,0,1,0,0,0,170076,1151), (1148,1147,15,0,0,0,0,1,0,1,0,0,0,170077,1151), (1149,1148,18,0,0,0,0,0,0,1,0,0,0,170077,1149), (1150,1148,19,0,0,0,0,0,0,1,0,0,0,170077,1150), (1151,1148,20,0,0,0,0,0,0,2,0,0,0,170078,1151), (1152,1118,21,0,0,0,0,0,0,1,0,0,0,170079,1152), (1153,1118,27,0,0,0,0,0,0,1,0,0,0,170080,1153), (1154,1106,60,0,0,0,0,26,3,2,0,0,0,170042,1186), (1155,1154,61,0,0,0,0,0,0,2,0,0,0,170043,1155), (1156,1154,62,0,0,0,0,14,7,2,0,0,0,170043,1168), (1157,1156,65,0,0,0,0,0,0,2,0,0,0,170045,1157), (1158,1156,67,0,0,0,0,0,0,2,0,0,0,170046,1158), (1159,1156,69,0,0,0,0,0,0,2,0,0,0,170047,1159), (1160,1156,22,0,0,0,0,6,1,1,0,0,0,170101,1168), (1161,1160,15,0,0,0,0,5,1,1,0,0,0,170102,1167), (1162,1161,18,0,0,0,0,0,0,1,0,0,0,170102,1162), (1163,1161,19,0,0,0,0,0,0,1,0,0,0,170102,1163), (1164,1161,20,0,0,0,0,0,0,7,0,0,0,170103,1164), (1165,1161,24,0,0,0,0,3,2,1,0,0,0,170104,1167), (1166,1165,19,0,0,0,0,0,0,1,0,0,0,170105,1166), (1167,1165,24,0,0,0,0,0,0,6,0,0,1,170106,1167), (1168,1160,25,0,0,0,0,0,0,1,0,0,0,170108,1168), (1169,1154,70,0,0,0,0,0,0,2,0,0,0,170047,1169), (1170,1154,71,0,0,0,0,0,0,2,0,0,0,170047,1170), (1171,1154,5,0,0,0,0,1,0,1,0,0,0,170095,1175), (1172,1171,15,0,0,0,0,1,0,1,0,0,0,170095,1175), (1173,1172,18,0,0,0,0,0,0,1,0,0,0,170096,1173), (1174,1172,19,0,0,0,0,0,0,1,0,0,0,170096,1174), (1175,1172,20,0,0,0,0,0,0,2,0,0,0,170096,1175), (1176,1154,21,0,0,0,0,0,0,1,0,0,0,170097,1176), (1177,1154,27,0,0,0,0,0,0,1,0,0,0,170097,1177), (1178,1154,22,0,0,0,0,5,0,1,0,0,0,170110,1186), (1179,1178,15,0,0,0,0,4,1,1,0,0,0,170111,1185), (1180,1179,18,0,0,0,0,0,0,1,0,0,0,170111,1180), (1181,1179,19,0,0,0,0,0,0,1,0,0,0,170111,1181), (1182,1179,20,0,0,0,0,0,0,7,0,0,0,170112,1182), (1183,1179,24,0,0,0,0,2,1,1,0,0,0,170113,1185), (1184,1183,19,0,0,0,0,0,0,1,0,0,0,170113,1184), (1185,1183,24,0,0,0,0,0,0,6,0,0,1,170114,1185), (1186,1178,25,0,0,0,0,0,0,1,0,0,0,170115,1186), (1187,1106,27,0,0,0,0,9,2,2,0,0,0,170048,1192), (1188,1187,15,0,0,0,0,6,4,4,0,0,0,170048,1191), (1189,1188,18,0,0,0,0,0,0,4,0,0,0,170048,1189), (1190,1188,19,0,0,0,0,1,0,4,0,0,0,170049,1190), (1191,1188,20,0,0,0,0,1,1,26,0,0,0,170049,1191), (1192,1187,34,0,0,0,0,0,0,2,0,0,0,170052,1192), (1193,1106,153,0,0,0,0,17,1,1,0,0,0,170057,1219), (1194,1193,40,0,0,0,0,16,1,1,0,0,0,170058,1219), (1195,1194,41,0,0,0,0,14,6,1,0,0,0,170059,1219), (1196,1195,42,0,0,0,0,1,0,3,0,0,0,170060,1197), (1197,1196,43,0,0,0,0,0,0,3,0,0,0,170061,1197), (1198,1195,44,0,0,0,0,0,0,1,0,0,0,170061,1198), (1199,1195,45,0,0,0,0,5,0,2,0,0,0,170062,1206), (1200,1199,46,0,0,0,0,4,2,2,0,0,0,170063,1206), (1201,1200,47,0,0,0,0,0,0,2,0,0,0,170063,1201), (1202,1200,48,0,0,0,0,1,0,2,0,0,0,170064,1204), (1203,1202,49,0,0,0,0,0,0,2,0,0,0,170065,1204), (1204,1203,50,0,0,0,0,0,0,2,0,0,0,170065,1204), (1205,1200,51,0,0,0,0,0,0,2,0,0,0,170066,1205), (1206,1200,44,0,0,0,0,0,0,2,0,0,0,170066,1206), (1207,1195,52,0,0,0,0,0,0,1,0,0,0,170066,1207), (1208,1195,53,0,0,0,0,0,0,1,0,0,0,170069,1208), (1209,1195,54,0,0,0,0,0,0,1,0,0,0,170069,1211), (1210,1209,46,0,0,0,0,0,0,1,0,0,0,170069,1211), (1211,1210,47,0,0,0,0,0,0,1,0,0,0,170070,1211), (1212,1195,55,0,0,0,0,0,0,1,0,0,0,170070,1213), (1213,1212,50,0,0,0,0,0,0,1,0,0,0,170070,1213), (1214,1195,56,0,0,0,0,0,0,1,0,0,0,170071,1214), (1215,1195,57,0,0,0,0,1,0,1,0,0,0,170072,1219), (1216,1215,49,0,0,0,0,0,0,1,0,0,0,170073,1217), (1217,1216,50,0,0,0,0,0,0,1,0,0,0,170073,1217), (1218,1215,55,0,0,0,0,0,0,1,0,0,0,170073,1219), (1219,1218,50,0,0,0,0,0,0,1,0,0,0,170073,1219), (1220,1106,154,0,0,0,0,0,0,1,0,0,0,170124,1220), (1221,814,106,0,0,0,0,5,1,1,0,0,0,170126,1226), (1222,1221,37,0,0,0,0,0,0,1,0,0,0,170127,1222), (1223,1221,15,0,0,0,0,3,1,2,0,0,0,170127,1226), (1224,1223,18,0,0,0,0,0,0,2,0,0,0,170128,1224), (1225,1223,19,0,0,0,0,0,0,2,0,0,0,170128,1225), (1226,1223,20,0,0,0,0,0,0,5,0,0,0,170129,1226), (1227,814,155,0,0,0,0,56,56,1,0,0,0,170138,1228), (1228,1227,156,0,0,0,0,0,0,1,0,0,0,170142,1228), (1229,797,106,0,0,0,0,0,0,1,0,0,0,170132,1230), (1230,1229,37,0,0,0,0,0,0,1,0,0,0,170132,1230);
INSERT INTO allocations VALUES (2,3,0,0,1,0), (2,4,0,0,1,0), (3,6,0,0,2,0), (3,7,0,0,2,0), (4,3,0,0,1,0), (4,6,0,0,1,0), (5,6,0,0,1,0), (5,7,0,0,2,0), (6,3,0,0,1,0), (6,6,0,0,1,0), (7,11,0,0,1,0), (8,3,0,0,3,0), (8,6,0,0,3,0), (10,3,0,0,1,0), (10,6,0,0,1,0), (11,7,0,0,1,0), (12,3,0,0,1,0), (12,6,0,0,1,0), (13,16,0,0,4,0), (14,6,0,0,1,0), (14,7,0,0,1,0), (15,3,0,0,1,0), (15,6,0,0,1,0), (16,11,0,0,1,0), (18,6,0,0,3,0), (18,7,0,0,6,0), (19,11,0,0,3,0), (21,6,0,0,3,0), (21,7,0,0,3,0), (25,7,0,0,4,0), (26,3,0,0,1,0), (26,6,0,0,1,0), (27,6,0,0,5,0), (28,3,0,0,1,0), (28,6,0,0,1,0), (29,6,0,0,1,0), (29,7,0,0,2,0), (30,11,0,0,1,0), (32,6,0,0,1,0), (32,7,0,0,1,0), (33,16,0,0,4,0), (37,3,0,0,1,0), (37,6,0,0,1,0), (38,11,0,0,1,0), (40,3,0,0,1,0), (40,6,0,0,1,0), (41,7,0,0,1,0), (42,6,0,0,2,0), (42,7,0,0,1,0), (43,11,0,0,1,0), (45,6,0,0,1,0), (45,7,0,0,2,0), (46,11,0,0,1,0), (48,6,0,0,1,0), (48,7,0,0,1,0), (49,3,0,0,2,0), (49,11,0,0,2,0), (50,6,0,0,2,0), (50,7,0,0,4,0), (51,11,0,0,2,0), (53,6,0,0,2,0), (53,7,0,0,2,0), (55,6,0,0,2,0), (55,7,0,0,1,0), (56,11,0,0,1,0), (58,3,0,0,10,0), (59,7,0,0,2,0), (60,6,0,0,1,0), (60,7,0,0,1,0), (61,16,0,0,2,0), (65,7,0,0,2,0), (66,7,0,0,2,0), (66,6,0,0,2,0), (67,3,0,0,3,0), (67,6,0,0,3,0), (68,6,0,0,1,0), (69,3,0,0,1,0), (69,6,0,0,1,0), (72,6,0,0,1,0), (72,7,0,0,1,0), (73,16,0,0,2,0), (77,7,0,0,2,0), (78,6,0,0,1,0), (80,6,0,0,1,0), (80,7,0,0,1,0), (81,16,0,0,2,0), (85,7,0,0,2,0), (86,6,0,0,1,0), (88,3,0,0,1,0), (88,6,0,0,1,0), (89,3,0,0,2,0), (89,6,0,0,2,0), (90,33,0,0,2,0), (91,6,0,0,4,0), (91,7,0,0,4,0), (92,16,0,0,8,0), (96,7,0,0,8,0), (98,6,0,0,4,0), (98,7,0,0,8,0), (99,6,0,0,2,0), (99,7,0,0,4,0), (100,11,0,0,2,0), (102,6,0,0,2,0), (102,7,0,0,2,0), (103,16,0,0,16,0), (107,3,0,0,1,0), (107,6,0,0,1,0), (109,16,0,0,2,0), (110,7,0,0,1,0), (110,6,0,0,1,0), (111,3,0,0,1,0), (111,6,0,0,1,0), (113,6,0,0,1,0), (114,16,0,0,4,0), (115,6,0,0,1,0), (117,6,0,0,10,0), (117,7,0,0,20,0), (118,11,0,0,10,0), (120,6,0,0,11,0), (120,7,0,0,11,0), (122,6,0,0,1,0), (122,7,0,0,2,0), (123,11,0,0,1,0), (125,6,0,0,1,0), (125,7,0,0,1,0), (128,16,0,0,2,0), (129,6,0,0,1,0), (129,7,0,0,2,0), (130,11,0,0,1,0), (132,6,0,0,1,0), (132,7,0,0,1,0), (133,11,0,0,2,0), (134,6,0,0,4,0), (134,7,0,0,8,0), (135,11,0,0,4,0), (137,6,0,0,4,0), (137,7,0,0,4,0), (139,3,0,0,1,0), (139,6,0,0,1,0), (141,6,0,0,1,0), (141,7,0,0,2,0), (142,11,0,0,1,0), (144,6,0,0,1,0), (144,7,0,0,1,0), (150,3,0,0,2,0), (150,6,0,0,2,0), (152,16,0,0,1,0), (153,6,0,0,1,0), (153,7,0,0,2,0), (154,11,0,0,1,0), (156,6,0,0,1,0), (156,7,0,0,1,0), (157,11,0,0,1,0), (162,7,0,0,5,0), (162,6,0,0,2,0), (163,11,0,0,1,0), (166,6,0,0,2,0), (166,7,0,0,4,0), (167,11,0,0,2,0), (169,6,0,0,2,0), (169,7,0,0,2,0), (174,3,0,0,1,0), (174,6,0,0,1,0), (175,16,0,0,2,0), (176,6,0,0,1,0), (181,16,0,0,2,0), (182,11,0,0,2,0), (191,16,0,0,1,0), (192,11,0,0,1,0), (202,16,0,0,2,0), (203,6,0,0,1,0), (208,16,0,0,2,0), (209,11,0,0,2,0), (218,16,0,0,1,0), (219,11,0,0,1,0), (229,7,0,0,4,0), (230,6,0,0,1,0), (230,7,0,0,1,0), (231,16,0,0,2,0), (235,7,0,0,2,0), (236,6,0,0,1,0), (238,63,0,0,8,0), (238,64,0,0,10,0), (238,6,0,0,3,0), (239,3,0,0,5,0), (239,6,0,0,5,0), (240,66,0,0,1,0), (241,6,0,0,3,0), (242,16,0,0,2,0), (246,3,0,0,1,0), (246,11,0,0,1,0), (248,3,0,0,5,0), (249,7,0,0,1,0), (250,6,0,0,2,0), (250,7,0,0,4,0), (251,11,0,0,2,0), (253,6,0,0,2,0), (253,7,0,0,2,0), (254,68,0,0,2,0), (256,6,0,0,2,0), (256,7,0,0,4,0), (257,11,0,0,2,0), (259,6,0,0,2,0), (259,7,0,0,2,0), (262,6,0,0,3,0), (263,16,0,0,2,0), (267,3,0,0,1,0), (267,11,0,0,1,0), (269,3,0,0,5,0), (270,7,0,0,1,0), (271,6,0,0,2,0), (271,7,0,0,4,0), (272,16,0,0,8,0), (277,73,0,0,1,0), (277,74,0,0,1,0), (278,6,0,0,4,0), (279,16,0,0,4,0), (283,7,0,0,2,0), (284,6,0,0,1,0), (284,7,0,0,1,0), (285,16,0,0,2,0), (287,7,0,0,2,0), (288,6,0,0,6,0), (289,16,0,0,4,0), (293,3,0,0,2,0), (293,11,0,0,2,0), (295,3,0,0,12,0), (296,7,0,0,2,0), (297,6,0,0,1,0), (297,7,0,0,1,0), (298,16,0,0,2,0), (302,7,0,0,2,0), (303,6,0,0,1,0), (305,6,0,0,1,0), (305,7,0,0,2,0), (306,16,0,0,4,0), (311,76,0,0,3,0), (312,6,0,0,3,0), (312,7,0,0,3,0), (314,6,0,0,6,0), (315,6,0,0,2,0), (316,6,0,0,3,0), (316,7,0,0,6,0), (317,11,0,0,3,0), (319,6,0,0,3,0), (319,7,0,0,3,0), (322,6,0,0,3,0), (322,7,0,0,1,0), (326,6,0,0,4,0), (326,7,0,0,2,0), (327,6,0,0,1,0), (327,7,0,0,2,0), (328,11,0,0,1,0), (330,6,0,0,1,0), (330,7,0,0,1,0), (332,6,0,0,2,0), (332,7,0,0,4,0), (333,11,0,0,2,0), (335,6,0,0,2,0), (335,7,0,0,2,0), (338,7,0,0,1,0), (338,6,0,0,1,0), (340,16,0,0,1,0), (340,90,0,0,1,0), (341,3,0,0,1,0), (341,11,0,0,2,0), (341,7,0,0,2,0), (342,6,0,0,5,0), (342,7,0,0,5,0), (343,16,0,0,10,0), (347,7,0,0,10,0), (349,6,0,0,6,0), (350,16,0,0,4,0), (354,3,0,0,2,0), (354,11,0,0,2,0), (356,3,0,0,12,0), (357,7,0,0,2,0), (358,6,0,0,1,0), (358,7,0,0,1,0), (359,16,0,0,2,0), (363,7,0,0,2,0), (364,6,0,0,1,0), (365,6,0,0,5,0), (365,7,0,0,8,0), (366,16,0,0,16,0), (372,3,0,0,1,0), (372,6,0,0,1,0), (373,16,0,0,1,0), (374,16,0,0,1,0), (374,94,0,0,1,0), (374,63,0,0,1,0), (375,7,0,0,1,0), (375,6,0,0,1,0), (378,6,0,0,1,0), (378,7,0,0,1,0), (379,16,0,0,2,0), (383,7,0,0,2,0), (384,6,0,0,1,0), (386,6,0,0,1,0), (386,7,0,0,1,0), (387,16,0,0,2,0), (391,7,0,0,2,0), (392,6,0,0,1,0), (394,33,0,0,1,0), (395,6,0,0,1,0), (395,7,0,0,1,0), (396,16,0,0,2,0), (400,7,0,0,2,0), (402,6,0,0,1,0), (402,7,0,0,2,0), (403,16,0,0,4,0), (408,16,0,0,1,0), (409,16,0,0,2,0), (410,16,0,0,1,0), (411,16,0,0,1,0), (412,7,0,0,2,0), (413,6,0,0,1,0), (413,7,0,0,1,0), (414,16,0,0,2,0), (418,7,0,0,2,0), (419,6,0,0,1,0), (421,63,0,0,4,0), (421,64,0,0,5,0), (421,6,0,0,2,0), (423,68,0,0,1,0), (427,16,0,0,1,0), (428,16,0,0,1,0), (429,7,0,0,1,0), (429,6,0,0,1,0), (431,7,0,0,2,0), (433,7,0,0,2,0), (434,16,0,0,4,0), (439,16,0,0,1,0), (440,6,0,0,3,0), (440,7,0,0,3,0), (441,16,0,0,6,0), (445,7,0,0,6,0), (447,6,0,0,3,0), (447,7,0,0,6,0), (448,16,0,0,12,0), (453,16,0,0,1,0), (453,76,0,0,2,0), (454,7,0,0,1,0), (454,6,0,0,1,0), (459,33,0,0,1,0), (460,16,0,0,1,0), (461,16,0,0,2,0), (462,16,0,0,1,0), (463,16,0,0,1,0), (464,7,0,0,2,0), (466,63,0,0,4,0), (466,64,0,0,5,0), (466,6,0,0,2,0), (468,68,0,0,1,0), (472,16,0,0,1,0), (472,100,0,0,1,0), (473,3,0,0,1,0), (473,11,0,0,2,0), (473,7,0,0,2,0), (475,16,0,0,1,0), (476,16,0,0,1,0), (476,94,0,0,1,0), (476,63,0,0,1,0), (477,16,0,0,1,0), (478,16,0,0,1,0), (479,7,0,0,1,0), (479,6,0,0,1,0), (481,7,0,0,2,0), (483,7,0,0,2,0), (484,16,0,0,4,0), (489,76,0,0,2,0), (489,16,0,0,1,0), (489,4,0,0,1,0), (490,7,0,0,1,0), (491,3,0,0,2,0), (491,6,0,0,2,0), (492,94,0,0,1,0), (494,6,0,0,4,0), (494,7,0,0,8,0), (495,11,0,0,4,0), (497,6,0,0,4,0), (497,7,0,0,4,0), (500,6,0,0,6,0), (500,7,0,0,2,0), (501,6,0,0,4,0), (502,16,0,0,4,0), (506,7,0,0,2,0), (508,7,0,0,1,0), (508,6,0,0,1,0), (510,16,0,0,1,0), (511,7,0,0,1,0), (511,6,0,0,1,0), (513,7,0,0,1,0), (513,6,0,0,1,0), (515,3,0,0,1,0), (516,6,0,0,1,0), (516,7,0,0,1,0), (517,16,0,0,2,0), (521,7,0,0,2,0), (522,6,0,0,2,0), (522,7,0,0,2,0), (524,16,0,0,4,0), (528,109,0,0,1,0), (528,3,0,0,1,0), (529,7,0,0,1,0), (530,6,0,0,2,0), (530,7,0,0,3,0), (531,3,0,0,1,0), (532,113,999094,0,999985,0), (533,3,0,0,1,0), (534,6,0,0,6,0), (535,16,0,0,4,0), (539,3,0,0,2,0), (539,11,0,0,2,0), (541,3,0,0,10,0), (542,7,0,0,2,0), (543,6,0,0,1,0), (543,7,0,0,1,0), (544,16,0,0,2,0), (548,7,0,0,2,0), (549,6,0,0,1,0), (551,7,0,0,2,0), (552,16,0,0,4,0), (557,76,0,0,844,999156), (558,3,0,0,1,0), (559,6,0,0,6,0), (560,16,0,0,4,0), (564,3,0,0,2,0), (564,11,0,0,2,0), (566,3,0,0,12,0), (567,7,0,0,2,0), (568,6,0,0,1,0), (568,7,0,0,1,0), (569,16,0,0,2,0), (573,7,0,0,2,0), (574,6,0,0,1,0), (577,6,0,0,1,0), (577,7,0,0,1,0), (578,16,0,0,2,0), (582,7,0,0,2,0), (583,6,0,0,1,0), (585,6,0,0,1,0), (585,7,0,0,1,0), (586,16,0,0,2,0), (590,7,0,0,2,0), (591,6,0,0,1,0), (593,33,0,0,1,0), (594,6,0,0,3,0), (594,7,0,0,3,0), (595,16,0,0,6,0), (599,7,0,0,6,0), (601,6,0,0,3,0), (601,7,0,0,6,0), (602,16,0,0,12,0), (607,16,0,0,1,0), (608,6,0,0,1,0), (608,7,0,0,2,0), (609,6,0,0,1,0), (609,7,0,0,2,0), (610,11,0,0,1,0), (612,6,0,0,1,0), (612,7,0,0,1,0), (613,16,0,0,2,0), (617,16,0,0,1,0), (617,116,0,0,1,0), (618,6,0,0,1,0), (623,16,0,0,2,0), (624,11,0,0,2,0), (629,6,0,0,1,0), (629,7,0,0,2,0), (630,11,0,0,1,0), (632,6,0,0,1,0), (632,7,0,0,1,0), (637,16,0,0,1,0), (638,11,0,0,1,0), (643,7,0,0,5,0), (643,6,0,0,2,0), (644,11,0,0,1,0), (646,6,0,0,1,0), (646,7,0,0,1,0), (652,16,0,0,3,0), (653,16,0,0,3,0), (654,16,0,0,3,0), (655,7,0,0,2,0), (656,6,0,0,1,0), (656,7,0,0,1,0), (657,16,0,0,2,0), (661,7,0,0,2,0), (662,6,0,0,1,0), (664,63,0,0,4,0), (664,64,0,0,5,0), (664,6,0,0,4,0), (666,6,0,0,3,0), (667,16,0,0,2,0), (671,3,0,0,1,0), (671,11,0,0,1,0), (673,3,0,0,6,0), (674,7,0,0,1,0), (675,68,0,0,1,0), (679,6,0,0,3,0), (680,16,0,0,2,0), (684,3,0,0,1,0), (684,11,0,0,1,0), (686,3,0,0,6,0), (687,7,0,0,1,0), (688,6,0,0,1,0), (688,7,0,0,2,0), (689,16,0,0,4,0), (693,7,0,0,4,0), (694,113,999203,0,999996,0), (695,6,0,0,1,0), (700,16,0,0,2,0), (701,11,0,0,2,0), (710,16,0,0,1,0), (711,11,0,0,1,0), (716,7,0,0,5,0), (716,6,0,0,2,0), (717,11,0,0,1,0), (719,6,0,0,1,0), (719,7,0,0,1,0), (725,7,0,0,1,0), (725,6,0,0,1,0), (727,7,0,0,1,0), (727,6,0,0,1,0), (729,6,0,0,2,0), (729,7,0,0,4,0), (730,11,0,0,2,0), (732,6,0,0,2,0), (732,7,0,0,2,0), (733,16,0,0,4,0), (737,7,0,0,1,0), (737,6,0,0,1,0), (739,3,0,0,1,0), (739,6,0,0,1,0), (740,6,0,0,1,0), (740,7,0,0,2,0), (741,11,0,0,1,0), (743,6,0,0,1,0), (743,7,0,0,1,0), (746,3,0,0,1,0), (747,6,0,0,1,0), (747,7,0,0,2,0), (749,16,0,0,4,0), (755,6,0,0,2,0), (755,7,0,0,2,0), (756,16,0,0,4,0), (760,7,0,0,4,0), (762,6,0,0,2,0), (762,7,0,0,2,0), (763,16,0,0,4,0), (767,7,0,0,2,0), (768,109,0,0,1,0), (768,3,0,0,1,0), (769,7,0,0,1,0), (770,6,0,0,2,0), (770,7,0,0,3,0), (774,33,0,0,1,0), (775,16,0,0,1,0), (776,16,0,0,2,0), (777,16,0,0,1,0), (778,16,0,0,1,0), (779,7,0,0,2,0), (781,63,0,0,4,0), (781,64,0,0,5,0), (781,6,0,0,3,0), (783,68,0,0,1,0), (787,16,0,0,1,0), (788,3,0,0,1,0), (789,6,0,0,1,0), (789,7,0,0,2,0), (791,16,0,0,4,0), (796,3,0,0,1,0), (797,3,0,0,2,0), (798,6,0,0,1,0), (798,7,0,0,1,0), (799,16,0,0,2,0), (803,7,0,0,2,0), (804,6,0,0,2,0), (804,7,0,0,2,0), (806,16,0,0,4,0), (810,109,0,0,2,0), (810,3,0,0,2,0), (811,7,0,0,1,0), (812,6,0,0,2,0), (812,7,0,0,3,0), (813,3,0,0,1,0), (814,3,0,0,2,0), (815,6,0,0,1,0), (815,7,0,0,1,0), (816,16,0,0,2,0), (820,7,0,0,2,0), (821,6,0,0,2,0), (821,7,0,0,2,0), (823,16,0,0,4,0), (827,109,0,0,2,0), (827,3,0,0,2,0), (828,7,0,0,1,0), (829,6,0,0,2,0), (829,7,0,0,3,0), (830,3,0,0,1,0), (832,3,0,0,2,0), (833,6,0,0,12,0), (834,16,0,0,8,0), (838,3,0,0,4,0), (838,11,0,0,4,0), (840,3,0,0,24,0), (841,7,0,0,4,0), (842,6,0,0,2,0), (842,7,0,0,2,0), (843,16,0,0,4,0), (847,7,0,0,4,0), (848,6,0,0,2,0), (850,7,0,0,4,0), (850,6,0,0,1,0), (851,16,0,0,8,0), (856,129,0,0,1,0), (856,130,0,0,1,0), (858,6,0,0,1,0), (858,7,0,0,1,0), (859,16,0,0,2,0), (863,7,0,0,2,0), (864,6,0,0,1,0), (866,6,0,0,1,0), (866,7,0,0,1,0), (867,16,0,0,2,0), (871,7,0,0,2,0), (872,6,0,0,1,0), (874,33,0,0,1,0), (875,6,0,0,1,0), (875,7,0,0,1,0), (876,16,0,0,2,0), (880,7,0,0,2,0), (882,6,0,0,1,0), (882,7,0,0,2,0), (883,16,0,0,4,0), (888,16,0,0,1,0), (889,16,0,0,1,0), (889,116,0,0,1,0), (890,16,0,0,4,0), (891,16,0,0,4,0), (892,16,0,0,4,0), (893,7,0,0,2,0), (894,6,0,0,1,0), (894,7,0,0,1,0), (895,16,0,0,2,0), (899,7,0,0,2,0), (900,6,0,0,1,0), (902,63,0,0,8,0), (902,64,0,0,5,0), (902,6,0,0,2,0), (904,6,0,0,5,0), (905,16,0,0,4,0), (909,3,0,0,1,0), (909,11,0,0,1,0), (911,3,0,0,5,0), (912,7,0,0,2,0), (913,6,0,0,1,0), (913,7,0,0,1,0), (914,16,0,0,2,0), (918,7,0,0,2,0), (920,6,0,0,1,0), (920,7,0,0,2,0), (921,16,0,0,4,0), (926,16,0,0,1,0), (926,76,0,0,1,0), (927,68,0,0,1,0), (931,6,0,0,3,0), (932,16,0,0,2,0), (936,3,0,0,1,0), (936,11,0,0,1,0), (938,3,0,0,6,0), (939,7,0,0,1,0), (941,6,0,0,1,0), (941,7,0,0,1,0), (942,6,0,0,1,0), (942,7,0,0,2,0), (943,11,0,0,1,0), (945,6,0,0,1,0), (945,7,0,0,1,0), (946,16,0,0,2,0), (947,6,2,0,2,0), (947,7,1,0,1,0), (948,11,0,0,1,0), (950,6,0,0,3,0), (950,7,0,0,6,0), (951,11,0,0,3,0), (953,6,0,0,3,0), (953,7,0,0,3,0), (957,7,0,0,2,0), (962,33,0,0,1,0), (963,16,0,0,1,0), (964,16,0,0,2,0), (965,16,0,0,1,0), (966,16,0,0,1,0), (967,7,0,0,2,0), (969,63,0,0,4,0), (969,64,0,0,5,0), (969,6,0,0,2,0), (971,68,0,0,1,0), (975,6,0,0,1,0), (975,7,0,0,2,0), (976,16,0,0,4,0), (981,16,0,0,1,0), (982,3,0,0,1,0), (982,11,0,0,2,0), (982,7,0,0,2,0), (984,16,0,0,1,0), (985,16,0,0,1,0), (985,94,0,0,1,0), (985,63,0,0,1,0), (986,16,0,0,1,0), (987,16,0,0,1,0), (988,7,0,0,1,0), (988,6,0,0,1,0), (990,7,0,0,2,0), (992,7,0,0,2,0), (993,16,0,0,4,0), (998,16,0,0,1,0), (998,76,0,0,1,0), (999,6,0,0,2,0), (999,7,0,0,4,0), (1000,11,0,0,2,0), (1002,6,0,0,2,0), (1002,7,0,0,2,0), (1003,136,0,0,1,0), (1004,6,0,0,1,0), (1006,6,0,0,2,0), (1006,7,0,0,4,0), (1007,11,0,0,2,0), (1009,6,0,0,2,0), (1009,7,0,0,2,0), (1013,6,0,0,1,0), (1013,7,0,0,1,0), (1014,16,0,0,2,0), (1018,7,0,0,2,0), (1023,33,0,0,1,0), (1024,16,0,0,1,0), (1025,16,0,0,2,0), (1026,16,0,0,1,0), (1027,16,0,0,1,0), (1028,7,0,0,2,0), (1030,6,0,0,1,0), (1030,7,0,0,1,0), (1031,16,0,0,2,0), (1035,7,0,0,2,0), (1036,6,0,0,1,0), (1037,63,0,0,2,0), (1038,6,0,0,1,0), (1038,7,0,0,1,0), (1039,16,0,0,2,0), (1043,7,0,0,2,0), (1044,6,0,0,1,0), (1045,76,0,0,2,0), (1046,6,0,0,1,0), (1046,7,0,0,1,0), (1047,16,0,0,2,0), (1051,7,0,0,2,0), (1052,6,0,0,1,0), (1053,63,0,0,8,0), (1053,64,0,0,4,0), (1053,16,0,0,2,0), (1054,6,0,0,2,0), (1054,7,0,0,4,0), (1055,11,0,0,2,0), (1057,6,0,0,2,0), (1057,7,0,0,2,0), (1059,6,0,0,3,0), (1059,7,0,0,1,0), (1060,6,0,0,2,0), (1061,16,0,0,2,0), (1065,7,0,0,1,0), (1067,6,0,0,2,0), (1067,7,0,0,2,0), (1068,16,0,0,4,0), (1072,7,0,0,4,0), (1073,6,0,0,2,0), (1076,6,0,0,1,0), (1076,7,0,0,1,0), (1077,16,0,0,2,0), (1081,7,0,0,2,0), (1082,6,0,0,1,0), (1084,6,0,0,5,0), (1084,7,0,0,10,0), (1085,11,0,0,5,0), (1087,6,0,0,5,0), (1087,7,0,0,5,0), (1088,147,0,0,2,0), (1088,63,0,0,2,0), (1091,3,0,0,4,0), (1091,6,0,0,4,0), (1094,63,0,0,4,0), (1094,64,0,0,5,0), (1094,6,0,0,1,0), (1096,68,0,0,1,0), (1100,6,0,0,1,0), (1100,7,0,0,2,0), (1101,16,0,0,4,0), (1106,3,0,0,1,0), (1106,16,0,0,1,0), (1107,3,0,0,2,0), (1107,11,0,0,2,0), (1107,7,0,0,2,0), (1109,16,0,0,1,0), (1110,16,0,0,1,0), (1110,94,0,0,1,0), (1110,63,0,0,1,0), (1111,16,0,0,1,0), (1112,16,0,0,1,0), (1113,7,0,0,1,0), (1113,6,0,0,1,0), (1116,7,0,0,2,0), (1121,6,0,0,1,0), (1121,7,0,0,1,0), (1122,16,0,0,2,0), (1126,7,0,0,2,0), (1127,6,0,0,1,0), (1128,33,0,0,2,0), (1129,16,0,0,2,0), (1130,16,0,0,1,0), (1130,116,0,0,1,0), (1131,16,0,0,3,0), (1132,16,0,0,2,0), (1133,16,0,0,2,0), (1134,6,0,0,1,0), (1134,7,0,0,1,0), (1135,16,0,0,2,0), (1139,7,0,0,2,0), (1141,6,0,0,1,0), (1141,7,0,0,2,0), (1142,16,0,0,4,0), (1147,6,0,0,1,0), (1147,7,0,0,1,0), (1148,16,0,0,2,0), (1152,7,0,0,2,0), (1153,6,0,0,1,0), (1154,7,0,0,4,0), (1156,63,0,0,8,0), (1156,64,0,0,10,0), (1156,6,0,0,1,0), (1158,68,0,0,2,0), (1160,6,0,0,3,0), (1161,16,0,0,2,0), (1165,3,0,0,1,0), (1165,11,0,0,1,0), (1167,3,0,0,6,0), (1168,7,0,0,1,0), (1171,6,0,0,1,0), (1171,7,0,0,1,0), (1172,16,0,0,2,0), (1176,7,0,0,2,0), (1177,6,0,0,1,0), (1178,6,0,0,3,0), (1179,16,0,0,2,0), (1183,3,0,0,1,0), (1183,11,0,0,1,0), (1185,3,0,0,6,0), (1186,7,0,0,1,0), (1187,6,0,0,2,0), (1187,7,0,0,4,0), (1188,16,0,0,8,0), (1193,16,0,0,2,0), (1194,6,0,0,1,0), (1199,16,0,0,2,0), (1200,11,0,0,2,0), (1209,16,0,0,1,0), (1210,11,0,0,1,0), (1221,7,0,0,1,0), (1221,6,0,0,1,0), (1223,16,0,0,4,0), (1229,7,0,0,1,0), (1229,6,0,0,1,0);
INSERT INTO profile VALUES (170193,712,1,0,0,0);
INSERT INTO profile VALUES (162698,0,3,0,NULL,8092);
END;
