#!/usr/bin/env raku
use v6.d;

use Text::CSV;
use Data::Reshapers;
use Data::Summarizers;
use Data::TypeSystem;

my $fileName = $*CWD ~ '/resources/dfQASParameters.csv';

my @dsTESpecs = csv(in => $fileName, headers => 'auto');

say @dsTESpecs.WHAT;
say deduce-type(@dsTESpecs);

say is-reshapable(@dsTESpecs);
say is-reshapable(@dsTESpecs, iterable-type => Iterable, record-type => Map);

records-summary(@dsTESpecs, max-tallies => 12);

say select-columns(@dsTESpecs, <WorkflowType>)>>.values.flat.unique;
