#!/usr/bin/env raku
use v6.d;

use Text::CSV;
use Data::Reshapers;
use Data::TypeSystem;

my $fileName = $*CWD ~ '/resources/dfQASParameters.csv';

my @dsTESpecs = csv(in => $fileName, headers => 'auto');

say @dsTESpecs.WHAT;
say deduce-type(@dsTESpecs);

say is-reshapable(@dsTESpecs);
say is-reshapable(@dsTESpecs, iterable-type => Iterable, record-type => Map);

say &is-reshapable.WHY;

#========================================================================================================================

sub to-number-maybe(Str $x) {
    my $res = +$x;
    $res.defined ?? $res !! $x
}

#----------------------------------------------------------
multi normalize-quotes(@x) {
    @x.map({ normalize-quotes($_) }).List;
}
multi normalize-quotes(Str $x) {
    if $x ~~ / ^ \" (.+) \" $/ {
        return $0.Str;
    }
    return $x;
}

#----------------------------------------------------------
multi sub from-wl-spec-maybe($x where * !~~ Str) {
    $x
}

multi sub from-wl-spec-maybe(Str $x) {
    my regex wl-spec {
        ^ \{  $<words>=([\" \S+ \"]+ % [\h* ',' \h*]) \} $
    };
    if $x ~~ &wl-spec {
        return $x.substr(1, *- 1).split(/ \h* ',' \h*/, :skip-empty).&normalize-quotes.List;
    }
    return $x;
}

#----------------------------------------------------------
multi sub to-nested-pairs(@x) {
    reduce({ Pair.new($^b, $^a) }, |@x.reverse)
}

#========================================================================================================================


@dsTESpecs = @dsTESpecs.map({
    $_<Value> = to-number-maybe($_<Value>);
    $_
});

@dsTESpecs = @dsTESpecs.map({
    $_<Value> = from-wl-spec-maybe($_<Value>);
    $_
});

my @qasSpecs = @dsTESpecs.map({ to-nested-pairs($_<DataType WorkflowType Group Key Value>) });

#========================================================================================================================

# .raku.say for @dsTESpecs.head(12);

#========================================================================================================================

say "=" x 120;

# .say for @qasSpecs.head(12);

#========================================================================================================================

say "=" x 120;
my %qas = Hash.new.classify-list( {
    [
        $_<DataType>,
        $_<WorkflowType>,
        $_<Group>,
        $_<Key>,
        $_<Value>
    ]
}, @dsTESpecs );

#say %qas;