#!/usr/bin/env raku
use v6.d;

use lib '.';
use lib './lib';

use Text::CSV;
use Data::Reshapers;
use Data::TypeSystem;
use ML::FindTextualAnswer;

use ML::NLPTemplateEngine::Ingestion;

my $fileName = $*CWD ~ '/resources/dfQASParameters.csv';

#`[
my @dsTESpecs = csv(in => $fileName, headers => 'auto');

say 'deduce-type(@dsTESpecs) : ', deduce-type(@dsTESpecs);

my %qas = ConvertCSVData(@dsTESpecs);
]

my %qas = ConvertCSVData($fileName);

say %qas.keys;

say deduce-type(%qas);

for %qas.kv -> $k, $v { say "$k => {deduce-type($v)}"; };

say '-' x 120;

say %qas<Defaults>.raku;

say '-' x 120;

say %qas<ParameterQuestions><RandomTabularDataset>;

say '=' x 120;

#`[
my $command = "Make classifier with the method Random Forest over the data dfTitanic. Show Precision and Recall. Split the data with ratio 0.75; plot ROC functions PPV vs TPR.";
my @questions = ["What classification algorithm to use?", "Which dataset to use?"];

# .say for find-textual-answer($command, @questions, llm => 'palm', max-tokens => 400, temperature => 0.2);

say '-' x 120;

#say %qas{'Questions'};
say %qas{'ParameterQuestions';'ClCon'};
my %qas2 = %qas<ParameterQuestions><ClCon>;

say %qas2.elems;

.say for %qas2;

my %paramToQuestion = %qas2.map({ $_.key => $_.value.keys.pick });
.say for %paramToQuestion;

my %questionToParam = %paramToQuestion.invert;

my @questions2 = %questionToParam.keys;

@questions2 = @questions2 »~» '?';

say '-' x 120;

.say for @questions2;

say '-' x 120;

my $ans = find-textual-answer($command, @questions2, llm => 'palm', max-tokens => 400, temperature => 0.5):!echo:pairs;

if $ans ~~ Positional {
    .say for |$ans;
} else {
    say $ans;
}

say '=' x 120;

my $toLang = 'WL';
my $tmpl = %qas<Templates><ClCon>{$toLang};

say $tmpl.WHAT;
say $tmpl.values;

my $tmpl2 = $tmpl.values.head.head<Value>;

say $tmpl2;

say '-' x 120;

if $ans ~~ Positional {

    my %answers = |$ans;

    my $tmplFilledIn = $tmpl2;

    for %questionToParam.kv -> $k, $v {
        $tmplFilledIn .= subst( /  ',' \h* 'TemplateSlot["' $v '"]' \h* ',' \h* /, %answers{$k ~ '?'}):g;
    }

    $tmplFilledIn .= subst(/ ^ 'TemplateObject[{"'/, '');
    $tmplFilledIn .= subst(/ '"},' \h* 'CombinerFunction -> StringJoin' \h* ',' \h* 'InsertionFunction -> TextString]' $ /, '');

    say $tmplFilledIn;
}
]