#!/usr/bin/env raku
use v6.d;

use Math::SalvoCombatModeling;


#==========================================================
# Parameters
#==========================================================
multi sub param(Str:D $name, Str:D $a where * eq 'B', Str:D $b where * eq 'G', UInt:D $i, UInt:D $j) {
    0
}

multi sub param(Str:D $name, Str:D $a where * eq 'G', Str:D $b where * eq 'B', UInt:D $i, UInt:D $j) {
    given $name {
        when 'beta' {
            given ($i, $j) {
                when (1, 1) { 2.16 }
                when (1, 2) { 2.16 }
                when (1, 3) { 2.16 }

                when (2, 1) { 2.16 }
                when (2, 2) { 2.16 }
                when (2, 3) { 2.16 }

                when (3, 1) { 2.165 }
                when (3, 2) { 2.165 }
                when (3, 3) { 2.165 }

                when (4, 1) { 2.165 }
                when (4, 2) { 2.165 }
                when (4, 3) { 2.165 }
            }
        }

        when 'curlyepsilon' {
            given ($i, $j) {
                when (1, 1) { 0.028 }
                when (1, 2) { 0.028 }
                when (1, 3) { 0.028 }
                when (2, 1) { 0.028 }
                when (2, 2) { 0.028 }
                when (2, 3) { 0.028 }

                when (3, 1) { 0.012 }
                when (3, 2) { 0.012 }
                when (3, 3) { 0.012 }
                when (4, 1) { 0.012 }
                when (4, 2) { 0.012 }
                when (4, 3) { 0.012 }
            }
        }

        when 'capitalpsi' {
            given ($i, $j) {
                when (1, 1) { 0.5 }
                when (1, 2) { 0.5 }
                when (2, 1) { 0.5 }
                when (2, 2) { 0.5 }

                when (3, 1) { 0 }
                when (3, 2) { 0 }
                when (4, 1) { 0 }
                when (4, 2) { 0 }

                when (1, 3) { 0 }
                when (2, 3) { 0 }
                when (3, 3) { 1 }
                when (4, 3) { 1 }
            }
        }
    }
}

multi sub param(Str:D $name, Str:D $a where * eq 'G', UInt:D $i) { 1 }

multi sub param(Str:D $name, Str:D $a where * eq 'B', UInt:D $i) {
    given $name {
        when 'zeta' {
            given $i {
                when 1 { 1.605 }
                when 2 { 1.605 }
                when 3 { 1.23 }
            }
        }
    }
}

multi sub param(Str:D $name where $name eq 'units', Str:D $a where * eq 'B', UInt:D $i) { $i }
multi sub param(Str:D $name where $name eq 'units', Str:D $a where * eq 'G', UInt:D $i) { $i }

#==========================================================
# Model
#==========================================================

my $m = heterogeneous-salvo-model(['B', 3], ['G', 4], :offensive-effectiveness-terms, :&param);

sink $m<B><defense-matrix> = ((0 xx $m<B><defense-matrix>.head.elems).Array xx $m<B><defense-matrix>.elems).Array;
sink $m<G><defense-matrix> = ((0 xx $m<G><defense-matrix>.head.elems).Array xx $m<G><defense-matrix>.elems).Array;

say (:$m);