# Math::SalvoCombatModeling

Raku package for the mathematical representation of missile battles. 
Certain battles involving drones and continuous fire can be also represented.

-----

## Installation

```
zef install Math::SalvoCombatModeling
```

-----

## Details

- The original salvo combat model provides a mathematical representation of anti-ship missile battles between modern warships, [Wk1].

- The Heterogeneous Salvo Combat Model (HSCM) extension of the original model allows more detailed and comprehensive modeling of missile, drone, and continuous fire combat scenarios.

- The package provides functions for building HSCMs and -- very importantly -- functions reviewing the variables and definitions used in HSCMs.

- A model generated with the package function `heterogeneous-salvo-model` gives matrix-based formulas for computing the damage inflicted on the forces.

- The package has also functions for damage calculations using standard, summation formulas.

- The implementation of the Raku package "Math::SalvoCombatModeling" closely follows the implementation of the Wolfram Language (WL) paclet ["SalvoCombatModeling"](https://resources.wolframcloud.com/PacletRepository/resources/AntonAntonov/SalvoCombatModeling), [AAp1].

  - Since WL has (i) symbolic builtin computations and (ii) a mature notebook system the salvo models computation, representation, and study with WL is much more convenient.

-----

## Usage examples

Here we generate a homogeneous salvo combat model:

```raku
use Math::SalvoCombatModeling;

my $m = heterogeneous-salvo-model(['A', 2], ['B', 1])
```
```
# {A => {defense-matrix => [[(((gamma(A,B,1,1))*(delta(A,B,1,1))*(capitaltheta(A,B,1,1))*(tau(A,B,1,1)))/(zeta(A,1))) 0] [0 (((gamma(A,B,2,1))*(delta(A,B,2,1))*(capitaltheta(A,B,2,1))*(tau(A,B,2,1)))/(zeta(A,2)))]], offense-matrix => [[((beta(B,A,1,1))*((sigma(B,A,1,1))*(tau(B,A,1,1))*(rho(A,B,1,1)))*(capitalpsi(B,A,1,1)))/(zeta(A,1))] [((beta(B,A,1,2))*((sigma(B,A,1,2))*(tau(B,A,1,2))*(rho(A,B,2,1)))*(capitalpsi(B,A,1,2)))/(zeta(A,2))]], units => [A[1] A[2]]}, B => {defense-matrix => [[(((gamma(B,A,1,1))*(delta(B,A,1,1))*(capitaltheta(B,A,1,1))*(tau(B,A,1,1)))/(zeta(B,1))) + (((gamma(B,A,1,2))*(delta(B,A,1,2))*(capitaltheta(B,A,1,2))*(tau(B,A,1,2)))/(zeta(B,1)))]], offense-matrix => [[((beta(A,B,1,1))*((sigma(A,B,1,1))*(tau(A,B,1,1))*(rho(B,A,1,1)))*(capitalpsi(A,B,1,1)))/(zeta(B,1)) ((beta(A,B,2,1))*((sigma(A,B,2,1))*(tau(A,B,2,1))*(rho(B,A,1,2)))*(capitalpsi(A,B,2,1)))/(zeta(B,1))]], units => [B[1]]}}
```

The following table shows model variables and descriptions using `salvo-variable-rules`:

```raku, results=asis
use Data::Translators;

salvo-variable-rules(['A',1], ['B', 2])
andthen .map({ <variable description> Z=> [$_.key, $_.value] })».Hash
andthen .&to-html(field-names=> <variable description>, align => 'left')
```
<table border="1"><thead><tr><th>variable</th><th>description</th></tr></thead><tbody><tr><td align=left>beta(A,B,1,1)</td><td align=left>beta: Offensive combat potential of A[1] units against B[1]. (hits /shooting unit)</td></tr><tr><td align=left>beta(A,B,1,2)</td><td align=left>beta: Offensive combat potential of A[1] units against B[2]. (hits /shooting unit)</td></tr><tr><td align=left>capitalpsi(A,B,1,1)</td><td align=left>capitalpsi: Fraction of A[1] units that engage B[1] units. [0,1]</td></tr><tr><td align=left>capitalpsi(A,B,1,2)</td><td align=left>capitalpsi: Fraction of A[1] units that engage B[2] units. [0,1]</td></tr><tr><td align=left>gamma(A,B,1,1)</td><td align=left>gamma: Defensive combat power of side A[1] against B[1] units, (shots / defending units)</td></tr><tr><td align=left>gamma(A,B,1,2)</td><td align=left>gamma: Defensive combat power of side A[1] against B[2] units, (shots / defending units)</td></tr><tr><td align=left>capitaltheta(A,B,1,1)</td><td align=left>capitaltheta: Fraction of A[1] units that engage B[1] units. [0,1]</td></tr><tr><td align=left>capitaltheta(A,B,1,2)</td><td align=left>capitaltheta: Fraction of A[1] units that engage B[2] units. [0,1]</td></tr><tr><td align=left>zeta(A,1)</td><td align=left>zeta: Staying power of A[1] unit, (hits)</td></tr><tr><td align=left>sigma(A,B,1,1)</td><td align=left>sigma: Scouting effectiveness of unit A[1] against B[1]. [0,1]</td></tr><tr><td align=left>sigma(A,B,1,2)</td><td align=left>sigma: Scouting effectiveness of unit A[1] against B[2]. [0,1]</td></tr><tr><td align=left>tau(A,B,1,1)</td><td align=left>tau: Training effectiveness of unit A[1] against B[1]. [0,1]</td></tr><tr><td align=left>tau(A,B,1,2)</td><td align=left>tau: Training effectiveness of unit A[1] against B[2]. [0,1]</td></tr><tr><td align=left>rho(A,B,1,1)</td><td align=left>rho: Distraction factor of unit A[1] against B[1]. [0,1]</td></tr><tr><td align=left>rho(A,B,1,2)</td><td align=left>rho: Distraction factor of unit A[1] against B[2]. [0,1]</td></tr><tr><td align=left>curlyepsilon(A,B,1,1)</td><td align=left>curlyepsilon: Offensive effectiveness of A[1] against B[1]. [0,1]</td></tr><tr><td align=left>curlyepsilon(A,B,1,2)</td><td align=left>curlyepsilon: Offensive effectiveness of A[1] against B[2]. [0,1]</td></tr><tr><td align=left>delta(A,B,1,1)</td><td align=left>delta: Defender alertness or readiness of unit A[1] against B[1]. [0,1]</td></tr><tr><td align=left>delta(A,B,1,2)</td><td align=left>delta: Defender alertness or readiness of unit A[1] against B[2]. [0,1]</td></tr><tr><td align=left>beta(B,A,1,1)</td><td align=left>beta: Offensive combat potential of B[1] units against A[1]. (hits /shooting unit)</td></tr><tr><td align=left>beta(B,A,2,1)</td><td align=left>beta: Offensive combat potential of B[2] units against A[1]. (hits /shooting unit)</td></tr><tr><td align=left>capitalpsi(B,A,1,1)</td><td align=left>capitalpsi: Fraction of B[1] units that engage A[1] units. [0,1]</td></tr><tr><td align=left>capitalpsi(B,A,2,1)</td><td align=left>capitalpsi: Fraction of B[2] units that engage A[1] units. [0,1]</td></tr><tr><td align=left>gamma(B,A,1,1)</td><td align=left>gamma: Defensive combat power of side B[1] against A[1] units, (shots / defending units)</td></tr><tr><td align=left>gamma(B,A,2,1)</td><td align=left>gamma: Defensive combat power of side B[2] against A[1] units, (shots / defending units)</td></tr><tr><td align=left>capitaltheta(B,A,1,1)</td><td align=left>capitaltheta: Fraction of B[1] units that engage A[1] units. [0,1]</td></tr><tr><td align=left>capitaltheta(B,A,2,1)</td><td align=left>capitaltheta: Fraction of B[2] units that engage A[1] units. [0,1]</td></tr><tr><td align=left>zeta(B,1)</td><td align=left>zeta: Staying power of B[1] unit, (hits)</td></tr><tr><td align=left>zeta(B,2)</td><td align=left>zeta: Staying power of B[2] unit, (hits)</td></tr><tr><td align=left>sigma(B,A,1,1)</td><td align=left>sigma: Scouting effectiveness of unit B[1] against A[1]. [0,1]</td></tr><tr><td align=left>sigma(B,A,2,1)</td><td align=left>sigma: Scouting effectiveness of unit B[2] against A[1]. [0,1]</td></tr><tr><td align=left>tau(B,A,1,1)</td><td align=left>tau: Training effectiveness of unit B[1] against A[1]. [0,1]</td></tr><tr><td align=left>tau(B,A,2,1)</td><td align=left>tau: Training effectiveness of unit B[2] against A[1]. [0,1]</td></tr><tr><td align=left>rho(B,A,1,1)</td><td align=left>rho: Distraction factor of unit B[1] against A[1]. [0,1]</td></tr><tr><td align=left>rho(B,A,2,1)</td><td align=left>rho: Distraction factor of unit B[2] against A[1]. [0,1]</td></tr><tr><td align=left>curlyepsilon(B,A,1,1)</td><td align=left>curlyepsilon: Offensive effectiveness of B[1] against A[1]. [0,1]</td></tr><tr><td align=left>curlyepsilon(B,A,2,1)</td><td align=left>curlyepsilon: Offensive effectiveness of B[2] against A[1]. [0,1]</td></tr><tr><td align=left>delta(B,A,1,1)</td><td align=left>delta: Defender alertness or readiness of unit B[1] against A[1]. [0,1]</td></tr><tr><td align=left>delta(B,A,2,1)</td><td align=left>delta: Defender alertness or readiness of unit B[2] against A[1]. [0,1]</td></tr></tbody></table>


### Scope

Colors or emoji characters (like flags) can be used to designate the forces. For example, here is generated a model for "Red vs. Blue":

```raku
my $m = heterogeneous-salvo-model(['🟥', 2], ['🟦', 2]);
```
```
# {🟥 => {defense-matrix => [[(((gamma(🟥,🟦,1,1))*(delta(🟥,🟦,1,1))*(capitaltheta(🟥,🟦,1,1))*(tau(🟥,🟦,1,1)))/(zeta(🟥,1))) + (((gamma(🟥,🟦,1,2))*(delta(🟥,🟦,1,2))*(capitaltheta(🟥,🟦,1,2))*(tau(🟥,🟦,1,2)))/(zeta(🟥,1))) 0] [0 (((gamma(🟥,🟦,2,1))*(delta(🟥,🟦,2,1))*(capitaltheta(🟥,🟦,2,1))*(tau(🟥,🟦,2,1)))/(zeta(🟥,2))) + (((gamma(🟥,🟦,2,2))*(delta(🟥,🟦,2,2))*(capitaltheta(🟥,🟦,2,2))*(tau(🟥,🟦,2,2)))/(zeta(🟥,2)))]], offense-matrix => [[((beta(🟦,🟥,1,1))*((sigma(🟦,🟥,1,1))*(tau(🟦,🟥,1,1))*(rho(🟥,🟦,1,1)))*(capitalpsi(🟦,🟥,1,1)))/(zeta(🟥,1)) ((beta(🟦,🟥,2,1))*((sigma(🟦,🟥,2,1))*(tau(🟦,🟥,2,1))*(rho(🟥,🟦,1,2)))*(capitalpsi(🟦,🟥,2,1)))/(zeta(🟥,1))] [((beta(🟦,🟥,1,2))*((sigma(🟦,🟥,1,2))*(tau(🟦,🟥,1,2))*(rho(🟥,🟦,2,1)))*(capitalpsi(🟦,🟥,1,2)))/(zeta(🟥,2)) ((beta(🟦,🟥,2,2))*((sigma(🟦,🟥,2,2))*(tau(🟦,🟥,2,2))*(rho(🟥,🟦,2,2)))*(capitalpsi(🟦,🟥,2,2)))/(zeta(🟥,2))]], units => [🟥[1] 🟥[2]]}, 🟦 => {defense-matrix => [[(((gamma(🟦,🟥,1,1))*(delta(🟦,🟥,1,1))*(capitaltheta(🟦,🟥,1,1))*(tau(🟦,🟥,1,1)))/(zeta(🟦,1))) + (((gamma(🟦,🟥,1,2))*(delta(🟦,🟥,1,2))*(capitaltheta(🟦,🟥,1,2))*(tau(🟦,🟥,1,2)))/(zeta(🟦,1))) 0] [0 (((gamma(🟦,🟥,2,1))*(delta(🟦,🟥,2,1))*(capitaltheta(🟦,🟥,2,1))*(tau(🟦,🟥,2,1)))/(zeta(🟦,2))) + (((gamma(🟦,🟥,2,2))*(delta(🟦,🟥,2,2))*(capitaltheta(🟦,🟥,2,2))*(tau(🟦,🟥,2,2)))/(zeta(🟦,2)))]], offense-matrix => [[((beta(🟥,🟦,1,1))*((sigma(🟥,🟦,1,1))*(tau(🟥,🟦,1,1))*(rho(🟦,🟥,1,1)))*(capitalpsi(🟥,🟦,1,1)))/(zeta(🟦,1)) ((beta(🟥,🟦,2,1))*((sigma(🟥,🟦,2,1))*(tau(🟥,🟦,2,1))*(rho(🟦,🟥,1,2)))*(capitalpsi(🟥,🟦,2,1)))/(zeta(🟦,1))] [((beta(🟥,🟦,1,2))*((sigma(🟥,🟦,1,2))*(tau(🟥,🟦,1,2))*(rho(🟦,🟥,2,1)))*(capitalpsi(🟥,🟦,1,2)))/(zeta(🟦,2)) ((beta(🟥,🟦,2,2))*((sigma(🟥,🟦,2,2))*(tau(🟥,🟦,2,2))*(rho(🟦,🟥,2,2)))*(capitalpsi(🟥,🟦,2,2)))/(zeta(🟦,2))]], units => [🟦[1] 🟦[2]]}}
```

<div style="width: 60%; margin: 0 auto; border-top: 1px solid gray;"></div>

The sub `heterogeneous-salvo-model` takes an optional parameter-function argument. 
Without that parameter function being specified the salvo model is returned as hashmap of strings (as above.)
If the parameter function is specified the corresponding numeric computations are done. 
For complete worked example see the notebook ["Battle-of-Coronel.ipynb"](./docs/Battle-of-Coronel.ipynb) 
or the corresponding script ["Battle-of-Coronel.raku"](./examples/Battle-of-Coronel.raku). 

<div style="width: 60%; margin: 0 auto; border-top: 1px solid gray;"></div>

To see the combat salvo modeling definitions in Bulgarian, English, or Russian, the sub `salvo-notion-definitions` can be used:

```raku, results=asis
salvo-notion-definitions('English')
==> to-html(align => 'left')
```
<table border="1"><thead><tr><th>notion</th><th>definition</th></tr></thead><tbody><tr><td align=left>Force</td><td align=left>A group of naval ships that operate and fight together.</td></tr><tr><td align=left>Unit</td><td align=left>A unit is an individual ship in a force.</td></tr><tr><td align=left>Salvo</td><td align=left>A salvo is the number of shots fired as a unit of force in a discrete period of time.</td></tr><tr><td align=left>Combat Potential</td><td align=left>Combat Potential is a force&#39;s total stored offensive capability of an element or force measured in number of total shots available.</td></tr><tr><td align=left>Combat Power</td><td align=left>Also called Striking Power, is the maximum offensive capability of an element or force per salvo, measured in the number of hitting shots that would be achieved in the absence of degrading factors.</td></tr><tr><td align=left>Scouting Effectiveness</td><td align=left>Scouting Effectiveness is a dimensionless degradation factor applied to a force&#39;s combat power as a result of imperfect information. It is a number between zero and one that describes the difference between the shots delivered based on perfect knowledge of enemy composition and position and shots based on existing information [Ref. 7].</td></tr><tr><td align=left>Training Effectiveness</td><td align=left>Training effectiveness is a fraction that indicates the degradation in combat power due the lack of training, motivation, or readiness.</td></tr><tr><td align=left>Distraction Factor</td><td align=left>Also called chaff effectiveness or seduction, is a multiplier that describes the effectiveness of an offensive weapon in the presence of distraction or other soft kill. This multiplier is a fraction, where one indicates no susceptibility/complete effectiveness and zero indicates complete susceptibility/no effectiveness.</td></tr><tr><td align=left>Offensive Effectiveness</td><td align=left>Offensive effectiveness is a composite term made of the product of scouting effectiveness, training effectiveness, distraction, or any other factor which represents the probability of a single salvo hitting its target. Offensive effectiveness transforms a unit&#39;s combat potential parameter into combat power.</td></tr><tr><td align=left>Defensive Potential</td><td align=left>Defensive potential is a force&#39;s total defensive capability measured in units of enemy hits eliminated independent of weapon system or operator accuracy or any other multiplicative factor.</td></tr><tr><td align=left>Defensive Power</td><td align=left>Defensive power is the number of missiles in an enemy salvo that a defending element or force can eliminate.</td></tr><tr><td align=left>Defender Alertness</td><td align=left>Defender alertness is the extent to which a defender fails to take proper defensive actions against enemy fire. This may be the result of any inattentiveness due to improper emission control procedures, readiness, or other similar factors. This multiplier is a fraction, where one indicates complete alertness and zero indicates no alertness.</td></tr><tr><td align=left>Defensive Effectiveness</td><td align=left>Defensive effectiveness is a composite term made of the product of training effectiveness and defender alertness. This term also applies to any value that represents the overall degradation of a force&#39;s defensive power.</td></tr><tr><td align=left>Staying Power</td><td align=left>Staying power is the number of hits that a unit or force can absorb before being placed out of action.</td></tr></tbody></table>


-----

## References

### Articles, theses

[MJ1] Michael D. Johns, Steven E. Pilnick, Wayne P. Hughes, ["Heterogeneous Salvo Model for the Navy After Next"](https://apps.dtic.mil/sti/citations/ADA386434), (2000), Defense Technical Information Center.

[TB1] Thomas R. Beall, ["The Development of a Naval Battle Model and Its Validation Using Historical Data"](https://apps.dtic.mil/sti/citations/ADA226615), (1990),  Defense Technical Information Center.

[Wk1] Wikipedia entry, [Salvo combat model](https://en.wikipedia.org/wiki/Salvo_combat_model).

### Packages, paclets

[AAp2] Anton Antonov, [SalvoCombatModeling, Wolfram Language paclet](https://resources.wolframcloud.com/PacletRepository/resources/AntonAntonov/SalvoCombatModeling/), (2024), Wolfram Language Paclet Repository.

