# Math::SalvoCombatModeling

Raku package for the mathematical representation of missile battles. 
Certain battles involving drones and continuous fire can be also represented.

-----

## Installation

```
zef install Math::SalvoCombatModeling
```

-----

## Details

- The original salvo combat model provides a mathematical representation of anti-ship missile battles between modern warships, [Wk1].

- The Heterogeneous Salvo Combat Model (HSCM) extension of the original model allows more detailed and comprehensive modeling of missile, drone, and continuous fire combat scenarios.

- The package provides functions for building HSCMs and -- very importantly -- functions reviewing the variables and definitions used in HSCMs.

- A model generated with the package function `heterogeneous-salvo-model` gives matrix-based formulas for computing the damage inflicted on the forces.

- The package has also functions for damage calculations using standard, summation formulas.

- The implementation of the Raku package "Math::SalvoCombatModeling" closely follows the implementation of the Wolfram Language (WL) paclet ["SalvoCombatModeling"](https://resources.wolframcloud.com/PacletRepository/resources/AntonAntonov/SalvoCombatModeling), [AAp1].

  - Since WL has (i) symbolic builtin computations and (ii) a mature notebook system the salvo models computation, representation, and study with WL is much more convenient.

-----

## Usage examples

Here we generate a homogeneous salvo combat model:

```raku
use Math::SalvoCombatModeling;

my $m = heterogeneous-salvo-model(['A', 2], ['B', 1])
```

The following table shows model variables and descriptions using `salvo-variable-rules`:

```raku, results=asis
use Data::Translators;

salvo-variable-rules(['A',1], ['B', 2])
andthen .map({ <variable description> Z=> [$_.key, $_.value] })».Hash
andthen .&to-html(field-names=> <variable description>, align => 'left')
```

### Scope

Colors or emoji characters (like flags) can be used to designate the forces. For example, here is generated a model for "Red vs. Blue":

```raku
my $m = heterogeneous-salvo-model(['🟥', 2], ['🟦', 2]);
```

<div style="width: 60%; margin: 0 auto; border-top: 1px solid gray;"></div>

The sub `heterogeneous-salvo-model` takes an optional parameter-function argument. 
Without that parameter function being specified the salvo model is returned as hashmap of strings (as above.)
If the parameter function is specified the corresponding numeric computations are done. 
For complete worked example see the notebook ["Battle-of-Coronel.ipynb"](./docs/Battle-of-Coronel.ipynb) 
or the corresponding script ["Battle-of-Coronel.raku"](./examples/Battle-of-Coronel.raku). 

<div style="width: 60%; margin: 0 auto; border-top: 1px solid gray;"></div>

To see the combat salvo modeling definitions in Bulgarian, English, or Russian, the sub `salvo-notion-definitions` can be used:

```raku, results=asis
salvo-notion-definitions('English')
==> to-html(align => 'left')
```

-----

## References

### Articles, theses

[MJ1] Michael D. Johns, Steven E. Pilnick, Wayne P. Hughes, ["Heterogeneous Salvo Model for the Navy After Next"](https://apps.dtic.mil/sti/citations/ADA386434), (2000), Defense Technical Information Center.

[TB1] Thomas R. Beall, ["The Development of a Naval Battle Model and Its Validation Using Historical Data"](https://apps.dtic.mil/sti/citations/ADA226615), (1990),  Defense Technical Information Center.

[Wk1] Wikipedia entry, [Salvo combat model](https://en.wikipedia.org/wiki/Salvo_combat_model).

### Packages, paclets

[AAp2] Anton Antonov, [SalvoCombatModeling, Wolfram Language paclet](https://resources.wolframcloud.com/PacletRepository/resources/AntonAntonov/SalvoCombatModeling/), (2024), Wolfram Language Paclet Repository.

