# Scalable-Recommender-Framework-project

## In brief

This project repository has documents, diagrams, tests, and benchmarks of a recommender system
implemented  in multiple programming languages.

**Remark:** Mathematica and Wolfram Language (WL) are used as synonyms in this repository.

-------

## Scalability

Scalability is defined in three principle ways:

1. Computation speed
    - Who is the target user of the recommendations?
2. Deploy-ability
    - On what platforms the recommender system can be run?
3. Adoption
    - Who would want to use it?

The following mind-map provides structure and breakdown of the scalability topics
discussed in this repository:

[![][1]][2]


-------

## Benchmarks

### Data

| Data       | Files prefix |
|------------|--------------|
| Small-size | ZefEcosystem |

### Files

| Programming language | Mid-size data benchmark file                                            | Large data benchmark file | 
|----------------------|-------------------------------------------------------------------------|---------------------------|
| Java                 |                                                                         |                           |
| Mathematica / WL     |                                                                         |                           |
| Python               | [ZefEcosystem-SMR-benchmark.py](./Python/ZefEcosystem-SMR-benchmark.py) |                           |
| R                    | [ZefEcosystem-SMR-benchmark.Rmd](./R/ZefEcosystem-SMR-benchmark.Rmd)    |                           |
| Raku                 |                                                                         |                           |
| SQLite               |                                                                         |                           |
| Swift                |                                                                         |                           |

### Reports


--------

## References

### Articles

[AA1] Anton Antonov,
["Mapping Sparse Matrix Recommender to Streams Blending Recommender"](https://github.com/antononcube/MathematicaForPrediction/blob/master/Documentation/MappingSMRtoSBR/Mapping-Sparse-Matrix-Recommender-to-Streams-Blending-Recommender.pdf)
(2017),
[MathematicaForPrediction at GitHub](https://github.com/antononcube/MathematicaForPrediction).

*TBF...*

### Data

*TBD...*

### Java packages

[AAr1] Anton Antonov,
[Java-StreamsBlendingRecommender](https://github.com/antononcube/Java-StreamsBlendingRecommender),
(2015-2022),
[GitHub/antononcube](https://github.com/antononcube).

### Kotlin packages

[AAr2] Anton Antonov,
[Kotlin-StreamsBlendingRecommender](https://github.com/antononcube/Kotlin-StreamsBlendingRecommender),
(2021),
[GitHub/antononcube](https://github.com/antononcube).

### Mathematica packages

[AAp1] Anton Antonov,
[Sparse matrix recommender framework in Mathematica](https://github.com/antononcube/MathematicaForPrediction/blob/master/SparseMatrixRecommenderFramework.m),
(2014-2016),
[MathematicaForPrediction at GitHub/antononcube](https://github.com/antononcube/MathematicaForPrediction).

[AAp2] Anton Antonov,
[SSparseMatrix Mathematica package](https://github.com/antononcube/MathematicaForPrediction/blob/master/SSparseMatrix.m),
(2018),
[MathematicaForPrediction at GitHub/antononcube](https://github.com/antononcube/MathematicaForPrediction).

[AAp3] Anton Antonov,
[Monadic Sparse Matrix Recommender Mathematica package](https://github.com/antononcube/MathematicaForPrediction/blob/master/MonadicProgramming/MonadicSparseMatrixRecommender.m),
(2018-2021),
[MathematicaForPrediction at GitHub/antononcube](https://github.com/antononcube/MathematicaForPrediction).

[AAp4] Anton Antonov,
[Monadic Latent Semantic Analysis Mathematica package](https://github.com/antononcube/MathematicaForPrediction/blob/master/MonadicProgramming/MonadicLatentSemanticAnalysis.m),
(2017-2021),
[MathematicaForPrediction at GitHub/antononcube](https://github.com/antononcube/MathematicaForPrediction).


### Python packages

[AAp5] Anton Antonov,
[SSparseMatrix package in Python](https://github.com/antononcube/Python-packages/tree/master/SSparseMatrix)
(2021),
[Python-packages at GitHub/antononcube](https://github.com/antononcube/Python-packages).

[AAp3] Anton Antonov,
[SparseMatrixRecommender Python package](https://github.com/antononcube/Python-packages/tree/main/SparseMatrixRecommender),
(2021-2022),
[Python-packages at GitHub/antononcube](https://github.com/antononcube/Python-packages).
(Also at [PyPI.org](https://pypi.org/project/SparseMatrixRecommender/).)

[AAp6] Anton Antonov,
[LatentSemanticAnalyzer package in Python](https://github.com/antononcube/Python-packages/tree/main/LatentSemanticAnalyzer)
(2021),
[Python-packages at GitHub/antononcube](https://github.com/antononcube/Python-packages).

### R packages

[AAp2] Anton Antonov,
[Sparse Matrix Recommender Monad in R](https://github.com/antononcube/R-packages/tree/master/SMRMon-R)
(2019),
[R-packages at GitHub/antononcube](https://github.com/antononcube/R-packages).

[AAp3] Anton Antonov,
[Sparse Matrix Recommender framework interface functions](https://github.com/antononcube/R-packages/tree/master/SparseMatrixRecommenderInterfaces)
(2019),
[R-packages at GitHub/antononcube](https://github.com/antononcube/R-packages).

[AAp4] Anton Antonov,
[Latent Semantic Analysis Monad in R](https://github.com/antononcube/R-packages/tree/master/LSAMon-R)
(2019),
[R-packages at GitHub/antononcube](https://github.com/antononcube/R-packages).

### Raku packages

[AAr3] Anton Antonov,
[ML::StreamsBlendingRecommender Raku package](https://github.com/antononcube/Raku-ML-StreamsBlendingRecommender),
(2021),
[GitHub/antononcube](https://github.com/antononcube).

### Swift packages

[AAr4] Anton Antonov,
[Swift-StreamsBlendingRecommender](https://github.com/antononcube/Swift-StreamsBlendingRecommender),
(2022),
[GitHub/antononcube](https://github.com/antononcube).

### Videos

*TBD...*

[1]: https://github.com/antononcube/Scalable-Recommender-Framework-project/raw/main/Diagrams/Scalable-Recommender-Framework-mind-map.png
[2]: https://github.com/antononcube/Scalable-Recommender-Framework-project/raw/main/Diagrams/Scalable-Recommender-Framework-mind-map.pdf