#!/usr/bin/env raku
use v6.d;

use lib <. lib>;
use LLM::Functions;
use LLM::Prompts;
use Text::SubParsers;
use LLM::Tooling;
use LLM::Functions::Tooled;
use LLM::Functions::TooledGemini;
use LLM::Functions::TooledChatGPT;
use JavaScript::D3;

use JSON::Fast;

# ==============================================================

# The tool is a sub with all named arguments
my @tool-objects =
        LLM::Tool.new(&js-d3-random-mondrian)
        ;

# Tool spec that is much smaller than the automatic one
# derived llm-tool-definition(&js-d3-random-mondrian)
my @tool-specs = (
{
    :name("js-d3-random-mondrian"),
    :description("Make the JavaScript code of a random Mondrian plot"),
    :parameters({
        :type("object"),
        :properties( {
            "\$width" => { :description("Width of the plot"), :type("integer") },
            "\$height" => { :description("Height of the plot"), :type("integer") }
        }),
        :required([]),
    }),
},
);

say '=' x 100;
#say to-json(sub-info(&js-d3-random-mondrian));
say llm-tool-definition(&js-d3-random-mondrian);
say '=' x 100;

# Configurations
my $conf41-mini = llm-configuration('ChatGPT', model => 'gpt-4.1-mini', :8192max-tokens, temperature => 0.4);
my $conf-gemini-flash = llm-configuration('Gemini', model => 'gemini-2.0-flash', :8192max-tokens, temperature => 0.4);

# A single prompt or an array of prompts:
my $request = 'Generate a random Mondrian with pink background and image width == 450';

#`[
my $final = llm-synthesize-with-tools(
        [$request, llm-prompt('NothingElse')('JavaScript')],
        @tool-objects,
        :@tool-specs,
        :2max-iterations,
        e => $conf41-mini):!echo;
]

sink my $conf = llm-configuration($conf41-mini, tools => @tool-objects);

my $final = llm-synthesize(
        [$request, llm-prompt('NothingElse')('JavaScript')],
        e => $conf):echo;

# Get the assistant text(s)
say $final;