#!/usr/bin/env raku
use v6.d;

use lib 'lib';

use LLM::Functions;

.say for %*ENV.grep({ $_.key ~~ / API / });

#`[
say '=' x 120;

my &f1 = llm-function('Generate 5 city names.', e => 'PaLM');

say &f1;

my $res = &f1(''):echo;

if !?$res {
    say "ERROR:\n{$res.exception}";
}
]


say '=' x 120;

my $chatObj = llm-chat(
        'Pretend you are a friendly snowman. Stay in character for every response you give me. Keep your responses short. Feel free to ask me questions, too.',
        conf => 'PaLM');

say $chatObj.raku;

say '-' x 120;

say "\$chatObj.eval('Who are you') : ";

my $res;
$res = $chatObj.eval('Who are you?'):!echo;

say $res;

#if $res ~~ Failure || $res ~~ X::AdHoc {
#    note 'ERROR:';
#    note $res.raku;
#}
