#!/usr/bin/env raku
use v6.d;

use lib '.';
use lib 'lib';

use LLM::Functions;
use LLM::Functions::Evaluator;

#my $conf = llm-configuration('ChatGPT', model => 'gpt-4-vision-preview');
#my $conf = llm-configuration('Mistral', model => 'mistral-medium');
my $conf = llm-configuration('Llama', model => 'gpt-3.5-turbo');
say $conf;

say llm-evaluator(:$conf);

say llm-evaluator(:$conf).Hash;


#`[
class MyEvaluator {
    has $.conf is rw = Whatever;
    has $.formatron is rw = 'Str';

    #------------------------------------------------------
    #| To Hash
    multi method Hash(::?CLASS:D:--> Hash) {
        return %(conf => self.conf.Hash, formatron => self.formatron);
    }

    #------------------------------------------------------
    #| To string
    multi method Str(::?CLASS:D:-->Str) {
        return self.gist;
    }

    #------------------------------------------------------
    #| To string
    multi method gist(::?CLASS:D:-->Str) {
        return self.Hash>>.gist.Str;
    }

}

my $evlr = MyEvaluator.new(conf => { 3 => 3, 2 => 2 }, formatron => 'Some');

say $evlr.WHAT;
]

#`[
my $evlr2 = LLM::Functions::Evaluator.new(conf => { 3 => 3, 2 => 2 }, formatron => 'Some');

say $evlr2.WHAT;
]