#!/usr/bin/env raku
use v6.d;

# use lib <. lib>;

use LLM::Functions;
use LLM::Tooling;

#===========================================================

#| Another predator duel in film.
sub film-duel(
        Str:D $p,                 #= Predator name
        Str:D $y,                 #= Yakuza member name
        Int:D :$n = 5,            #= Number of attacks
        Numeric:D :$prob = 0.8,   #= Probability the predator to win
        Int:D :$film-year = 2010, #= Film year
        --> Str:D
              ) {
    return "The predator $p {rand ≤ $prob ?? 'wins over' !! 'loses to'} $y after $n attacks.";
}

#| Another predator duel.
sub duel(
        Str:D $p,                #= Predator name
        Str:D $y,                #= Yakuza member name
        --> Str:D
         ) {
    my $n = (1..15).pick;
    my $prob = 0.8;
    return "The predator $p {rand ≤ $prob ?? 'wins over' !! 'loses to'} $y after $n attacks.";
}

#| Current weather retrieval function
sub get_current_weather(
        Str $location,              #= Geo location
        Str $unit = "fahrenheit",   #= Temperature measure unit
                        ) returns Str {
    return "It is currently sunny in $location with a temperature of 72 degrees $unit.";
}

#===========================================================

my @tools = [llm-tool-definition(&duel, format => 'raku'),];
my $conf = llm-configuration('chatgpt', model => 'gpt-4.1', :4096max-tokens, temperature => 0.45, :@tools);

say $conf.Hash.elems;

$conf.tools = @tools;

my @toolObjects = LLM::Tool.new(&duel);

# Make a chat evaluator object
my $llmEvalObj = LLM::Functions::EvaluatorChat.new(:$conf);

# Make a new chat object that uses the chat evaluator object
my $chat = LLM::Functions::Chat.new(llm-evaluator => $llmEvalObj, chat-id => 'new-duel-chat-' ~ now);

my @choices = $chat.eval("Simulate a duel between the Predator Stalker and yakuza Gensho.", format => 'choices'):echo;

say '@choices' => @choices.raku;

my @llmToolRequests = @choices.grep(*<finish_reason> eq 'tool_calls');

say ('@llmToolRequests' => @llmToolRequests.raku);

say @llmToolRequests.head<message><tool_calls>;


say '=' x 100;

my $k = 0;
while @llmToolRequests {

    say '-' x 100;
    say $k++;
    say '-' x 100;

    #$chat.messages.pop;

    $chat.messages.push: {
        role => 'assistant',
        tool_calls => @llmToolRequests.head<message><tool_calls>,
        content => ''
    }

    #note ('@llmToolRequests.head' => @llmToolRequests.head».gist);

    my @toolRequests = llm-tool-requests(@llmToolRequests.head);

    #note (@toolRequests.head);

    my $genRes = generate-llm-tool-response(@toolObjects, @toolRequests.head);

    my %message =
            role => 'tool',
            content => $genRes.head.output,
            tool_call_id => @llmToolRequests.head<message><tool_calls>.head<id>;

    @choices = $chat.eval(%message, format => 'choices');
    @llmToolRequests = @choices.grep(*<finish_reason> eq 'tool_calls');

    say '@llmToolRequests.elems : ', @llmToolRequests.elems;
    #say 'Last response : ', $chat.messages.tail».gist;
}