NAME
====

L10N::AF — Afrikaans localization of Raku

![An Afrikaans word cloud in the shape of the Camelia butterfly, the raku mascot.](./doc/af-wordcloud.svg)


SYNOPSIS
========

~~~~raku
use L10N::AF;

#| Toets vir 'n pangram
sub is-pangram ($sin = vra 'Sin: ') {
    sê so .kl.bevat: alle 'a'..'z' met $sin
}

is-pangram q :tot /GEDIG/;
    Bask with grammars,
    Coax via allomorphs,
    Sequences of huffmanized joy.
GEDIG
# True
~~~~


DESCRIPTION
===========

An Afrikaans localization of the `raku` programming language.
To write `raku` in Afrikaans, include `use L10N::AF` in your program.
Try `afrku` or `lekker` from the shell to preselect it:

~~~~bash
$ lekker -e 'sê "Hallo, Wêreld!"'
Hallo, Wêreld!
~~~~


EXAMPLES
========

~~~~raku
# Trim whitespace (leading and trailing)
sit .sny vir '/pad/na/lêer'.IO.lyne

# List lines containing specified text
.sit as .bevat: 'soekteks' vir '/pad/na/lêer'.IO.lyne
~~~~

Afrikaans translations from English are typically longer.
Care has been taken to try preserve huffmanization by keeping short words short. 


OPTIONS
=======

Some words are in common usage in the shell.
These are kept as alternate translations so either can be used:

| Afrikaans        | English  |
| ---------------- | -------- |
| basisnaam        | basename |
| aanpas-lêermodus | chmod    |
| aanpas-lêerskap  | chown    |
| gids             | dir      |
| gidsnaam         | dirname  |
| sif              | grep     |
| kop              | head     |
| koppel           | link     |
| maak-gids        | mkdir    |
| drukf            | printf   |
| skrap-gids       | rmdir    |
| slaap            | sleep    |
| sorteer          | sort     |
| stert            | tail     |
| ontkoppel        | unlink   |


NOTES
=====

The common array operations [can be confusing](https://stackoverflow.com/questions/19107752/javascript-shift-unshift-mnemonics) (stackoverflow.com) in English.
It makes for a longer translation, but I've thought it necessary to make these clearer by clarifying which end of the `Array` is being operated on and by unifying the actions:

| English        | Afrikaans              |
| -------------- | ---------------------- |
| pop, push      | trek-einde, druk-einde |
| shift, unshift | trek-begin, druk-begin |

Raku and Afrikaans share a composable aspect.
I've tried to uncover and reuse Afrikaans root words:

| Afrikaans                              | English                                 |
| -------------------------------------- | --------------------------------------- |
| Waar, Onwaar                           | True, False                             |
| skrap, skrap-nl, skrap-gids            | delete, chomp, rmdir                    |
| maak-oop, maak-toe, maak, maak-gids    | open, close, make, mkdir                |
| gee, teruggee, opgee, gegewe, vergewe* | return, returns, fail, given, forgiven* |
| afrond, afrondaf, afrondop             | round, floor, ceiling                   |
| stop, stopsein                         | die, fatal                              |

* [Slang::Forgiven](https://raku.land/zef:witawayar/Slang::Forgiven) (raku.land) provides `forgiven`.
I do [not yet know how](https://github.com/mustafaaydn/Slang-Forgiven/issues/1) (github.com) to localize a new statement from an external module.

Abuse by coercive control is not yet addressed by the [Inclusive Naming Initiative](https://inclusivenaming.org/about/) (inclusivenaming.org).
It is [recognized in law](https://en.wikipedia.org/wiki/Controlling_behavior_in_relationships) (wikipedia.org) in England and Wales (2015) and Ireland (2019).
With an awareness of escalatory metaphors and imprecise terminology, I have tried to find translations that are more descriptive, less disproportionate and better suited to a programming language.

In programming context, the word "coerce" is used to change a value between types.
Here I have chosen `herskep` (recreate) rather than "dwang" (coerce).
This ties in with the root term `skep` (create) and with `omskep` (map/convert).
Other de-escalations include:

| English | Afrikaans | English re-translation |
| ------- | --------- | ---------------------- |
| CONTROL | BESTUUR   | manage                 |
| die     | stop      | halt                   |
| fatal   | stopsein  | stop signal            |
| snitch  | aanskou   | to witness             |

`trans` has a [squ***a***sh adverb](https://docs.raku.org/routine/trans) (raku.org) which seems to do the same thing as [method/routine squ***i***sh](https://docs.raku.org/routine/squish) (raku.org).
I kept them the same for now.


BUGS
====

`contant` is translated as `konstant`, but [fails compilation](https://github.com/Raku-L10N/L10N/issues/16) (github.com).
A fix is scheduled for rakudo version 2025.12.
Missing translations (pending upstream definition) include:

* Date methods: `today`, `clone`, `day-of-wwek`, `days-in-month` ...
* Grammar bits: `parse`, `made` ...
* IO/path functions: `copy`, `rename`, ...
* Introspection: `WHAT`, `WHY`, `HOW`, `dd` ...
* Miscellaneous: `cache`, `grab`, `grabpairs`, `pred`, `succ`, `produce`, `throw`, `rotor` ...


AUTHORS
=======

habere-et-dispertire `'groTODeritrepsidTAerebah'.omdraai`

Disclosure -- Afrikaans is not my mother tongue.


COPYRIGHT AND LICENSE
=====================

Copyright 2025 habere-et-dispertire

This library is free software; you can redistribute it and/or modify it under the Artistic License 2.0.

