# Default "Jupyter::Chatbook" packages

#`[
use LLM::Functions;
use LLM::Prompts;
use Text::SubParsers;
use Data::Translators;
use Data::TypeSystem;
use Clipboard :ALL;
use Text::Plot;
use Image::Markup::Utilities;
use WWW::LLaMA;
use WWW::MermaidInk;
use WWW::OpenAI;
use WWW::PaLM;
use WWW::Gemini;
use WWW::WolframAlpha;
use Lingua::Translation::DeepL;
]

# Graphs
use Graph;
use Graph::Classes;

# Data processing
use Data::Reshapers;
use Data::Summarizers;
use Data::Generators;
use Data::TypeSystem;
use Data::Geographics;
use Data::Importers;

# Math
use Math::DistanceFunctions;
use Math::Nearest;
use Math::SparseMatrix;
use Math::Fitting;

# Machine Learning
use ML::FindTextualAnswer;
use ML::NLPTemplateEngine;
use ML::TriesWithFrequencies;
use ML::Clustering;
use ML::AssociationRuleLearning;
use ML::ROCFunctions;

# Graphics
use JavaScript::D3;
use JavaScript::Google::Charts;

# Misc
use Hash::Merge;