role Hash::MutableKeys[$method = "push"] is Hash {

    # Create a local subclass of Proxy (with the same name) that
    # inherits from Cool as well, so that e.g. doing an .uc on the
    # Proxy object will not cause a failure, but instead will DWIM
    my class Proxy is Proxy is Cool { }

    method keys() {
        # Create a Seq that produces Proxy object that will remove
        # the old key and process to the new key on a STORE.  Make
        # sure the keys are sorted to get a reproducible result
        # *and* to make sure the hash iterator doesn't get confused
        # when keys are added / removed while iterating
        callsame.sort.map: -> $key {
            Proxy.new(
              FETCH => { $key },
              STORE => -> $, $new-key {
                  self."$method"($new-key, self.DELETE-KEY($key)<>);
                  $new-key
              }
            )
        }
    }
}

# vim: expandtab shiftwidth=4
