use DSL::Shared::Utilities::DeterminedWordsMatching;

# Data query specific phrases
role DSL::Bulgarian::ClassificationWorkflows::Grammar::ClassificationPhrases  {
    # Tokens
    token accuracy-noun:sym<Bulgarian> { :i 'прецизност' | ([\w]+) <?{ $0.Str ne 'прецизности' and is-bg-fuzzy-match($0.Str, 'прецизност', 2) }> }
    token accuracies-noun:sym<Bulgarian> { :i 'прецизности' | ([\w]+) <?{ $0.Str ne 'прецизност' and is-bg-fuzzy-match($0.Str, 'прецизности', 2) }> }
    token available-adjective:sym<Bulgarian> { :i 'налични' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'налични', 2) }> }
    token characteristic-noun:sym<Bulgarian> { :i 'характеристика' | ([\w]+) <?{ $0.Str ne 'характеристики' and is-bg-fuzzy-match($0.Str, 'характеристика', 2) }> }
    token characteristics-noun:sym<Bulgarian> { :i 'характеристики' | ([\w]+) <?{ $0.Str ne 'характеристика' and is-bg-fuzzy-match($0.Str, 'характеристики', 2) }> }
    token class-adjective:sym<Bulgarian> { :i 'класов' | ([\w]+) <?{ $0.Str !(elem) <класова класово класови клас класове> and is-bg-fuzzy-match($0.Str, 'класов', 2) }> | 'класова' | ([\w]+) <?{ $0.Str !(elem) <класов класово класови класове> and is-bg-fuzzy-match($0.Str, 'класова', 2) }> | 'класово' | ([\w]+) <?{ $0.Str !(elem) <класов класова класови класове> and is-bg-fuzzy-match($0.Str, 'класово', 2) }> | 'класови' | ([\w]+) <?{ $0.Str !(elem) <класов класова класово класове> and is-bg-fuzzy-match($0.Str, 'класови', 2) }> }
    token class-noun:sym<Bulgarian> { :i 'клас' | ([\w]+) <?{ $0.Str ne 'класов' and is-bg-fuzzy-match($0.Str, 'клас', 2) }> }
    token classes-noun:sym<Bulgarian> { :i 'класове' | ([\w]+) <?{ $0.Str !(elem) <класов класова класово класови> and is-bg-fuzzy-match($0.Str, 'класове', 2) }> }
    token classification-noun:sym<Bulgarian> { :i 'классификация' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'классификация', 2) }> }
    token classifier-adjective:sym<Bulgarian> { :i 'класификаторен' | ([\w]+) <?{ $0.Str !(elem) <класификаторна класификаторно класификаторни класификатор класификатори> and is-bg-fuzzy-match($0.Str, 'класификаторен', 2) }> | 'класификаторна' | ([\w]+) <?{ $0.Str !(elem) <класификаторен класификаторно класификаторни класификатор класификатори> and is-bg-fuzzy-match($0.Str, 'класификаторна', 2) }> | 'класификаторно' | ([\w]+) <?{ $0.Str !(elem) <класификаторен класификаторна класификаторни класификатор класификатори> and is-bg-fuzzy-match($0.Str, 'класификаторно', 2) }> | 'класификаторни' | ([\w]+) <?{ $0.Str !(elem) <класификаторен класификаторна класификаторно класификатор класификатори> and is-bg-fuzzy-match($0.Str, 'класификаторни', 2) }> }
    token classifier-noun:sym<Bulgarian> { :i 'класификатор' | ([\w]+) <?{ $0.Str !(elem) <класификаторен класификаторна класификаторно класификаторни класификатори> and is-bg-fuzzy-match($0.Str, 'класификатор', 2) }> }
    token classifiers-noun:sym<Bulgarian> { :i 'класификатори' | ([\w]+) <?{ $0.Str !(elem) <класификаторен класификаторна класификаторно класификаторни класификатор> and is-bg-fuzzy-match($0.Str, 'класификатори', 2) }> }
    token ensemble-noun:sym<Bulgarian> { :i 'ансамбъл' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'ансамбъл', 2) }> }
    token estimates-noun:sym<Bulgarian> { :i 'оценки' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'оценки', 2) }> }
    token fraction-noun:sym<Bulgarian> { :i  'дробна'? 'част'  }
    token importance-adjective:sym<Bulgarian> { :i 'важен' | ([\w]+) <?{ $0.Str !(elem) <важна важно важни> and is-bg-fuzzy-match($0.Str, 'важен', 2) }> | 'важна' | ([\w]+) <?{ $0.Str !(elem) <важен важно важни> and is-bg-fuzzy-match($0.Str, 'важна', 2) }> | 'важно' | ([\w]+) <?{ $0.Str !(elem) <важен важна важни важност> and is-bg-fuzzy-match($0.Str, 'важно', 2) }> | 'важни' | ([\w]+) <?{ $0.Str !(elem) <важен важна важно> and is-bg-fuzzy-match($0.Str, 'важни', 2) }> }
    token importance-noun:sym<Bulgarian> { :i 'важност' | ([\w]+) <?{ $0.Str ne 'важно' and is-bg-fuzzy-match($0.Str, 'важност', 2) }> }
    token info-noun:sym<Bulgarian> { :i 'инфо' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'инфо', 2) }> }
    token information-noun:sym<Bulgarian> { :i 'информация' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'информация', 2) }> }
    token label-noun:sym<Bulgarian> { :i 'етикет' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'етикет', 2) }> }
    token measurement-noun:sym<Bulgarian> { :i 'мярка' | ([\w]+) <?{ $0.Str ne 'мерки' and is-bg-fuzzy-match($0.Str, 'мярка', 2) }> }
    token measurements-noun:sym<Bulgarian> { :i 'мерки' | ([\w]+) <?{ $0.Str ne 'мярка' and is-bg-fuzzy-match($0.Str, 'мерки', 2) }> }
    token operating-adjective:sym<Bulgarian> { :i 'операционен' | ([\w]+) <?{ $0.Str !(elem) <операционна операционно операционни> and is-bg-fuzzy-match($0.Str, 'операционен', 2) }> | 'операционна' | ([\w]+) <?{ $0.Str !(elem) <операционен операционно операционни> and is-bg-fuzzy-match($0.Str, 'операционна', 2) }> | 'операционно' | ([\w]+) <?{ $0.Str !(elem) <операционен операционна операционни> and is-bg-fuzzy-match($0.Str, 'операционно', 2) }> | 'операционни' | ([\w]+) <?{ $0.Str !(elem) <операционен операционна операционно> and is-bg-fuzzy-match($0.Str, 'операционни', 2) }> | 'работен' | ([\w]+) <?{ $0.Str !(elem) <работна работно работни> and is-bg-fuzzy-match($0.Str, 'работен', 2) }> | 'работна' | ([\w]+) <?{ $0.Str !(elem) <работен работно работни> and is-bg-fuzzy-match($0.Str, 'работна', 2) }> | 'работно' | ([\w]+) <?{ $0.Str !(elem) <работен работна работни> and is-bg-fuzzy-match($0.Str, 'работно', 2) }> | 'работни' | ([\w]+) <?{ $0.Str !(elem) <работен работна работно> and is-bg-fuzzy-match($0.Str, 'работни', 2) }> }
    token proportional-adjective:sym<Bulgarian> { :i 'пропорционален' | ([\w]+) <?{ $0.Str !(elem) <пропорционална пропорционално пропорционални> and is-bg-fuzzy-match($0.Str, 'пропорционален', 2) }> | 'пропорционална' | ([\w]+) <?{ $0.Str !(elem) <пропорционален пропорционално пропорционални> and is-bg-fuzzy-match($0.Str, 'пропорционална', 2) }> | 'пропорционално' | ([\w]+) <?{ $0.Str !(elem) <пропорционален пропорционална пропорционални> and is-bg-fuzzy-match($0.Str, 'пропорционално', 2) }> | 'пропорционални' | ([\w]+) <?{ $0.Str !(elem) <пропорционален пропорционална пропорционално> and is-bg-fuzzy-match($0.Str, 'пропорционални', 2) }> }
    token ratio-noun:sym<Bulgarian> { :i 'пропорция' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'пропорция', 2) }> | 'съотношение' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'съотношение', 2) }> }
    token receiver-noun:sym<Bulgarian> { :i 'приемник' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'приемник', 2) }> }
    token resampling-noun:sym<Bulgarian> { :i 'ресемплирай' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'ресемплирай', 2) }> }
    token roc-noun:sym<Bulgarian> { :i 'рхп' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'рхп', 1) }> }
    token rocs-noun:sym<Bulgarian> { :i 'рхп' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'рхп', 1) }> }
    token shuffling-noun:sym<Bulgarian> { :i 'смесване' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'смесване', 2) }> | 'разбъркване' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'разбъркване', 2) }> }
    token split-adjective:sym<Bulgarian> { :i 'цепещ' | ([\w]+) <?{ $0.Str !(elem) <цепеща цепещо цепещи цепи> and is-bg-fuzzy-match($0.Str, 'цепещ', 2) }> | 'цепеща' | ([\w]+) <?{ $0.Str !(elem) <цепещ цепещо цепещи> and is-bg-fuzzy-match($0.Str, 'цепеща', 2) }> | 'цепещо' | ([\w]+) <?{ $0.Str !(elem) <цепещ цепеща цепещи> and is-bg-fuzzy-match($0.Str, 'цепещо', 2) }> | 'цепещи' | ([\w]+) <?{ $0.Str !(elem) <цепещ цепеща цепещо цепи> and is-bg-fuzzy-match($0.Str, 'цепещи', 2) }> | 'раз'? [ 'делящ' | ([\w]+) <?{ $0.Str !(elem) <деляща делящо делящи дели> and is-bg-fuzzy-match($0.Str, 'делящ', 2) }> | 'деляща' | ([\w]+) <?{ $0.Str !(elem) <делящ делящо делящи> and is-bg-fuzzy-match($0.Str, 'деляща', 2) }> | 'делящо' | ([\w]+) <?{ $0.Str !(elem) <делящ деляща делящи> and is-bg-fuzzy-match($0.Str, 'делящо', 2) }> | 'делящи' | ([\w]+) <?{ $0.Str !(elem) <делящ деляща делящо дели> and is-bg-fuzzy-match($0.Str, 'делящи', 2) }> ] }
    token split-directive:sym<Bulgarian> { :i 'дели' | ([\w]+) <?{ $0.Str !(elem) <делящ делящи цепи> and is-bg-fuzzy-match($0.Str, 'дели', 2) }> | 'раздели' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'раздели', 2) }> | 'сцепи' | ([\w]+) <?{ $0.Str ne 'цепи' and is-bg-fuzzy-match($0.Str, 'сцепи', 2) }> | 'цепи' | ([\w]+) <?{ $0.Str !(elem) <цепещ цепещи дели сцепи> and is-bg-fuzzy-match($0.Str, 'цепи', 2) }> }
    token test-verb:sym<Bulgarian> { :i 'тествай' | ([\w]+) <?{ $0.Str !(elem) <тестващ тестваща тестващо тестващи> and is-bg-fuzzy-match($0.Str, 'тествай', 2) }> }
    token testing-adjective:sym<Bulgarian> { :i 'тестващ' | ([\w]+) <?{ $0.Str !(elem) <тествай тестваща тестващо тестващи> and is-bg-fuzzy-match($0.Str, 'тестващ', 2) }> | 'тестваща' | ([\w]+) <?{ $0.Str !(elem) <тествай тестващ тестващо тестващи> and is-bg-fuzzy-match($0.Str, 'тестваща', 2) }> | 'тестващо' | ([\w]+) <?{ $0.Str !(elem) <тествай тестващ тестваща тестващи> and is-bg-fuzzy-match($0.Str, 'тестващо', 2) }> | 'тестващи' | ([\w]+) <?{ $0.Str !(elem) <тествай тестващ тестваща тестващо> and is-bg-fuzzy-match($0.Str, 'тестващи', 2) }> }
    token train-verb:sym<Bulgarian> { :i 'тренирай' | ([\w]+) <?{ is-bg-fuzzy-match($0.Str, 'тренирай', 2) }> }
    token training-adjective:sym<Bulgarian> { :i 'тренироващ' | ([\w]+) <?{ $0.Str !(elem) <тренироваща тренироващо тренироващи> and is-bg-fuzzy-match($0.Str, 'тренироващ', 2) }> | 'тренироваща' | ([\w]+) <?{ $0.Str !(elem) <тренироващ тренироващо тренироващи> and is-bg-fuzzy-match($0.Str, 'тренироваща', 2) }> | 'тренироващо' | ([\w]+) <?{ $0.Str !(elem) <тренироващ тренироваща тренироващи> and is-bg-fuzzy-match($0.Str, 'тренироващо', 2) }> | 'тренироващи' | ([\w]+) <?{ $0.Str !(elem) <тренироващ тренироваща тренироващо> and is-bg-fuzzy-match($0.Str, 'тренироващи', 2) }> }
    token validation-adjective:sym<Bulgarian> { :i 'валидационен' | ([\w]+) <?{ $0.Str !(elem) <валидационна валидационно валидационни> and is-bg-fuzzy-match($0.Str, 'валидационен', 2) }> | 'валидационна' | ([\w]+) <?{ $0.Str !(elem) <валидационен валидационно валидационни> and is-bg-fuzzy-match($0.Str, 'валидационна', 2) }> | 'валидационно' | ([\w]+) <?{ $0.Str !(elem) <валидационен валидационна валидационни> and is-bg-fuzzy-match($0.Str, 'валидационно', 2) }> | 'валидационни' | ([\w]+) <?{ $0.Str !(elem) <валидационен валидационна валидационно> and is-bg-fuzzy-match($0.Str, 'валидационни', 2) }> | 'валидиращ' | ([\w]+) <?{ $0.Str !(elem) <валидираща валидиращо валидиращи> and is-bg-fuzzy-match($0.Str, 'валидиращ', 2) }> | 'валидираща' | ([\w]+) <?{ $0.Str !(elem) <валидиращ валидиращо валидиращи> and is-bg-fuzzy-match($0.Str, 'валидираща', 2) }> | 'валидиращо' | ([\w]+) <?{ $0.Str !(elem) <валидиращ валидираща валидиращи> and is-bg-fuzzy-match($0.Str, 'валидиращо', 2) }> | 'валидиращи' | ([\w]+) <?{ $0.Str !(elem) <валидиращ валидираща валидиращо> and is-bg-fuzzy-match($0.Str, 'валидиращи', 2) }> }

}

