unit grammar DFM::Parser;


=begin pod

=head1 NAME

DFM::Parser - Parse DFM (Delphi Module) text format

=head1 SYNOPSIS

=begin code :lang<raku>

use DFM::Parser;
DFM::Parser.parse: 'a-dfm-file.dfm'.IO.slurp

=end code

=head1 DESCRIPTION

DFM::Parser is the simplest possible parser for DFM files

=head1 AUTHOR

Humberto Massa <humbertomassa@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright © 2025 Humberto Massa

This library is free software; you can redistribute it and/or modify it under either the Artistic License 2.0 or the LGPL v3.0, at your convenience.

=end pod

rule TOP                    { <object> }
rule object                 { 'object' [ <id=identifier> ':' ]? <classname=identifier> <component>* 'end' }
rule component              { <object> || <component-name> '=' <component-value> }
rule component-value        { <string-list> | <number-list> | <items> | <dset> | <string> | <number> | <component-name> }
token number                { '-'? \d+  }
token identifier            { <[A..Z a..z 0..9 _]>+ }
token component-name        { <identifier>+ % '.' }
token simple-string         { "'" ~ "'" $<v> = [.*?]  }
token hashtag-char          { '#' <number> }
token short-string          { [ <simple-string> | <hashtag-char> ]+ }
rule string                 { <short-string>+ % [ <.ws> '+' <.ws> ]  }
rule dset                   { '[' ~ ']' <identifier>* % ',' }
rule string-list            { '(' ~ ')' <string>*  }
rule number-list            { '(' ~ ')' <number>*  }
rule single-item            { 'item' <component>*? 'end' }
rule items                  { '<' ~ '>' <single-item>* }

