
use Data::Dump::Tree ;
use Data::Dump::Tree::Colorizer ;
use Data::Dump::Tree::DescribeBaseObjects ;

role DDTR::DHTML
{
my $a2h = ( [ "'", '"', '&', '<', '>' ] => [ '&apos;', '&quot;', '&amp;', '&lt;', '&gt;' ] ) ;
my $class_bag = (^10_000).BagHash ;

method dump_dhtml($s, *%options) is export { say $.get_dhtml_dump($s, |%options) }

method get_dhtml_dump($s, *%options) is export
{
%options<wrap_data> //= %() ;
my %s := %options<wrap_data> ;

%s<uuid>                 = 0 ;
%s<DHTML>              //= '' ;
%s<class>              //= 'ddt_' ~ $class_bag.grab(1) ;
%s<style_none>         //= 0 ;
%s<collapsed>          //= False ;
%s<button_collapse>    //= True ;
%s<collapse_button_id> //= "%s<class>_button_1" ;
%s<collapse_ids>       //= () ;
%s<button_search>      //= True ;
%s<search_button_id>   //= "%s<class>_button_2" ;

%s<style> //= qq:to/STYLE/ ;
<style type='text/css'>
.button \{font-family:monospace ; outline: 0 ; width: 150px ; background-color: #303030 ; color: #999999 ; border: none;}
a\{text-decoration: none; white-space: pre; }
.%s<class> li \{list-style-type:none ; margin:0 ; padding:0 ; line-height: 1em ; }
.%s<class> ul \{margin:0 ; padding:0 ;}
ul.%s<class> \{padding:0 ; font-family:monospace ; white-space:nowrap ;}
body \{ background-color: #000000 ;}
</style>
STYLE

%s<style> = '' if %s<style_none> ;

qq:to/DHTML/ ;
<?xml version="1.0" encoding="UTF-8"?>

<meta http-equiv="Content-Type" content="text/html charset=UTF-8">

<!DOCTYPE html
     PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
     "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
>

<html>
<!-- Generated by Perl 6 Data::Dumper::Tree::DHTML -->

<body>
%s<style>

<div>
{
(%s<button_collapse>
	?? %s<collapsed>
		?? "   <input class='button' type='button' id='%s<collapse_button_id>' onclick='expand_collapse_%s<class>\(true)' value='Expand'/>\n"
		!! "   <input class='button' type='button' id='%s<collapse_button_id>' onclick='expand_collapse_%s<class>\(true)' value='Collapse'/>\n"
	!! '')

~ # append

(%s<button_search>
	?? "   <input class='button' background-color: #404040 type='button' id='%s<search_button_id>' onclick='search_{%s<class>}()' value='Search'/>\n"
	!! '')
}
</div>

<ul  class='{%s<class>}'>
{ $.wrap_dump($s, |%options) }
</ul>

{ get_javascript :%s }

</body>
</html>
DHTML
}

method wrap_dump($s, *%options)
{
%options<width> = $.width // 1000 ;

my ($r, $wrap_data) = $.get_dump_lines(
		$s,
		:wrap_data(%options<wrap_data>),
		:wrap_header(&header_wrap),
		:wrap_footer(&footer_wrap),

		:colorizer(HtmlColorizer.new),
		:colors<
			reset       "black"

			ddt_address #1010BB   link   #004000    perl_address #995535
			header      #aa00aa   key    #009999    binder #009999
			value       #a5a5a5   wrap   "yellow"

			gl_0 #303030 gl_1 "yellow"  gl_2 "green" gl_3 "red"  gl_4 "blue"

			kb_0 #d7af00   kb_1 #d78700
			kb_2 #0087ff   kb_3 #005fff
			kb_4 #d787af   kb_5 #d75faf
			kb_6 #00af00   kb_7 #008700
			kb_8 #d70000   kb_9 #af0000
			>,

		|%options,
		);

$wrap_data<DHTML>
}

my sub header_wrap(
	\wd, $rendered_lines,
	(@head_glyphs, $glyph, $continuation_glyph, $multi_line_glyph),
	(@kvf, @ks, @vs, @fs),
	Mu $s,
	($depth, $path, $filter_glyph, @renderings),
	($k, $b, $v, $f, ($ddt_address, $link, $perl_address), $final, $want_address),
	)
{
my ($pad, $pad2)  = ( '   ' xx $depth + 1, '   ' xx $depth + 2) ;
my ($class, $uuid) = (wd<class>, wd<class> ~ '_' ~ wd<uuid>) ;
my ($a_uuid, $c_uuid) = ("a_$uuid", "c_$uuid") ;

my $head_html = @head_glyphs.map( { $_[0] ~ $_[1].trans($a2h)  ~ '</font>'} ).join ;
my $head_glyph_html = $head_html ~ $glyph[0] ~ $glyph[1].trans($a2h)  ~ '</font>' ;
my $head_continuation_html = $head_html~ $continuation_glyph[0] ~  $continuation_glyph[1].trans($a2h) ~ '</font>' ;
my $head_continuation_multi_html = $head_continuation_html ~ $multi_line_glyph[0] ~ $multi_line_glyph[1] ~ '</font>' ;

if @kvf
	{
	my $span = $head_glyph_html ;

	$span ~= @kvf[0].map( { $_[0] ~ $_[1].trans($a2h) ~ '</font>'} ).join  ~ '<br>' ;

	if $final
		{
		wd<DHTML> ~= "$pad\<li><a id='$a_uuid' data-final=1>$span\</a>\n" ;
		wd<DHTML> ~= "$pad2\<ul class='$class' id='$c_uuid' style = 'display:none'></ul>\n"
		}
	else
		{
		wd<DHTML> ~= "$pad\<li><a id='$a_uuid' href='javascript:void(0);' onclick='toggleList_$class\(\"$c_uuid\", \"$a_uuid\")'>$span\</a>\n" ;

		wd<DHTML> ~= wd<collapsed>
				?? "$pad2\<ul  class='$class' id='$c_uuid' style = 'display:none'>\n"
				!! "$pad2\<ul  class='$class' id='$c_uuid' style = 'display:block'>\n" ;
		}
	}
else
	{
	#TODO: add \n to make the generated html readable

	wd<DHTML> ~= "$pad\<li><a id='$a_uuid'" ;

	wd<DHTML> ~= $final
		?? " data-final=1>"
		!! " href='javascript:void(0);' onclick='toggleList_$class\(\"$c_uuid\", \"$a_uuid\")'>" ;

	# @ks, @vs, @fs contain a line per entry, each line can be made of multiple components

	if @ks
		{
		wd<DHTML> ~= $head_glyph_html ;
		wd<DHTML> ~= @ks[0].map( { $_[0] ~ $_[1].trans($a2h)  ~ '</font>'} ).join  ~ '<br>' ;
		}

	if @ks > 1
		{
		for @ks[1..*-1] -> $ks
			{
			wd<DHTML> ~= $head_continuation_html ;
			wd<DHTML> ~= $ks.map( { $_[0] ~ $_[1].trans($a2h) ~ '</font>'} ).join ~ '<br>' ;
			}
		}

	for @vs -> $vs
		{
		wd<DHTML> ~= $head_continuation_multi_html ;
		wd<DHTML> ~= $vs.map( { $_[0] ~ $_[1].trans($a2h) ~ '</font>'} ).join ~ '<br>' ;
		} ;

	for @fs -> $fs
		{
		#todo: next if $.display_info == False ;

		wd<DHTML> ~= $head_continuation_multi_html ;
		wd<DHTML> ~= $fs.map( { $_[0] ~ $_[1].trans($a2h) ~ '</font>'} ).join ~ '<br>' ;
		} ;

	wd<DHTML> ~= "</a>\n" ;

	if $final
		{
		wd<DHTML> ~="$pad2\<ul  class='$class' id='$c_uuid' style = 'display:none'></ul>\n" ;
		}
	else
		{
		wd<DHTML> ~= wd<collapsed>
			?? "$pad2\<ul  class='$class' id='$c_uuid' style = 'display:none'>\n"
			!! "$pad2\<ul  class='$class' id='$c_uuid' style = 'display:block'\n>" ;
		}
	}

wd<uuid>++ ;
}

my sub footer_wrap(\wd, Mu $s, $final, ($depth, $filter_glyph, @renderings), $wh_token)
{
wd<DHTML> ~= '   ' xx $depth + 2 ~ "</ul>\n" unless $final ;
wd<DHTML> ~= '   ' xx $depth + 1 ~ "</li>\n" ;
}

my sub get_javascript(:%s)
{
my $class = %s<class> ;

my $a_ids = (^%s<uuid>).map({ "'a_{%s<class>}_{$_}'" }).join(', ') ;
my $collapsable_ids = (^%s<uuid>).map({ "'c_{%s<class>}_{$_}'" }).join(', ') ;

my $collapsed = %s<collapsed> ;

qq:to/EOS/ ;
<script type='text/javascript'>

function _elem_by_id(id)
\{
return document.getElementById(id);
}

function search_{$class}()
\{
var string_to_search = prompt('DDTR::DHTML Search','');
var regexp = new RegExp(string_to_search, 'i') ;

var i ;
for (i = 0 ; i < a_id_array_{$class}.length; i++)
	\{
	if(regexp.test(_elem_by_id(a_id_array_{$class}[i]).text))
		\{
		show_specific_node_{$class}(_elem_by_id(a_id_array_{$class}[i])) ;
		_elem_by_id(a_id_array_{$class}[i]).style.color = '' ;
		_elem_by_id(a_id_array_{$class}[i]).style.backgroundColor = 'cyan' ;
		break ;
		}
	}

return;
}

function show_specific_node_{$class} (node)
\{
collapsed_{$class} = 0; /* hide all */
expand_collapse_{$class}();

do
	\{
	node = node.parentNode;

	if (node && node.tagName == 'UL')
		node.style.display = 'block';

	} while (node && node.parentNode);
}

var a_id_array_{$class}= new Array
		(
		$a_ids
		) ;

var collapsable_id_array_{$class} = new Array
				(
				$collapsable_ids
				) ;

var collapsed_{$class} = { $collapsed ?? 1 !! 0 } ;

function expand_collapse_{$class}()
\{
var style ;
if(collapsed_{$class}== 1)
	\{
	collapsed_{$class} = 0 ;
	color = '' ;
	style = "block" ;
	replace_button_text("{%s<collapse_button_id>}", "Collapse") ;
	}
else
	\{
	collapsed_{$class} = 1 ;
	color = 'magenta' ;
	style = "none" ;
	replace_button_text("{%s<collapse_button_id>}", "Expand") ;
	}

var i;
for (i = 0; i < { %s<uuid> } ; i++)
	\{
	_elem_by_id(collapsable_id_array_{$class}\[i]).style.display = style ;
	_elem_by_id(a_id_array_{$class}[i]).style.backgroundColor = '' ;

	var element = _elem_by_id(a_id_array_{$class}\[i]) ;
	var final =  element.getAttribute('data-final') ;
	if(! final)
		\{
		element.style.color = color ;
		}
	}
}

function replace_button_text(buttonId, text)
\{
var button=_elem_by_id(buttonId);
if (button)
	\{
	if (button.childNodes[0])
		\{
		button.childNodes[0].nodeValue=text;
		}
	else if (button.value)
		\{
		button.value=text;
		}
	else //if (button.innerHTML)
		\{
		button.innerHTML=text;
		}
	}
}

function toggleList_{$class}(tree_id, head_id)
\{
var element = _elem_by_id(tree_id);
if (element)
	\{
	if (element.style.display == 'none')
		\{
		element.style.display = 'block';
		element = _elem_by_id(head_id);
		element.style.color = '' ;
		element.style.backgroundColor = '' ;
		}
	else
		\{
		element.style.display = 'none';
		element = _elem_by_id(head_id);
		element.style.color = 'magenta' ;
		element.style.backgroundColor = '' ;
		}
	}
}

</script>
EOS
}


} # role


