[![Actions Status](https://github.com/arunvickram/DataStar/actions/workflows/linux.yml/badge.svg)](https://github.com/arunvickram/DataStar/actions) [![Actions Status](https://github.com/arunvickram/DataStar/actions/workflows/macos.yml/badge.svg)](https://github.com/arunvickram/DataStar/actions) [![Actions Status](https://github.com/arunvickram/DataStar/actions/workflows/windows.yml/badge.svg)](https://github.com/arunvickram/DataStar/actions)

NAME
====

**DataStar** - the real-time hypermedia framework, Rakufied.

SYNOPSIS
========

```raku
use DataStar;

# in your Cro application
sub routes() is export {
    route {
        post -> 'validate' { 
            content 'text/event-stream', datastar {
                patch-elements '<div>Hello there</div>', 
                    selector => '.validation',
                    mode => PatchMode::AFTER;

                my %new-signals = test => 2;

                patch-signals %signals; 
            }
        }
    }
}
```

DESCRIPTION
===========

**DataStar** is an Raku-language SDK for [data-star](https://data-star.dev/), the reactive hypermedia framework that uses signals and server-sent events to integrate hypermedia applications with reactivity.

AUTHOR
======

    Arun Vickram L<arunvickram@proton.me|mailto:arunvickram@proton.me>

COPYRIGHT AND LICENSE
=====================

© 2025 Arun Vickram

