unit grammar CSS::Module::CSS3::Fonts::AtFontFace::Gen::Grammar;
#| font-family: <family-name>
rule decl:sym<font-family> { :i ("font-family") ":" <val(/<expr=.expr-font-family> /, &?ROUTINE.WHY)>}
rule expr-font-family { :i <family-name> }
#| <identifiers> | <string>
rule family-name { :i <identifiers> || <string>  }
#| font-feature-settings: normal | <feature-tag-value>#
rule decl:sym<font-feature-settings> { :i ("font-feature-settings") ":" <val(/<expr=.expr-font-feature-settings> /, &?ROUTINE.WHY)>}
rule expr-font-feature-settings { :i normal & <keyw>  || <feature-tag-value> +% <op(",")>  }
#| font-stretch: normal | ultra-condensed | extra-condensed | condensed | semi-condensed | semi-expanded | expanded | extra-expanded | ultra-expanded
rule decl:sym<font-stretch> { :i ("font-stretch") ":" <val(/<expr=.expr-font-stretch> /, &?ROUTINE.WHY)>}
rule expr-font-stretch { :i [normal | "ultra-condensed" | "extra-condensed" | condensed | "semi-condensed" | "semi-expanded" | expanded | "extra-expanded" | "ultra-expanded" ]& <keyw>  }
#| font-style: normal | italic | oblique
rule decl:sym<font-style> { :i ("font-style") ":" <val(/<expr=.expr-font-style> /, &?ROUTINE.WHY)>}
rule expr-font-style { :i [normal | italic | oblique ]& <keyw>  }
#| font-variant: normal | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> || stylistic(<feature-value-name>) || historical-forms || styleset(<feature-value-name>#) || character-variant(<feature-value-name>#) || swash(<feature-value-name>) || ornaments(<feature-value-name>) || annotation(<feature-value-name>) || [ small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps ] || <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero || <east-asian-variant-values> || <east-asian-width-values> || ruby ]
rule decl:sym<font-variant> { :i ("font-variant") ":" <val(/<expr=.expr-font-variant> /, &?ROUTINE.WHY)>}
rule expr-font-variant { :i normal & <keyw>  || [[:my @S; <common-lig-values><!{
    @S[0]++
}>| <discretionary-lig-values><!{
    @S[1]++
}>| <historical-lig-values><!{
    @S[2]++
}>| <contextual-alt-values><!{
    @S[3]++
}>| <stylistic><!{
    @S[4]++
}>| "historical-forms" & <keyw> <!{
    @S[5]++
}>| <styleset><!{
    @S[6]++
}>| <character-variant><!{
    @S[7]++
}>| <swash><!{
    @S[8]++
}>| <ornaments><!{
    @S[9]++
}>| <annotation><!{
    @S[10]++
}>| [["small-caps" | "all-small-caps" | "petite-caps" | "all-petite-caps" | unicase | "titling-caps" ]& <keyw> ]<!{
    @S[11]++
}>| <numeric-figure-values><!{
    @S[12]++
}>| <numeric-spacing-values><!{
    @S[13]++
}>| <numeric-fraction-values><!{
    @S[14]++
}>| ordinal & <keyw> <!{
    @S[15]++
}>| "slashed-zero" & <keyw> <!{
    @S[16]++
}>| <east-asian-variant-values><!{
    @S[17]++
}>| <east-asian-width-values><!{
    @S[18]++
}>| ruby & <keyw> <!{
    @S[19]++
}>]+]  }
#| font-weight: normal | bold | 100 | 200 | 300 | 400 | 500 | 600 | 700 | 800 | 900
rule decl:sym<font-weight> { :i ("font-weight") ":" <val(/<expr=.expr-font-weight> /, &?ROUTINE.WHY)>}
rule expr-font-weight { :i [normal | bold ]& <keyw>  || [100 | 200 | 300 | 400 | 500 | 600 | 700 | 800 | 900 ]& <number>  }
#| src: <font-src-expr>#
rule decl:sym<src> { :i (src) ":" <val(/<expr=.expr-src> /, &?ROUTINE.WHY)>}
rule expr-src { :i <font-src-expr> +% <op(",")> }
#| [<uri>|local(<string>)] [format(<string>#)]? | <font-face-name>
rule font-src-expr { :i [<uri> || <local> ] <format> ?  || <font-face-name>  }
#| <identifiers> | <string>
rule font-face-name { :i <identifiers> || <string>  }
#| unicode-range: <urange>#
rule decl:sym<unicode-range> { :i ("unicode-range") ":" <val(/<expr=.expr-unicode-range> /, &?ROUTINE.WHY)>}
rule expr-unicode-range { :i <urange> +% <op(",")> }