unit module CSS::Grammar::Defs;

# These tables map AST types to standard W3C component definitions.

# CSS object definitions based on http://dev.w3.org/csswg/cssom/
# for example 6.4.1 CSSRuleList maps to CSSObject::RuleList
our Str enum CSSObject is export(:CSSObject) «
    :AtRule<at-rule>
    :Priority<prio>
    :RuleSet<ruleset>
    :RuleList<rule-list>
    :StyleDeclaration<style>
    :StyleRule<style-rule>
    :StyleSheet<stylesheet>
    »;

# CSS value types based on http://dev.w3.org/csswg/cssom-values/
# for example 3.3 CSSStyleDeclarationValue maps to CSSValue::StyleDeclaration
our Str enum CSSValue is export(:CSSValue) «
    :ColorComponent<color>
    :Component<value>
    :IdentifierComponent<ident>
    :KeywordComponent<keyw>
    :LengthComponent<length>
    :Map<map>
    :PercentageComponent<percent>
    :Property<property>
    :PropertyList<declarations>
    :StringComponent<string>
    :URLComponent<url>

    :NameComponent<name>
    :NumberComponent<num>
    :IntegerComponent<int>
    :AngleComponent<angle>
    :FrequencyComponent<freq>
    :FunctionComponent<func>
    :ResolutionComponent<resolution>
    :TimeComponent<time>
    :QnameComponent<qname>
    :OtherUnitComponent<units>
    :NamespacePrefixComponent<ns-prefix>
    :ElementNameComponent<element-name>
    :OperatorComponent<op>
    :ExpressionComponent<expr>
    :ArgumentListComponent<args>
    :AtKeywordComponent<at-keyw>
    :UnicodeRangeComponent<unicode-range>
»;

our Str enum CSSSelector is export(:CSSSelector) «
    :AttributeSelector<attrib>
    :Class<class>
    :Id<id>
    :MediaList<media-list>
    :MediaQuery<media-query>
    :PseudoClass<pseudo-class>
    :PseudoElement<pseudo-elem>
    :PseudoFunction<pseudo-func>
    :SelectorList<selectors>
    :Selector<selector>
    :SelectorComponent<simple-selector>
»;

# an enumerated list of all unit types for validation purposes.
# Adapted from the out-of-date http://www.w3.org/TR/DOM-Level-2-Style/css.html

our Str enum CSSUnits is export(:CSSUnits) «
    :ems<length> :exs<length> :px<length> :cm<length> :mm<length> :in<length> :pt<length> :pc<length>
    :em<length> :ex<length> :rem<length> :ch<length> :vw<length> :vh<length> :vmin<length> :vmax<length>
    :dpi<resolution> :dpcm<resolution> :dppx<resolution>
    :deg<angle> :rad<angle> :grad<angle> :turn<angle>
    :ms<time> :s<time>
    :hz<freq> :khz<freq>
    :rgb<color> :rgba<color> :hsl<color> :hsla<color>
»;

# from http://dev.w3.org/csswg/cssom-view/
our Str enum CSSTrait is export(:CSSTrait) «:Box<box>»;

