NAME
====

Anolis

A Terminal Emulator

Synopsis
========

    use Anolis::Interface;
    use Anolis;

    class Interface does Anolis::Interface {
        method heading-changed(Str $heading) { ... }
        method grid-changed(@changed-areas) {
            # Do stuff with the changes.
            # Or access $anolis.screen.grid to read the window.
            
        }
        method log(Str $text) { ... }
    }

    my Proc::Async $proc .= new: :pty(:rows(32), :cols(72)), 'bash';
    my Interface $interface .= new;
    my $anolis = Anolis.new: :$proc-async, :$interface;

    $anolis.send-text('ls\n');


Description
===========

This module implements a Terminal Emulator. It's meant to be connected to a
PTY. Once done, it will read the data stream the child sends and update it's
virtual model of a terminal accordingly. It tries to mimic XTerm and is thus
best used with `TERM=xterm` in the environment.

Currently many features are missing, but enough is implemented to get simple
CLI programs working and not fail too hard with TUI apps. Vim mostly works.


AUTHOR
======

Patrick Böker <patrick.boeker@posteo.de>


License
=======

This module is distributed under the terms of the Artistic License 2.0.


